/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.netconf.api.capability.BasicCapability;
import org.opendaylight.netconf.api.capability.Capability;
import org.opendaylight.netconf.api.capability.YangModuleCapability;
import org.opendaylight.netconf.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.netconf.mapping.api.NetconfOperationServiceFactoryListener;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.DOMDataTransactionValidator;
import org.opendaylight.netconf.mdsal.connector.MdsalNetconfOperationService;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={NetconfOperationServiceFactory.class}, immediate=true, property={"type=mdsal-netconf-connector"})
public final class MdsalNetconfOperationServiceFactory
implements NetconfOperationServiceFactory,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalNetconfOperationServiceFactory.class);
    private static final BasicCapability VALIDATE_CAPABILITY = new BasicCapability("urn:ietf:params:netconf:capability:validate:1.0");
    private final DOMDataBroker dataBroker;
    private final DOMRpcService rpcService;
    private final CurrentSchemaContext currentSchemaContext;
    private final SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency;
    private final NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener;

    @Activate
    public MdsalNetconfOperationServiceFactory(@Reference DOMSchemaService schemaService, @Reference DOMDataBroker dataBroker, @Reference DOMRpcService rpcService, @Reference(target="(type=mapper-aggregator-registry)") NetconfOperationServiceFactoryListener netconfOperationServiceFactoryListener) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.rpcService = Objects.requireNonNull(rpcService);
        this.netconfOperationServiceFactoryListener = Objects.requireNonNull(netconfOperationServiceFactoryListener);
        this.rootSchemaSourceProviderDependency = (SchemaSourceProvider)schemaService.getExtensions().getInstance(DOMYangTextSourceProvider.class);
        this.currentSchemaContext = CurrentSchemaContext.create(Objects.requireNonNull(schemaService), this.rootSchemaSourceProviderDependency);
        netconfOperationServiceFactoryListener.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
    }

    @Override
    @Deactivate
    public void close() {
        this.netconfOperationServiceFactoryListener.onRemoveNetconfOperationServiceFactory((NetconfOperationServiceFactory)this);
        this.currentSchemaContext.close();
    }

    public MdsalNetconfOperationService createService(String netconfSessionIdForReporting) {
        return new MdsalNetconfOperationService(this.currentSchemaContext, netconfSessionIdForReporting, this.dataBroker, this.rpcService);
    }

    public Set<Capability> getCapabilities() {
        return MdsalNetconfOperationServiceFactory.transformCapabilities((SchemaContext)this.currentSchemaContext.getCurrentContext(), this.rootSchemaSourceProviderDependency);
    }

    static Set<Capability> transformCapabilities(SchemaContext currentContext, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency) {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        for (Module module : currentContext.getModules()) {
            Optional<YangModuleCapability> cap = MdsalNetconfOperationServiceFactory.moduleToCapability((ModuleLike)module, rootSchemaSourceProviderDependency);
            if (cap.isPresent()) {
                capabilities.add((Capability)cap.get());
            }
            for (Submodule submodule : module.getSubmodules()) {
                cap = MdsalNetconfOperationServiceFactory.moduleToCapability((ModuleLike)submodule, rootSchemaSourceProviderDependency);
                if (!cap.isPresent()) continue;
                capabilities.add((Capability)cap.get());
            }
        }
        return capabilities;
    }

    private static Optional<YangModuleCapability> moduleToCapability(ModuleLike module, SchemaSourceProvider<YangTextSchemaSource> rootSchemaSourceProviderDependency) {
        String source;
        SourceIdentifier moduleSourceIdentifier = new SourceIdentifier(module.getName(), (String)module.getRevision().map(Revision::toString).orElse(null));
        InputStream sourceStream = null;
        try {
            sourceStream = ((YangTextSchemaSource)rootSchemaSourceProviderDependency.getSource(moduleSourceIdentifier).get()).openStream();
            source = CharStreams.toString((Readable)new InputStreamReader(sourceStream, StandardCharsets.UTF_8));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.warn("Ignoring source for module {}. Unable to read content", (Object)moduleSourceIdentifier, (Object)e);
            source = null;
        }
        try {
            if (sourceStream != null) {
                sourceStream.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Error closing yang source stream {}. Ignoring", (Object)moduleSourceIdentifier, (Object)e);
        }
        if (source != null) {
            return Optional.of(new YangModuleCapability(module, source));
        }
        LOG.warn("Missing source for module {}. This module will not be available from netconf server", (Object)moduleSourceIdentifier);
        return Optional.empty();
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        if (this.dataBroker.getExtensions().get(DOMDataTransactionValidator.class) != null) {
            listener.onCapabilitiesChanged(Set.of(VALIDATE_CAPABILITY), Set.of());
        }
        return this.currentSchemaContext.registerCapabilityListener(listener);
    }
}

