/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class AbstractConfigOperation
extends AbstractSingletonNetconfOperation {
    static final String URL_KEY = "url";
    static final String CONFIG_KEY = "config";
    private static final int TIMEOUT_MS = 5000;

    protected AbstractConfigOperation(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected static NodeList getElementsByTagName(XmlElement parent, String key) throws DocumentedException {
        Element domParent = parent.getDomElement();
        NodeList elementsByTagName = Strings.isNullOrEmpty((String)domParent.getPrefix()) ? domParent.getElementsByTagName(key) : domParent.getElementsByTagNameNS(parent.getNamespace(), key);
        return elementsByTagName;
    }

    static XmlElement getConfigElement(XmlElement parent) throws DocumentedException {
        Optional configElement = parent.getOnlyChildElementOptionally(CONFIG_KEY);
        if (configElement.isPresent()) {
            return (XmlElement)configElement.get();
        }
        Optional urlElement = parent.getOnlyChildElementOptionally(URL_KEY);
        if (urlElement.isEmpty()) {
            throw new DocumentedException("Invalid RPC, neither <config> not <url> element is present", ErrorType.PROTOCOL, ErrorTag.MISSING_ELEMENT, ErrorSeverity.ERROR);
        }
        Document document = AbstractConfigOperation.getDocumentFromUrl(((XmlElement)urlElement.get()).getTextContent());
        return XmlElement.fromDomElementWithExpected((Element)document.getDocumentElement(), (String)CONFIG_KEY, (String)"urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    private static Document getDocumentFromUrl(String url) throws DocumentedException {
        Document document;
        block10: {
            InputStream input = AbstractConfigOperation.openConnection(new URL(url));
            try {
                document = XmlUtil.readXmlToDocument((InputStream)input);
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw new DocumentedException(url + " URL is invalid or unsupported", (Exception)e, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
                }
                catch (IOException e) {
                    throw new DocumentedException("Could not open URL " + url, (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
                }
                catch (SAXException e) {
                    throw new DocumentedException("Could not parse XML at" + url, (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
                }
            }
            input.close();
        }
        return document;
    }

    private static InputStream openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        if (url.getUserInfo() != null) {
            String basicAuth = "Basic " + Base64.getUrlEncoder().encodeToString(url.getUserInfo().getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty("Authorization", basicAuth);
        }
        return connection.getInputStream();
    }
}

