/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractConfigOperation;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class AbstractEdit
extends AbstractConfigOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEdit.class);
    private static final String TARGET_KEY = "target";
    final CurrentSchemaContext schemaContext;

    AbstractEdit(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
    }

    static final void parseIntoNormalizedNode(SchemaTreeInference inference, XmlElement element, NormalizedNodeStreamWriter writer) throws DocumentedException {
        List path = inference.statementPath();
        SchemaTreeEffectiveStatement schemaNode = (SchemaTreeEffectiveStatement)path.get(path.size() - 1);
        if (!(schemaNode instanceof ContainerSchemaNode) && !(schemaNode instanceof ListSchemaNode)) {
            LOG.debug("DataNode from module is not ContainerSchemaNode nor ListSchemaNode, aborting..");
            throw new UnsupportedOperationException("implement exception if parse fails");
        }
        XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (EffectiveStatementInference)inference);
        try {
            xmlParser.traverse(new DOMSource(element.getDomElement()));
        }
        catch (IOException | URISyntaxException | XMLStreamException | SAXException ex) {
            throw new NetconfDocumentedException("Error parsing input: " + ex.getMessage(), ex, ErrorType.PROTOCOL, ErrorTag.MALFORMED_MESSAGE, ErrorSeverity.ERROR);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    final SchemaTreeInference getSchemaNodeFromNamespace(String namespace, XmlElement element) throws DocumentedException {
        XMLNamespace ns;
        try {
            ns = XMLNamespace.of((String)namespace);
        }
        catch (IllegalArgumentException e) {
            throw new NetconfDocumentedException("Unable to create URI for namespace : " + namespace, (Exception)e, ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
        }
        EffectiveModelContext ctx = this.schemaContext.getCurrentContext();
        Iterator<@NonNull E> it = ctx.findModules(ns).iterator();
        if (!it.hasNext()) {
            throw new NetconfDocumentedException("Unable to find module by namespace: " + namespace, ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
        }
        Module module = (Module)it.next();
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)ctx);
        String elementName = element.getName();
        try {
            stack.enterSchemaTree(QName.create((QNameModule)module.getQNameModule(), (String)elementName));
        }
        catch (IllegalArgumentException e) {
            throw new DocumentedException("Unable to find node " + elementName + " with namespace: " + namespace + " in module: " + module, (Exception)e, ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
        }
        return stack.toSchemaTreeInference();
    }

    static final XmlElement extractTargetElement(XmlElement operationElement, String operationName) throws DocumentedException {
        NodeList elementsByTagName = AbstractEdit.getElementsByTagName(operationElement, TARGET_KEY);
        if (elementsByTagName.getLength() == 0) {
            throw new DocumentedException("Missing target element", ErrorType.PROTOCOL, ErrorTag.MISSING_ATTRIBUTE, ErrorSeverity.ERROR, (Map)ImmutableMap.of((Object)"bad-attribute", (Object)TARGET_KEY, (Object)"bad-element", (Object)operationName));
        }
        if (elementsByTagName.getLength() > 1) {
            throw new DocumentedException("Multiple target elements", ErrorType.RPC, ErrorTag.UNKNOWN_ATTRIBUTE, ErrorSeverity.ERROR);
        }
        return XmlElement.fromDomElement((Element)((Element)elementsByTagName.item(0))).getOnlyChildElement();
    }
}

