/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractEdit;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CopyConfig
extends AbstractEdit {
    private static final String OPERATION_NAME = "copy-config";
    private static final String SOURCE_KEY = "source";
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private static final ContainerNode EMPTY_ROOT_NODE;
    private final TransactionProvider transactionProvider;

    public CopyConfig(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting, schemaContext);
        this.transactionProvider = transactionProvider;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        XmlElement targetElement = CopyConfig.extractTargetElement(operationElement, OPERATION_NAME);
        String target = targetElement.getName();
        if (Datastore.running.toString().equals(target)) {
            throw new DocumentedException("edit-config on running datastore is not supported", ErrorType.PROTOCOL, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
        if (Datastore.candidate.toString().equals(target)) {
            this.copyToCandidate(operationElement);
        } else if ("url".equals(target)) {
            this.copyToUrl(targetElement, operationElement);
        } else {
            throw new DocumentedException("Unsupported target: " + target, ErrorType.PROTOCOL, ErrorTag.BAD_ELEMENT, ErrorSeverity.ERROR);
        }
        return document.createElement("ok");
    }

    private void copyToCandidate(XmlElement operationElement) throws DocumentedException {
        XmlElement source = CopyConfig.getSourceElement(operationElement);
        List configElements = CopyConfig.getConfigElement(source).getChildElements();
        DOMDataTreeReadWriteTransaction rwTx = this.transactionProvider.getOrCreateTransaction();
        rwTx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty(), (NormalizedNode)EMPTY_ROOT_NODE);
        for (XmlElement element : configElements) {
            NormalizedNodeResult resultHolder = new NormalizedNodeResult();
            CopyConfig.parseIntoNormalizedNode(this.getSchemaNodeFromNamespace(element.getNamespace(), element), element, ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder));
            NormalizedNode data = resultHolder.getResult();
            YangInstanceIdentifier path = YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)data.getIdentifier());
            rwTx.merge(LogicalDatastoreType.CONFIGURATION, path, data);
        }
    }

    private static XmlElement getSourceElement(XmlElement parent) throws DocumentedException {
        Optional sourceElement = parent.getOnlyChildElementOptionally(SOURCE_KEY);
        if (sourceElement.isEmpty()) {
            throw new DocumentedException("<source> element is missing", ErrorType.PROTOCOL, ErrorTag.MISSING_ELEMENT, ErrorSeverity.ERROR);
        }
        return (XmlElement)sourceElement.get();
    }

    private void copyToUrl(XmlElement urlElement, XmlElement operationElement) throws DocumentedException {
        String url = urlElement.getTextContent();
        if (!url.startsWith("file:")) {
            throw new DocumentedException("Unsupported <url> protocol: " + url, ErrorType.PROTOCOL, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
        XmlElement source = CopyConfig.getSourceElement(operationElement).getOnlyChildElement();
        ContainerNode data = this.readData(source);
        Document document = operationElement.getDomElement().getOwnerDocument();
        Node node = this.transformNormalizedNode(document, data);
        String xml = XmlUtil.toString((Element)((Element)node));
        try {
            Path file = Paths.get(new URI(url));
            Files.write(file, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new DocumentedException("Invalid URI: " + url, e, ErrorType.RPC, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
        }
        catch (IOException e) {
            throw new DocumentedException("Failed to write : " + url, (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
    }

    private ContainerNode readData(XmlElement source) throws DocumentedException {
        Datastore sourceDatastore = CopyConfig.getDatastore(source);
        DOMDataTreeReadWriteTransaction rwTx = this.getTransaction(sourceDatastore);
        YangInstanceIdentifier dataRoot = YangInstanceIdentifier.empty();
        try {
            Optional normalizedNodeOptional = (Optional)rwTx.read(LogicalDatastoreType.CONFIGURATION, dataRoot).get();
            if (sourceDatastore == Datastore.running) {
                this.transactionProvider.abortRunningTransaction(rwTx);
            }
            return (ContainerNode)normalizedNodeOptional.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Unable to read data " + dataRoot, e);
        }
    }

    private static Datastore getDatastore(XmlElement source) throws DocumentedException {
        try {
            return Datastore.valueOf(source.getName());
        }
        catch (IllegalArgumentException e) {
            throw new DocumentedException("Unsupported source for <url> target", (Exception)e, ErrorType.PROTOCOL, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
    }

    private DOMDataTreeReadWriteTransaction getTransaction(Datastore datastore) throws DocumentedException {
        if (datastore == Datastore.candidate) {
            return this.transactionProvider.getOrCreateTransaction();
        }
        if (datastore == Datastore.running) {
            return this.transactionProvider.createRunningTransaction();
        }
        throw new DocumentedException("Incorrect Datastore: ", ErrorType.PROTOCOL, ErrorTag.BAD_ELEMENT, ErrorSeverity.ERROR);
    }

    private Node transformNormalizedNode(Document document, ContainerNode data) {
        Element configElement = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "config");
        DOMResult result = new DOMResult(configElement);
        try {
            XMLStreamWriter xmlWriter = XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
            NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)this.schemaContext.getCurrentContext());
            NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter, (boolean)true);
            for (DataContainerChild child : data.body()) {
                nnWriter.write((NormalizedNode)child);
            }
            nnWriter.flush();
            xmlWriter.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return result.getNode();
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }

    static {
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        EMPTY_ROOT_NODE = (ContainerNode)Builders.containerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(SchemaContext.NAME)).build();
    }
}

