/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteOperations;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.EffectiveOperation;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.TransactionProvider;
import org.opendaylight.netconf.mdsal.connector.ops.AbstractEdit;
import org.opendaylight.netconf.mdsal.connector.ops.DataTreeChange;
import org.opendaylight.netconf.mdsal.connector.ops.Datastore;
import org.opendaylight.netconf.mdsal.connector.ops.SplittingNormalizedNodeMetadataStreamWriter;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class EditConfig
extends AbstractEdit {
    private static final Logger LOG = LoggerFactory.getLogger(EditConfig.class);
    private static final String OPERATION_NAME = "edit-config";
    private static final String DEFAULT_OPERATION = "default-operation";
    private final TransactionProvider transactionProvider;

    public EditConfig(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, TransactionProvider transactionProvider) {
        super(netconfSessionIdForReporting, schemaContext);
        this.transactionProvider = Objects.requireNonNull(transactionProvider);
    }

    protected String getOperationName() {
        return OPERATION_NAME;
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        if (Datastore.valueOf(EditConfig.extractTargetElement(operationElement, OPERATION_NAME).getName()) == Datastore.running) {
            throw new DocumentedException("edit-config on running datastore is not supported", ErrorType.PROTOCOL, ErrorTag.OPERATION_NOT_SUPPORTED, ErrorSeverity.ERROR);
        }
        EffectiveOperation defaultAction = EditConfig.getDefaultOperation(operationElement);
        for (XmlElement element : EditConfig.getConfigElement(operationElement).getChildElements()) {
            SplittingNormalizedNodeMetadataStreamWriter writer = new SplittingNormalizedNodeMetadataStreamWriter(defaultAction);
            EditConfig.parseIntoNormalizedNode(this.getSchemaNodeFromNamespace(element.getNamespace(), element), element, writer);
            this.executeOperations(writer.getDataTreeChanges());
        }
        return document.createElement("ok");
    }

    private void executeOperations(List<DataTreeChange> changes) throws DocumentedException {
        DOMDataTreeReadWriteTransaction rwTx = this.transactionProvider.getOrCreateTransaction();
        ListIterator<DataTreeChange> iterator = changes.listIterator(changes.size());
        while (iterator.hasPrevious()) {
            this.executeChange(rwTx, iterator.previous());
        }
    }

    private void executeChange(DOMDataTreeReadWriteTransaction rwtx, DataTreeChange change) throws DocumentedException {
        YangInstanceIdentifier path = change.getPath();
        NormalizedNode changeData = change.getChangeRoot();
        switch (change.getAction()) {
            case NONE: {
                return;
            }
            case MERGE: {
                this.mergeParentMixin((DOMDataTreeWriteOperations)rwtx, path, changeData);
                rwtx.merge(LogicalDatastoreType.CONFIGURATION, path, changeData);
                break;
            }
            case CREATE: {
                try {
                    if (((Boolean)rwtx.exists(LogicalDatastoreType.CONFIGURATION, path).get()).booleanValue()) {
                        throw new DocumentedException("Data already exists, cannot execute CREATE operation", ErrorType.PROTOCOL, ErrorTag.DATA_EXISTS, ErrorSeverity.ERROR);
                    }
                    this.mergeParentMixin((DOMDataTreeWriteOperations)rwtx, path, changeData);
                    rwtx.put(LogicalDatastoreType.CONFIGURATION, path, changeData);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Read from datastore failed when trying to read data for create operation {}", (Object)change, (Object)e);
                }
                break;
            }
            case REPLACE: {
                this.mergeParentMixin((DOMDataTreeWriteOperations)rwtx, path, changeData);
                rwtx.put(LogicalDatastoreType.CONFIGURATION, path, changeData);
                break;
            }
            case DELETE: {
                try {
                    if (!((Boolean)rwtx.exists(LogicalDatastoreType.CONFIGURATION, path).get()).booleanValue()) {
                        throw new DocumentedException("Data is missing, cannot execute DELETE operation", ErrorType.PROTOCOL, ErrorTag.DATA_MISSING, ErrorSeverity.ERROR);
                    }
                    rwtx.delete(LogicalDatastoreType.CONFIGURATION, path);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("Read from datastore failed when trying to read data for delete operation {}", (Object)change, (Object)e);
                }
                break;
            }
            case REMOVE: {
                rwtx.delete(LogicalDatastoreType.CONFIGURATION, path);
                break;
            }
            default: {
                LOG.warn("Unknown/not implemented operation, not executing");
            }
        }
    }

    private void mergeParentMixin(DOMDataTreeWriteOperations rwtx, YangInstanceIdentifier path, NormalizedNode change) {
        YangInstanceIdentifier parentNodeYid = path.getParent();
        if (change instanceof MapEntryNode) {
            DataSchemaNode dataSchemaNode = ((DataSchemaContextNode)DataSchemaContextTree.from((EffectiveModelContext)this.schemaContext.getCurrentContext()).findChild(parentNodeYid).orElseThrow(() -> new IllegalStateException("Cannot find schema for " + parentNodeYid))).getDataSchemaNode();
            if (!(dataSchemaNode instanceof ListSchemaNode)) {
                throw new IllegalStateException("Schema node is not pointing to a list");
            }
            ListSchemaNode listSchemaNode = (ListSchemaNode)dataSchemaNode;
            rwtx.merge(LogicalDatastoreType.CONFIGURATION, parentNodeYid, (listSchemaNode.isUserOrdered() ? Builders.orderedMapBuilder() : Builders.mapBuilder()).withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(parentNodeYid.getLastPathArgument().getNodeType())).build());
        } else {
            YangInstanceIdentifier.PathArgument pathArgument = parentNodeYid.getLastPathArgument();
            if (pathArgument instanceof YangInstanceIdentifier.AugmentationIdentifier) {
                YangInstanceIdentifier.AugmentationIdentifier augId = (YangInstanceIdentifier.AugmentationIdentifier)pathArgument;
                rwtx.merge(LogicalDatastoreType.CONFIGURATION, parentNodeYid, Builders.augmentationBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)augId).build());
            }
        }
    }

    private static EffectiveOperation getDefaultOperation(XmlElement operationElement) throws DocumentedException {
        NodeList elementsByTagName = EditConfig.getElementsByTagName(operationElement, DEFAULT_OPERATION);
        return switch (elementsByTagName.getLength()) {
            case 0 -> EffectiveOperation.MERGE;
            case 1 -> EffectiveOperation.ofXmlValue((String)elementsByTagName.item(0).getTextContent());
            default -> throw new DocumentedException("Multiple default-operation elements", ErrorType.RPC, ErrorTag.UNKNOWN_ATTRIBUTE, ErrorSeverity.ERROR);
        };
    }
}

