/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.mapping.api.HandlingPriority;
import org.opendaylight.netconf.mapping.api.NetconfOperationChainedExecution;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.util.mapping.AbstractSingletonNetconfOperation;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaOrderedNormalizedNodeWriter;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RuntimeRpc
extends AbstractSingletonNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeRpc.class);
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private final CurrentSchemaContext schemaContext;
    private final DOMRpcService rpcService;

    public RuntimeRpc(String netconfSessionIdForReporting, CurrentSchemaContext schemaContext, DOMRpcService rpcService) {
        super(netconfSessionIdForReporting);
        this.schemaContext = schemaContext;
        this.rpcService = rpcService;
    }

    protected HandlingPriority canHandle(String netconfOperationName, String namespace) {
        XMLNamespace namespaceURI = RuntimeRpc.createNsUri(namespace);
        Optional<? extends Module> module = this.getModule(namespaceURI);
        if (module.isEmpty()) {
            LOG.debug("Cannot handle rpc: {}, {}", (Object)netconfOperationName, (Object)namespace);
            return HandlingPriority.CANNOT_HANDLE;
        }
        RuntimeRpc.getRpcDefinitionFromModule(module.orElseThrow(), namespaceURI, netconfOperationName);
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected String getOperationName() {
        throw new UnsupportedOperationException("Runtime rpc does not have a stable name");
    }

    private static XMLNamespace createNsUri(String namespace) {
        return XMLNamespace.of((String)namespace);
    }

    private Optional<? extends Module> getModule(XMLNamespace namespace) {
        return this.schemaContext.getCurrentContext().findModules(namespace).stream().findFirst();
    }

    private static Optional<RpcDefinition> getRpcDefinitionFromModule(Module module, XMLNamespace namespace, String name) {
        for (RpcDefinition rpcDef : module.getRpcs()) {
            if (!rpcDef.getQName().getNamespace().equals((Object)namespace) || !rpcDef.getQName().getLocalName().equals(name)) continue;
            return Optional.of(rpcDef);
        }
        return Optional.empty();
    }

    protected Element handleWithNoSubsequentOperations(Document document, XmlElement operationElement) throws DocumentedException {
        DOMRpcResult result;
        String netconfOperationNamespace;
        String netconfOperationName = operationElement.getName();
        try {
            netconfOperationNamespace = operationElement.getNamespace();
        }
        catch (DocumentedException e) {
            LOG.debug("Cannot retrieve netconf operation namespace from message due to ", (Throwable)e);
            throw new DocumentedException("Cannot retrieve netconf operation namespace from message", (Exception)((Object)e), ErrorType.PROTOCOL, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
        }
        XMLNamespace namespaceURI = RuntimeRpc.createNsUri(netconfOperationNamespace);
        Optional<? extends Module> moduleOptional = this.getModule(namespaceURI);
        if (moduleOptional.isEmpty()) {
            throw new DocumentedException("Unable to find module in Schema Context with namespace and name : " + namespaceURI + " " + netconfOperationName + this.schemaContext.getCurrentContext(), ErrorType.APPLICATION, ErrorTag.BAD_ELEMENT, ErrorSeverity.ERROR);
        }
        Optional<RpcDefinition> rpcDefinitionOptional = RuntimeRpc.getRpcDefinitionFromModule(moduleOptional.orElseThrow(), namespaceURI, netconfOperationName);
        if (rpcDefinitionOptional.isEmpty()) {
            throw new DocumentedException("Unable to find RpcDefinition with namespace and name : " + namespaceURI + " " + netconfOperationName, ErrorType.APPLICATION, ErrorTag.BAD_ELEMENT, ErrorSeverity.ERROR);
        }
        RpcDefinition rpcDefinition = rpcDefinitionOptional.orElseThrow();
        ContainerNode inputNode = this.rpcToNNode(operationElement, rpcDefinition);
        try {
            result = (DOMRpcResult)this.rpcService.invokeRpc(rpcDefinition.getQName(), inputNode).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw DocumentedException.wrap((Exception)e);
        }
        if (result.value() == null) {
            return XmlUtil.createElement((Document)document, (String)"ok", Optional.of("urn:ietf:params:xml:ns:netconf:base:1.0"));
        }
        return this.transformNormalizedNode(document, (NormalizedNode)result.value(), SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{rpcDefinition.getQName(), rpcDefinition.getOutput().getQName()}));
    }

    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        XmlElement requestElement = RuntimeRpc.getRequestElementWithCheck((Document)requestMessage);
        Document document = XmlUtil.newDocument();
        XmlElement operationElement = requestElement.getOnlyChildElement();
        Map attributes = requestElement.getAttributes();
        Element response = this.handle(document, operationElement, subsequentOperation);
        Element rpcReply = XmlUtil.createElement((Document)document, (String)"rpc-reply", Optional.of("urn:ietf:params:xml:ns:netconf:base:1.0"));
        if (XmlElement.fromDomElement((Element)response).hasNamespace()) {
            rpcReply.appendChild(response);
        } else {
            NodeList list = response.getChildNodes();
            if (list.getLength() == 0) {
                rpcReply.appendChild(response);
            } else {
                while (list.getLength() != 0) {
                    rpcReply.appendChild(list.item(0));
                }
            }
        }
        for (Attr attribute : attributes.values()) {
            rpcReply.setAttributeNode((Attr)document.importNode(attribute, true));
        }
        document.appendChild(rpcReply);
        return document;
    }

    private Element transformNormalizedNode(Document document, NormalizedNode data, SchemaNodeIdentifier.Absolute rpcOutputPath) {
        DOMResult result = new DOMResult(document.createElement("rpc-reply"));
        XMLStreamWriter xmlWriter = RuntimeRpc.getXmlStreamWriter(result);
        NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlWriter, (EffectiveModelContext)this.schemaContext.getCurrentContext(), (SchemaNodeIdentifier.Absolute)rpcOutputPath);
        SchemaOrderedNormalizedNodeWriter nnWriter = new SchemaOrderedNormalizedNodeWriter(nnStreamWriter, this.schemaContext.getCurrentContext(), rpcOutputPath);
        RuntimeRpc.writeRootElement(xmlWriter, nnWriter, (ContainerNode)data);
        try {
            nnStreamWriter.close();
            xmlWriter.close();
        }
        catch (IOException | XMLStreamException e) {
            LOG.warn("Error while closing streams", (Throwable)e);
        }
        return (Element)result.getNode();
    }

    private static XMLStreamWriter getXmlStreamWriter(DOMResult result) {
        try {
            return XML_OUTPUT_FACTORY.createXMLStreamWriter(result);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeRootElement(XMLStreamWriter xmlWriter, SchemaOrderedNormalizedNodeWriter nnWriter, ContainerNode data) {
        try {
            nnWriter.write(data.body());
            nnWriter.flush();
            xmlWriter.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private @Nullable ContainerNode rpcToNNode(XmlElement element, RpcDefinition rpcDefinition) throws DocumentedException {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (EffectiveStatementInference)SchemaInferenceStack.of((EffectiveModelContext)this.schemaContext.getCurrentContext(), (SchemaNodeIdentifier.Absolute)SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{rpcDefinition.getQName(), rpcDefinition.getInput().getQName()})).toInference());
        try {
            xmlParser.traverse(new DOMSource(element.getDomElement()));
        }
        catch (IOException | URISyntaxException | XMLStreamException | SAXException ex) {
            throw new NetconfDocumentedException("Error parsing input: " + ex.getMessage(), ex, ErrorType.PROTOCOL, ErrorTag.MALFORMED_MESSAGE, ErrorSeverity.ERROR);
        }
        return (ContainerNode)resultHolder.getResult();
    }

    static {
        XML_OUTPUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
    }
}

