/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops.get;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.mdsal.connector.CurrentSchemaContext;
import org.opendaylight.netconf.mdsal.connector.ops.get.UniversalNamespaceContextImpl;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.codec.TypeAwareCodec;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FilterContentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FilterContentValidator.class);
    private final CurrentSchemaContext schemaContext;

    public FilterContentValidator(CurrentSchemaContext schemaContext) {
        this.schemaContext = schemaContext;
    }

    public YangInstanceIdentifier validate(XmlElement filterContent) throws DocumentedException {
        XMLNamespace namespace;
        try {
            namespace = XMLNamespace.of((String)filterContent.getNamespace());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong namespace in element + " + filterContent.toString(), e);
        }
        try {
            Module module = (Module)this.schemaContext.getCurrentContext().findModules(namespace).iterator().next();
            DataSchemaNode schema = this.getRootDataSchemaNode(module, namespace, filterContent.getName());
            FilterTree filterTree = this.validateNode(filterContent, schema, new FilterTree(schema.getQName(), Type.OTHER, schema));
            return this.getFilterDataRoot(filterTree, filterContent, YangInstanceIdentifier.builder());
        }
        catch (ValidationException e) {
            LOG.debug("Filter content isn't valid", (Throwable)e);
            throw new DocumentedException("Validation failed. Cause: " + e.getMessage(), (Exception)e, ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
        }
    }

    private DataSchemaNode getRootDataSchemaNode(Module module, XMLNamespace nameSpace, String name) throws DocumentedException {
        for (DataSchemaNode childNode : module.getChildNodes()) {
            QName qName = childNode.getQName();
            if (!qName.getNamespace().equals((Object)nameSpace) || !qName.getLocalName().equals(name)) continue;
            return childNode;
        }
        throw new DocumentedException("Unable to find node with namespace: " + nameSpace + " in schema context: " + this.schemaContext.getCurrentContext(), ErrorType.APPLICATION, ErrorTag.UNKNOWN_NAMESPACE, ErrorSeverity.ERROR);
    }

    private FilterTree validateNode(XmlElement element, DataSchemaNode parentNodeSchema, FilterTree tree) throws ValidationException {
        for (XmlElement childElement : element.getChildElements()) {
            try {
                Deque path = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentNodeSchema, (String)childElement.getName(), (XMLNamespace)XMLNamespace.of((String)childElement.getNamespace()));
                if (path.isEmpty()) {
                    throw new ValidationException(element, childElement);
                }
                FilterTree subtree = tree;
                for (DataSchemaNode dataSchemaNode : path) {
                    subtree = subtree.addChild(dataSchemaNode);
                }
                DataSchemaNode childSchema = (DataSchemaNode)path.getLast();
                this.validateNode(childElement, childSchema, subtree);
            }
            catch (IllegalArgumentException | MissingNameSpaceException e) {
                throw new IllegalArgumentException("Wrong namespace in element + " + childElement.toString(), e);
            }
        }
        return tree;
    }

    private YangInstanceIdentifier getFilterDataRoot(FilterTree tree, XmlElement filterContent, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        builder.node(tree.getName());
        ArrayList<String> path = new ArrayList<String>();
        FilterTree current = tree;
        while (current.size() == 1) {
            FilterTree child = current.getChildren().iterator().next();
            if (child.getType() == Type.CHOICE_CASE) {
                current = child;
                continue;
            }
            builder.node(child.getName());
            path.add(child.getName().getLocalName());
            if (child.getType() == Type.LIST) {
                this.appendKeyIfPresent(current, child, filterContent, path, builder);
                return builder.build();
            }
            current = child;
        }
        return builder.build();
    }

    private void appendKeyIfPresent(FilterTree parent, FilterTree list, XmlElement filterContent, List<String> pathToList, YangInstanceIdentifier.InstanceIdentifierBuilder builder) {
        Preconditions.checkArgument((boolean)(list.getSchemaNode() instanceof ListSchemaNode));
        ListSchemaNode listSchemaNode = (ListSchemaNode)list.getSchemaNode();
        DataSchemaNode parentSchemaNode = parent.getSchemaNode();
        Map<QName, Object> map = this.getKeyValues(pathToList, filterContent, parentSchemaNode, listSchemaNode);
        if (!map.isEmpty()) {
            builder.nodeWithKey(list.getName(), map);
        }
    }

    private Map<QName, Object> getKeyValues(List<String> path, XmlElement filterContent, DataSchemaNode parentSchemaNode, ListSchemaNode listSchemaNode) {
        XmlElement current = filterContent;
        for (String pathElement : path) {
            List childElements = current.getChildElements(pathElement);
            if (childElements.size() != 1) {
                return Map.of();
            }
            current = (XmlElement)childElements.get(0);
        }
        HashMap<QName, Object> keys = new HashMap<QName, Object>();
        List keyDefinition = listSchemaNode.getKeyDefinition();
        for (QName qualifiedName : keyDefinition) {
            Optional childElements = current.getOnlyChildElementOptionally(qualifiedName.getLocalName());
            if (childElements.isEmpty()) {
                return Map.of();
            }
            Optional keyValue = ((XmlElement)childElements.get()).getOnlyTextContentOptionally();
            if (!keyValue.isPresent()) continue;
            LeafSchemaNode listKey = (LeafSchemaNode)listSchemaNode.getDataChildByName(qualifiedName);
            if (listKey instanceof IdentityrefTypeDefinition) {
                keys.put(qualifiedName, keyValue.get());
                continue;
            }
            TypeDefinition keyType = listKey.getType();
            if (keyType instanceof IdentityrefTypeDefinition || keyType instanceof LeafrefTypeDefinition) {
                Document document = filterContent.getDomElement().getOwnerDocument();
                UniversalNamespaceContextImpl nsContext = new UniversalNamespaceContextImpl(document, false);
                EffectiveModelContext modelContext = this.schemaContext.getCurrentContext();
                XmlCodecFactory xmlCodecFactory = XmlCodecFactory.create((EffectiveModelContext)modelContext);
                SchemaInferenceStack resolver = SchemaInferenceStack.of((EffectiveModelContext)modelContext, (SchemaNodeIdentifier.Absolute)SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{parentSchemaNode.getQName(), listSchemaNode.getQName(), listKey.getQName()}));
                TypeAwareCodec typeCodec = xmlCodecFactory.codecFor((TypeAware)listKey, (LeafrefResolver)resolver);
                Object deserializedKeyValue = typeCodec.parseValue((Object)nsContext, (String)keyValue.get());
                keys.put(qualifiedName, deserializedKeyValue);
                continue;
            }
            Object deserializedKey = TypeDefinitionAwareCodec.from((TypeDefinition)keyType).deserialize((Object)((String)keyValue.get()));
            keys.put(qualifiedName, deserializedKey);
        }
        return keys;
    }

    private static final class FilterTree {
        private final Map<QName, FilterTree> children = new HashMap<QName, FilterTree>();
        private final DataSchemaNode schemaNode;
        private final QName name;
        private final Type type;

        FilterTree(QName name, Type type, DataSchemaNode schemaNode) {
            this.name = name;
            this.type = type;
            this.schemaNode = schemaNode;
        }

        FilterTree addChild(DataSchemaNode data) {
            Type childType = data instanceof CaseSchemaNode ? Type.CHOICE_CASE : (data instanceof ListSchemaNode ? Type.LIST : Type.OTHER);
            QName childName = data.getQName();
            FilterTree childTree = this.children.get(childName);
            if (childTree == null) {
                childTree = new FilterTree(childName, childType, data);
            }
            this.children.put(childName, childTree);
            return childTree;
        }

        Collection<FilterTree> getChildren() {
            return this.children.values();
        }

        QName getName() {
            return this.name;
        }

        Type getType() {
            return this.type;
        }

        DataSchemaNode getSchemaNode() {
            return this.schemaNode;
        }

        int size() {
            return this.children.size();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("size", this.size()).toString();
        }
    }

    private static enum Type {
        LIST,
        CHOICE_CASE,
        OTHER;

    }

    private static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ValidationException(XmlElement parent, XmlElement child) {
            super("Element " + child + " can't be child of " + parent);
        }
    }
}

