/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.mdsal.connector.ops.get;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UniversalNamespaceContextImpl
implements NamespaceContext {
    private static final String DEFAULT_NS = "DEFAULT";
    private final Map<String, String> prefix2Uri = new HashMap<String, String>();
    private final Map<String, String> uri2Prefix = new HashMap<String, String>();

    public UniversalNamespaceContextImpl(Document document, boolean toplevelOnly) {
        this.readNode(document.getFirstChild(), toplevelOnly);
    }

    private void readNode(Node node, boolean attributesOnly) {
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            this.storeAttr((Attr)attribute);
        }
        if (!attributesOnly) {
            NodeList chields = node.getChildNodes();
            for (int i = 0; i < chields.getLength(); ++i) {
                Node chield = chields.item(i);
                if (chield.getNodeType() != 1) continue;
                this.readNode(chield, false);
            }
        }
    }

    private void storeAttr(Attr attribute) {
        if (attribute.getNamespaceURI() != null && attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) {
            if (attribute.getNodeName().equals("xmlns")) {
                this.putInCache(DEFAULT_NS, attribute.getNodeValue());
            } else {
                this.putInCache(attribute.getLocalName(), attribute.getNodeValue());
            }
        }
    }

    private void putInCache(String prefix, String uri) {
        this.prefix2Uri.put(prefix, uri);
        this.uri2Prefix.put(uri, prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.prefix2Uri.get(DEFAULT_NS);
        }
        return this.prefix2Uri.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.uri2Prefix.get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return null;
    }
}

