/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.HashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

public final class SchemaContextUtil {
    private SchemaContextUtil() {
    }

    public static Set<SourceIdentifier> getConstituentModuleIdentifiers(SchemaContext context) {
        HashSet<SourceIdentifier> ret = new HashSet<SourceIdentifier>();
        for (Module module : context.getModules()) {
            ret.add(SchemaContextUtil.moduleToIdentifier((ModuleLike)module));
            for (Submodule submodule : module.getSubmodules()) {
                ret.add(SchemaContextUtil.moduleToIdentifier((ModuleLike)submodule));
            }
        }
        return ret;
    }

    private static SourceIdentifier moduleToIdentifier(ModuleLike module) {
        return new SourceIdentifier(UnresolvedQName.Unqualified.of((String)module.getName()), (Revision)module.getRevision().orElse(null));
    }
}

