/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.ChangePropertyKey;
import org.openrewrite.yaml.CommentOutProperty;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public class RemoveApplicabilityTestFromYamlRecipe
extends Recipe {
    public String getDisplayName() {
        return "Remove any-source applicability and migrate single-source applicability tests in YAML recipe";
    }

    public String getDescription() {
        return "Removes any-source applicability tests from YAML recipes, as the are no longer supported in Rewrite 8 and migrates single-source applicability tests to preconditions.";
    }

    public Set<String> getTags() {
        return Collections.singleton("Rewrite8 migration");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        YamlIsoVisitor<ExecutionContext> yamlRecipeCheckVisitor = new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                List keys = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).map(Yaml.Mapping.Entry::getKey).map(YamlKey::getValue).collect(Collectors.toList());
                Collections.reverse(keys);
                String prop = String.join((CharSequence)".", keys);
                if (prop.equals("applicability.anySource") || prop.equals("applicability.singleSource")) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)entry);
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)yamlRecipeCheckVisitor, (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree visited = new ChangePropertyKey("applicability.singleSource", "preconditions", Boolean.valueOf(false), null).getVisitor().visit(tree, (Object)ctx);
                String commentText = "Applicability tests are no longer supported for yaml recipes, please remove or require migrating the recipe to Java code";
                return (Yaml)new CommentOutProperty("applicability.anySource", commentText).getVisitor().visit(visited, (Object)ctx);
            }
        });
    }
}

