/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class ParenthesizeVisitor<P>
extends JavaVisitor<P> {
    private final boolean recursive;

    public ParenthesizeVisitor() {
        this.recursive = true;
    }

    private ParenthesizeVisitor(boolean recursive) {
        this.recursive = recursive;
    }

    public static Expression maybeParenthesize(Expression newTree, Cursor cursor) {
        if (!(newTree instanceof J.Binary || newTree instanceof J.Unary || newTree instanceof J.Ternary || newTree instanceof J.Assignment || newTree instanceof J.InstanceOf || newTree instanceof J.TypeCast || newTree instanceof J.SwitchExpression)) {
            return newTree;
        }
        Tree originalTree = (Tree)cursor.getValue();
        Expression newTreeWithOriginalId = (Expression)newTree.withId(originalTree.getId());
        J result = (J)new ParenthesizeVisitor(false).visit(newTreeWithOriginalId, 0, cursor.getParentOrThrow());
        if (result instanceof J.Parentheses) {
            return new J.Parentheses(Tree.randomId(), newTree.getPrefix(), Markers.EMPTY, JRightPadded.build(newTree.withPrefix(Space.EMPTY)));
        }
        return newTree;
    }

    @Override
    public J visitBinary(J.Binary binary, P p) {
        J.Binary j;
        J j2 = j = this.recursive ? super.visitBinary(binary, p) : binary;
        if (!(j instanceof J.Binary)) {
            return j;
        }
        J.Binary b = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (this.needsParentheses(b, parent.getValue())) {
            return this.parenthesize(b);
        }
        if (parent.getValue() instanceof J.InstanceOf) {
            return this.parenthesize(b);
        }
        if (parent.getValue() instanceof J.Binary) {
            J.Binary parentBinary = (J.Binary)parent.getValue();
            if (b.getOperator() == J.Binary.Type.Addition && parentBinary.getOperator() == J.Binary.Type.Addition) {
                boolean isStringContext;
                boolean bl = isStringContext = this.isStringType(b.getType()) || this.isStringType(parentBinary.getType()) || this.isStringType(b.getLeft().getType()) || this.isStringType(b.getRight().getType()) || this.isStringType(parentBinary.getLeft().getType()) || this.isStringType(parentBinary.getRight().getType());
                if (isStringContext) {
                    return this.handleStringConcatenation(b, parentBinary);
                }
            }
            if (this.needsParenthesesForPrecedence(b, parentBinary)) {
                return this.parenthesize(b);
            }
        }
        return b;
    }

    private J handleStringConcatenation(J.Binary inner, J.Binary outer) {
        boolean outerLeftString = this.isStringType(outer.getLeft().getType());
        boolean innerLeftString = this.isStringType(inner.getLeft().getType());
        boolean innerRightString = this.isStringType(inner.getRight().getType());
        if (outerLeftString && !innerLeftString && !innerRightString && inner.isScope(outer.getRight())) {
            return this.parenthesize(inner);
        }
        if (!outerLeftString && (innerLeftString || innerRightString) && inner.isScope(outer.getRight())) {
            return this.parenthesize(inner);
        }
        boolean outerRightString = this.isStringType(outer.getRight().getType());
        if (!innerLeftString && !innerRightString && outerRightString && inner.isScope(outer.getRight())) {
            return inner;
        }
        if (this.needsParenthesesForPrecedence(inner, outer)) {
            return this.parenthesize(inner);
        }
        return inner;
    }

    private boolean isStringType(@Nullable JavaType type) {
        if (type == JavaType.Primitive.String) {
            return true;
        }
        if (type == null || type instanceof JavaType.Primitive) {
            return false;
        }
        return TypeUtils.isAssignableTo("java.lang.String", type);
    }

    private boolean needsParentheses(Expression expr, Object parent) {
        return parent instanceof J.Unary || parent instanceof J.MethodInvocation && expr.isScope(((J.MethodInvocation)parent).getSelect()) || expr instanceof J.SwitchExpression;
    }

    private boolean needsParenthesesForPrecedence(J.Binary inner, J.Binary outer) {
        boolean isMulDivGroup;
        int outerPrecedence;
        int innerPrecedence = this.getPrecedence(inner.getOperator());
        if (innerPrecedence > (outerPrecedence = this.getPrecedence(outer.getOperator()))) {
            return false;
        }
        if (innerPrecedence < outerPrecedence) {
            return true;
        }
        boolean isAddSubGroup = this.isInAddSubGroup(inner.getOperator()) && this.isInAddSubGroup(outer.getOperator());
        boolean bl = isMulDivGroup = this.isInMulDivGroup(inner.getOperator()) && this.isInMulDivGroup(outer.getOperator());
        if (isAddSubGroup || isMulDivGroup) {
            boolean innerIsRightOperandOfOuter;
            if (this.isAssociative(inner.getOperator()) && this.isAssociative(outer.getOperator())) {
                return false;
            }
            if (!(this.isAssociative(inner.getOperator()) && this.isAssociative(outer.getOperator()) && inner.getOperator() == outer.getOperator() || !(innerIsRightOperandOfOuter = outer.getRight().isScope(inner)))) {
                return true;
            }
        }
        return inner.getOperator() != outer.getOperator() && !isAddSubGroup && !isMulDivGroup;
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, P p) {
        J.TypeCast j;
        J j2 = j = this.recursive ? super.visitTypeCast(typeCast, p) : typeCast;
        if (!(j instanceof J.TypeCast)) {
            return j;
        }
        J.TypeCast tc = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (this.needsParentheses(tc, parent.getValue())) {
            return this.parenthesize(tc);
        }
        if (parent.getValue() instanceof J.Binary || parent.getValue() instanceof J.Unary || parent.getValue() instanceof J.InstanceOf) {
            return this.parenthesize(tc);
        }
        return tc;
    }

    @Override
    public J visitUnary(J.Unary unary, P p) {
        J.Unary parentUnary;
        J.Unary j;
        J j2 = j = this.recursive ? super.visitUnary(unary, p) : unary;
        if (!(j instanceof J.Unary)) {
            return j;
        }
        J.Unary u = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (u.getOperator() == J.Unary.Type.Not && parent.getValue() instanceof J.Unary) {
            return u;
        }
        if (this.needsParentheses(u, parent.getValue())) {
            return this.parenthesize(u);
        }
        if (parent.getValue() instanceof J.Unary && (parentUnary = (J.Unary)parent.getValue()).getOperator() != u.getOperator()) {
            return this.parenthesize(u);
        }
        return u;
    }

    @Override
    public J visitTernary(J.Ternary ternary, P p) {
        J.Ternary j;
        J j2 = j = this.recursive ? super.visitTernary(ternary, p) : ternary;
        if (!(j instanceof J.Ternary)) {
            return j;
        }
        J.Ternary t = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (this.needsParentheses(t, parent.getValue())) {
            return this.parenthesize(t);
        }
        if (parent.getValue() instanceof J.Binary || parent.getValue() instanceof J.InstanceOf) {
            return this.parenthesize(t);
        }
        return t;
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, P p) {
        J.InstanceOf j;
        J j2 = j = this.recursive ? super.visitInstanceOf(instanceOf, p) : instanceOf;
        if (!(j instanceof J.InstanceOf)) {
            return j;
        }
        J.InstanceOf i = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (parent.getValue() instanceof J.Unary || parent.getValue() instanceof J.MethodInvocation || parent.getValue() instanceof J.NewClass) {
            return this.parenthesize(i);
        }
        if (parent.getValue() instanceof J.Binary) {
            J.Binary parentBinary = (J.Binary)parent.getValue();
            int instanceOfPrecedence = 2;
            int parentPrecedence = this.getPrecedence(parentBinary.getOperator());
            if (parentPrecedence > instanceOfPrecedence && parentBinary.getRight().isScope(i)) {
                return this.parenthesize(i);
            }
        }
        return i;
    }

    @Override
    public J visitAssignment(J.Assignment assignment, P p) {
        J.Assignment j;
        J j2 = j = this.recursive ? super.visitAssignment(assignment, p) : assignment;
        if (!(j instanceof J.Assignment)) {
            return j;
        }
        J.Assignment a = j;
        Cursor parent = this.getCursor().getParentTreeCursor();
        if (parent.getValue() instanceof J.Binary || parent.getValue() instanceof J.Unary || parent.getValue() instanceof J.Ternary) {
            return this.parenthesize(a);
        }
        return a;
    }

    @Override
    public J visitSwitchExpression(J.SwitchExpression switch_, P p) {
        return this.parenthesize((Expression)super.visitSwitchExpression(switch_, p));
    }

    private boolean isInAddSubGroup(J.Binary.Type operator) {
        return operator == J.Binary.Type.Addition || operator == J.Binary.Type.Subtraction;
    }

    private boolean isInMulDivGroup(J.Binary.Type operator) {
        return operator == J.Binary.Type.Multiplication || operator == J.Binary.Type.Division || operator == J.Binary.Type.Modulo;
    }

    private int getPrecedence(J.Binary.Type operator) {
        switch (operator) {
            case Multiplication: 
            case Division: 
            case Modulo: {
                return 5;
            }
            case Addition: 
            case Subtraction: {
                return 4;
            }
            case LeftShift: 
            case RightShift: 
            case UnsignedRightShift: {
                return 3;
            }
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case Equal: 
            case NotEqual: {
                return 2;
            }
            case BitAnd: {
                return 1;
            }
            case BitOr: {
                return -1;
            }
            case And: {
                return -2;
            }
            case Or: {
                return -3;
            }
        }
        return 0;
    }

    private boolean isAssociative(J.Binary.Type operator) {
        switch (operator) {
            case Multiplication: 
            case Addition: 
            case BitAnd: 
            case BitOr: 
            case And: 
            case Or: 
            case BitXor: {
                return true;
            }
        }
        return false;
    }

    private <T extends Expression> Expression parenthesize(T tree) {
        if (tree instanceof J.Parentheses) {
            return tree;
        }
        return new J.Parentheses(Tree.randomId(), tree.getPrefix(), Markers.EMPTY, JRightPadded.build(tree.withPrefix(Space.EMPTY)));
    }
}

