/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class Spaces
extends Recipe {
    public String getDisplayName() {
        return "Spaces";
    }

    public String getDescription() {
        return "Format whitespace in Java code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return sourceFile instanceof J.CompilationUnit;
            }

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    return new SpacesVisitor((SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu, IntelliJ::spaces), (EmptyForInitializerPadStyle)Style.from(EmptyForInitializerPadStyle.class, (SourceFile)cu), (EmptyForIteratorPadStyle)Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu)).visit((Tree)cu, ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }
        };
    }

    public static <J2 extends J> J2 formatSpaces(J j, Cursor cursor) {
        SourceFile cu = (SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class);
        SpacesStyle style = (SpacesStyle)Style.from(SpacesStyle.class, (SourceFile)cu);
        return (J2)((J)new SpacesVisitor(style == null ? IntelliJ.spaces() : style, (EmptyForInitializerPadStyle)Style.from(EmptyForInitializerPadStyle.class, (SourceFile)cu), (EmptyForIteratorPadStyle)Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu)).visitNonNull(j, 0, cursor));
    }
}

