/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddManagedDependencyVisitor;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class AddManagedDependency
extends ScanningRecipe<Scanned> {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.apache.logging.log4j:ARTIFACT_ID:VERSION'.", example="org.apache.logging.log4j")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.apache.logging.log4j:log4j-bom:VERSION'.", example="log4j-bom")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="latest.release")
    private final String version;
    @Option(displayName="Scope", description="An optional scope to use for the dependency management tag.", example="import", valid={"import", "runtime", "provided", "test"}, required=false)
    @Nullable
    private final String scope;
    @Option(displayName="Type", description="An optional type to use for the dependency management tag.", valid={"jar", "pom", "war"}, example="pom", required=false)
    @Nullable
    private final String type;
    @Option(displayName="Classifier", description="An optional classifier to use for the dependency management tag", example="test", required=false)
    @Nullable
    private final String classifier;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Releases only", description="Whether to exclude snapshots from consideration when using a semver selector", required=false)
    @Nullable
    private final Boolean releasesOnly;
    @Option(displayName="Only if using glob expression for group:artifact", description="Only add managed dependencies to projects having a dependency matching the expression.", example="org.apache.logging.log4j:log4j*", required=false)
    @Nullable
    private final String onlyIfUsing;
    @Option(displayName="Add to the root pom", description="Add to the root pom where root is the eldest parent of the pom within the source set.", required=false)
    @Nullable
    private final Boolean addToRootPom;

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.or(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        if (!StringUtils.isNullOrEmpty((String)this.onlyIfUsing)) {
            validated = validated.and(Validated.test((String)"onlyIfUsing", (String)"invalid group:artifact glob pattern", (Object)this.onlyIfUsing, s -> {
                try {
                    return this.onlyIfUsing.matches("[\\w.-]+\\*?:([\\w-]+\\*?|\\*)");
                }
                catch (Throwable t) {
                    return false;
                }
            }));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Add managed Maven dependency";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.version);
    }

    public String getDescription() {
        return "Add a managed Maven dependency to a `pom.xml` file.";
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        Scanned scanned = new Scanned();
        scanned.usingType = this.onlyIfUsing == null;
        return scanned;
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return Preconditions.check((acc.usingType || !StringUtils.isNullOrEmpty((String)this.onlyIfUsing) && this.onlyIfUsing.contains(":") ? 1 : 0) != 0, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                document.getMarkers().findFirst(MavenResolutionResult.class).ifPresent(mavenResolutionResult -> {
                    if (mavenResolutionResult.getParent() == null) {
                        acc2.rootPoms.add((SourceFile)document);
                    }
                });
                if (acc.usingType) {
                    return (Xml.Document)SearchResult.found((Tree)document);
                }
                return super.visitDocument(document, ctx);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                String[] ga;
                ResolvedDependency match;
                ResolvedDependency dependency;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isDependencyTag() && (dependency = this.findDependency(t, null)) != null && (match = dependency.findDependency((ga = Objects.requireNonNull(AddManagedDependency.this.onlyIfUsing).split(":"))[0], ga[1])) != null) {
                    acc.usingType = true;
                }
                return t;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check((boolean)acc.usingType, (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Validated versionValidation;
                Xml maven = super.visitDocument(document, (Object)ctx);
                if ((!Boolean.TRUE.equals(AddManagedDependency.this.addToRootPom) || acc.rootPoms.contains(document)) && (versionValidation = Semver.validate((String)AddManagedDependency.this.version, (String)AddManagedDependency.this.versionPattern)).isValid()) {
                    VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)versionValidation.getValue());
                    try {
                        String versionToUse = this.findVersionToUse(versionComparator, ctx);
                        if (!Objects.equals(versionToUse, this.existingManagedDependencyVersion())) {
                            this.doAfterVisit((TreeVisitor)new AddManagedDependencyVisitor(AddManagedDependency.this.groupId, AddManagedDependency.this.artifactId, versionToUse, AddManagedDependency.this.scope, AddManagedDependency.this.type, AddManagedDependency.this.classifier));
                            this.maybeUpdateModel();
                        }
                    }
                    catch (MavenDownloadingException e) {
                        return (Xml)e.warn(document);
                    }
                }
                return maven;
            }

            @Nullable
            private String existingManagedDependencyVersion() {
                return this.getResolutionResult().getPom().getDependencyManagement().stream().map(resolvedManagedDep -> {
                    if (resolvedManagedDep.matches(AddManagedDependency.this.groupId, AddManagedDependency.this.artifactId, AddManagedDependency.this.type, AddManagedDependency.this.classifier)) {
                        return resolvedManagedDep.getGav().getVersion();
                    }
                    if (resolvedManagedDep.getRequestedBom() != null && resolvedManagedDep.getRequestedBom().getGroupId().equals(AddManagedDependency.this.groupId) && resolvedManagedDep.getRequestedBom().getArtifactId().equals(AddManagedDependency.this.artifactId)) {
                        return resolvedManagedDep.getRequestedBom().getVersion();
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst().orElse(null);
            }

            @Nullable
            private String findVersionToUse(VersionComparator versionComparator, ExecutionContext ctx) throws MavenDownloadingException {
                MavenMetadata mavenMetadata = AddManagedDependency.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(AddManagedDependency.this.groupId, AddManagedDependency.this.artifactId, ctx));
                LatestRelease latest = new LatestRelease(AddManagedDependency.this.versionPattern);
                return mavenMetadata.getVersioning().getVersions().stream().filter(v -> versionComparator.isValid(null, v)).filter(v -> !Boolean.TRUE.equals(AddManagedDependency.this.releasesOnly) || latest.isValid(null, v)).max((v1, v2) -> versionComparator.compare(null, v1, v2)).orElse(null);
            }
        });
    }

    public AddManagedDependency(String groupId, String artifactId, String version, @Nullable String scope, @Nullable String type, @Nullable String classifier, @Nullable String versionPattern, @Nullable Boolean releasesOnly, @Nullable String onlyIfUsing, @Nullable Boolean addToRootPom) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.versionPattern = versionPattern;
        this.releasesOnly = releasesOnly;
        this.onlyIfUsing = onlyIfUsing;
        this.addToRootPom = addToRootPom;
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getReleasesOnly() {
        return this.releasesOnly;
    }

    @Nullable
    public String getOnlyIfUsing() {
        return this.onlyIfUsing;
    }

    @Nullable
    public Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @NonNull
    public String toString() {
        return "AddManagedDependency(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", versionPattern=" + this.getVersionPattern() + ", releasesOnly=" + this.getReleasesOnly() + ", onlyIfUsing=" + this.getOnlyIfUsing() + ", addToRootPom=" + this.getAddToRootPom() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddManagedDependency)) {
            return false;
        }
        AddManagedDependency other = (AddManagedDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$releasesOnly = this.getReleasesOnly();
        Boolean other$releasesOnly = other.getReleasesOnly();
        if (this$releasesOnly == null ? other$releasesOnly != null : !((Object)this$releasesOnly).equals(other$releasesOnly)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$onlyIfUsing = this.getOnlyIfUsing();
        String other$onlyIfUsing = other.getOnlyIfUsing();
        return !(this$onlyIfUsing == null ? other$onlyIfUsing != null : !this$onlyIfUsing.equals(other$onlyIfUsing));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddManagedDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $releasesOnly = this.getReleasesOnly();
        result = result * 59 + ($releasesOnly == null ? 43 : ((Object)$releasesOnly).hashCode());
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $onlyIfUsing = this.getOnlyIfUsing();
        result = result * 59 + ($onlyIfUsing == null ? 43 : $onlyIfUsing.hashCode());
        return result;
    }

    static class Scanned {
        boolean usingType;
        List<SourceFile> rootPoms = new ArrayList<SourceFile>();

        Scanned() {
        }
    }
}

