/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.client.notifications;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bimserver.client.notifications.NotificationsManager;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.json.ConvertException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class WebSocketImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketImpl.class);
    private Session session;
    private NotificationsManager socketNotificationsClient;
    private CountDownLatch countDownLatch = new CountDownLatch(1);

    public WebSocketImpl(NotificationsManager socketNotificationsClient) {
        this.socketNotificationsClient = socketNotificationsClient;
    }

    public void close() {
        this.session.close();
    }

    public void waitForEndpointId() {
        try {
            this.countDownLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.session = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        System.out.println("Connect");
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        try {
            System.out.println(msg);
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(msg));
            JsonParser parser = new JsonParser();
            JsonElement parse = parser.parse(jsonReader);
            if (parse instanceof JsonObject) {
                JsonObject object = (JsonObject)parse;
                if (object.has("welcome")) {
                    String token = this.socketNotificationsClient.getBimServerClient().getToken();
                    this.session.getRemote().sendString("{\"token\":\"" + token + "\"}");
                } else if (object.has("endpointid")) {
                    this.socketNotificationsClient.setEndpointId(object.get("endpointid").getAsLong());
                    this.countDownLatch.countDown();
                } else {
                    try {
                        this.socketNotificationsClient.handleIncoming(object.get("request").getAsJsonObject());
                    }
                    catch (UserException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                    catch (ConvertException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

