/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.osexpress.parser;

import antlr.CommonAST;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import net.sourceforge.osexpress.parser.ExpressLexer;
import net.sourceforge.osexpress.parser.ExpressParser;
import net.sourceforge.osexpress.parser.ExpressParserTokenTypes;
import net.sourceforge.osexpress.parser.Scope;

public class EasyParser {
    private InputStream expin;
    private static final String TOKENOBJECTCLASS = "antlr.CommonHiddenStreamToken";

    public EasyParser(String filename) throws IOException {
        FileInputStream in = null;
        ByteArrayInputStream buff = null;
        File file = new File(filename);
        int length = (int)file.length();
        byte[] fileContent = new byte[length];
        in = new FileInputStream(file);
        in.read(fileContent);
        in.close();
        buff = new ByteArrayInputStream(fileContent);
        buff.mark(length);
        this.expin = buff;
    }

    public EasyParser(BufferedInputStream bis) throws IOException {
        bis.mark(Integer.MAX_VALUE);
        this.expin = bis;
    }

    public EasyParser(Vector<String> filenames) throws IOException {
        int i;
        FileInputStream in = null;
        ByteArrayInputStream buff = null;
        int wlength = 0;
        int sz = filenames.size();
        File[] fs = new File[sz];
        int[] flength = new int[sz];
        for (i = 0; i < sz; ++i) {
            fs[i] = new File(filenames.elementAt(i));
            flength[i] = (int)fs[i].length();
            wlength += flength[i];
        }
        byte[] filesContent = new byte[wlength];
        int tlength = 0;
        for (i = 0; i < sz; ++i) {
            int length = flength[i];
            in = new FileInputStream(fs[i]);
            in.read(filesContent, tlength, length);
            in.close();
            tlength += length;
        }
        buff = new ByteArrayInputStream(filesContent);
        buff.mark(wlength);
        this.expin = buff;
    }

    public CommonAST parse() throws IOException, RecognitionException, TokenStreamException {
        ExpressParser parser = this.createFirstPassParser();
        parser.syntax();
        parser.processExternals();
        Scope rootScope = parser.rootScope;
        parser = this.createSecondPassParser(rootScope);
        parser.syntax();
        this.expin.close();
        CommonAST cast = (CommonAST)parser.getAST();
        return cast;
    }

    private ExpressParser createFirstPassParser() {
        ExpressLexer lexer = new ExpressLexer(this.expin);
        ExpressParser parser = new ExpressParser(lexer);
        lexer.setParser(parser);
        return parser;
    }

    private ExpressParser createSecondPassParser(Scope rootScope) throws IOException {
        this.expin.reset();
        ExpressLexer lexer = new ExpressLexer(this.expin);
        lexer.setTokenObjectClass(TOKENOBJECTCLASS);
        TokenStreamHiddenTokenFilter filter = this.createFilter(lexer);
        ExpressParser parser = new ExpressParser((TokenStream)filter);
        lexer.setParser(parser);
        parser.setRootScope(rootScope);
        return parser;
    }

    private TokenStreamHiddenTokenFilter createFilter(ExpressLexer lexer) {
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.discard(ExpressParserTokenTypes.COMMENT.getIndex());
        filter.discard(ExpressParserTokenTypes.LINECOMMENT.getIndex());
        filter.discard(ExpressParserTokenTypes.WHERE_CLAUSE.getIndex());
        return filter;
    }
}

