/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.osexpress.parser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.osexpress.parser.EnumerationType;
import net.sourceforge.osexpress.parser.ExpressParserTokenTypes;
import net.sourceforge.osexpress.parser.ExternalId;

public class Scope
implements Cloneable {
    public int scopeId = globalId++;
    private static int globalId = 1;
    private Hashtable<String, ExpressParserTokenTypes> idtable;
    private boolean entity;
    private Hashtable entities;
    private Vector superentities;
    private Vector externals;
    private boolean extdone = false;
    private Vector allReferencedSchemas;
    private Vector allUsedSchemas;
    private Vector enumerationTypes;
    public Scope parent;
    public Scope next;

    public void addId(String id, ExpressParserTokenTypes type) {
        ExpressParserTokenTypes i = this.idtable.get(id.toLowerCase());
        if (i == null) {
            this.idtable.put(id.toLowerCase(), type);
        } else {
            System.err.println("Warning: id \"" + id + "\" already defined");
        }
    }

    public void addEnumerationType(EnumerationType et) {
        int sz = et.getCount();
        for (int i = 0; i < sz; ++i) {
            String id = et.getEnumerationId(i);
            ExpressParserTokenTypes ii = this.idtable.get(id.toLowerCase());
            if (ii == null) {
                this.idtable.put(id.toLowerCase(), ExpressParserTokenTypes.ENUMERATION_IDENT);
                continue;
            }
            if (ii == ExpressParserTokenTypes.ENUMERATION_IDENT) continue;
            System.err.println("Warning: id \"" + id + "\" already defined");
        }
        if (this.enumerationTypes == null) {
            this.enumerationTypes = new Vector();
        }
        this.enumerationTypes.add(et);
    }

    public EnumerationType searchEnumerationType(String name) {
        if (this.enumerationTypes != null) {
            int sz = this.enumerationTypes.size();
            for (int i = 0; i < sz; ++i) {
                EnumerationType et = (EnumerationType)this.enumerationTypes.elementAt(i);
                if (!et.typename.equals(name)) continue;
                return et;
            }
        }
        return null;
    }

    public void addEntityScope(String name, Scope s) {
        Object o = this.entities.get(name.toLowerCase());
        if (o == null) {
            this.entities.put(name.toLowerCase(), s);
        } else {
            System.err.println("Warning: entity \"" + name + "\" already defined in this scope");
        }
    }

    public void addSuperEntity(String name) {
        this.superentities.add(name);
    }

    public ExpressParserTokenTypes searchId(String id) {
        ExpressParserTokenTypes i = id == null ? null : this.idtable.get(id.toLowerCase());
        if (i == null) {
            if (this.entity && (i = this.searchInheritanceTree(id)) != null) {
                if (i == ExpressParserTokenTypes.ATTRIBUTE_IDENT) {
                    if (this.parent != null) {
                        ExpressParserTokenTypes it = this.parent.searchId(id);
                        if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                            return ExpressParserTokenTypes.ENTITY_ATTR_IDENT;
                        }
                        if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                            return ExpressParserTokenTypes.TYPE_ATTR_IDENT;
                        }
                    }
                } else if (i == ExpressParserTokenTypes.VARIABLE_IDENT) {
                    if (this.parent != null) {
                        ExpressParserTokenTypes it = this.parent.searchId(id);
                        if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                            return ExpressParserTokenTypes.ENTITY_VAR_IDENT;
                        }
                        if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                            return ExpressParserTokenTypes.TYPE_VAR_IDENT;
                        }
                    }
                } else if (i == ExpressParserTokenTypes.PARAMETER_IDENT && this.parent != null) {
                    ExpressParserTokenTypes it = this.parent.searchId(id);
                    if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                        return ExpressParserTokenTypes.ENTITY_PARAM_IDENT;
                    }
                    if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                        return ExpressParserTokenTypes.TYPE_PARAM_IDENT;
                    }
                }
                return i;
            }
            if (this.parent != null) {
                return this.parent.searchId(id);
            }
            return ExpressParserTokenTypes.IDENT;
        }
        if (i == ExpressParserTokenTypes.ATTRIBUTE_IDENT) {
            if (this.parent != null) {
                ExpressParserTokenTypes it = this.parent.searchId(id);
                if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                    return ExpressParserTokenTypes.ENTITY_ATTR_IDENT;
                }
                if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                    return ExpressParserTokenTypes.TYPE_ATTR_IDENT;
                }
            }
        } else if (i == ExpressParserTokenTypes.VARIABLE_IDENT) {
            if (this.parent != null) {
                ExpressParserTokenTypes it = this.parent.searchId(id);
                if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                    return ExpressParserTokenTypes.ENTITY_VAR_IDENT;
                }
                if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                    return ExpressParserTokenTypes.TYPE_VAR_IDENT;
                }
            }
        } else if (i == ExpressParserTokenTypes.PARAMETER_IDENT && this.parent != null) {
            ExpressParserTokenTypes it = this.parent.searchId(id);
            if (it == ExpressParserTokenTypes.ENTITY_IDENT) {
                return ExpressParserTokenTypes.ENTITY_PARAM_IDENT;
            }
            if (it == ExpressParserTokenTypes.TYPE_IDENT) {
                return ExpressParserTokenTypes.TYPE_PARAM_IDENT;
            }
        }
        return i;
    }

    public ExpressParserTokenTypes searchInheritanceTree(String id) {
        ExpressParserTokenTypes i = this.idtable.get(id.toLowerCase());
        if (i != null) {
            return i;
        }
        int sz = this.superentities.size();
        if (sz > 0) {
            for (int j = 0; j < sz && i == null; ++j) {
                String name = (String)this.superentities.elementAt(j);
                if (this.parent == null) continue;
                Scope ent = this.parent.searchEntity(name);
                if (ent == null) {
                    System.err.println("Error: unable to resolve entity \"" + name + "\"");
                    continue;
                }
                i = ent.searchInheritanceTree(id);
            }
        }
        return i;
    }

    public Scope searchEntity(String name) {
        Scope ent = (Scope)this.entities.get(name.toLowerCase());
        if (ent == null && this.parent != null) {
            ent = this.parent.searchEntity(name);
        }
        return ent;
    }

    public void addExternal(ExternalId ei) {
        if (this.externals == null) {
            this.externals = new Vector();
        }
        this.externals.add(ei);
    }

    public Vector getReferencedExternals() {
        Vector<ExternalId> res = null;
        Enumeration<String> e = this.idtable.keys();
        while (e.hasMoreElements()) {
            String id = e.nextElement();
            ExpressParserTokenTypes type = this.idtable.get(id.toLowerCase());
            if (type != ExpressParserTokenTypes.CONSTANT_IDENT && type != ExpressParserTokenTypes.ENTITY_IDENT && type != ExpressParserTokenTypes.FUNCTION_IDENT && type != ExpressParserTokenTypes.PROCEDURE_IDENT && type != ExpressParserTokenTypes.TYPE_IDENT) continue;
            if (res == null) {
                res = new Vector<ExternalId>();
            }
            ExternalId ei = new ExternalId(id, type);
            res.add(ei);
        }
        return res;
    }

    public Vector getUsedExternals() {
        Vector<ExternalId> res = null;
        Enumeration<String> e = this.idtable.keys();
        while (e.hasMoreElements()) {
            String id = e.nextElement();
            ExpressParserTokenTypes type = this.idtable.get(id.toLowerCase());
            if (type != ExpressParserTokenTypes.ENTITY_IDENT && type != ExpressParserTokenTypes.TYPE_IDENT) continue;
            if (res == null) {
                res = new Vector<ExternalId>();
            }
            ExternalId ei = new ExternalId(id, type);
            res.add(ei);
        }
        return res;
    }

    public void addAllReferenceExternals(String schema) {
        if (this.allReferencedSchemas == null) {
            this.allReferencedSchemas = new Vector();
        }
        this.allReferencedSchemas.add(schema);
    }

    public void addAllUseExternals(String schema) {
        if (this.allUsedSchemas == null) {
            this.allUsedSchemas = new Vector();
        }
        this.allUsedSchemas.add(schema);
    }

    public void processExternals(Hashtable schemas) {
        Scope es = null;
        String rn = null;
        if (!this.extdone) {
            int j;
            int sz2;
            Vector eids;
            EnumerationType ext;
            EnumerationType et;
            Scope s;
            ExternalId ei;
            int i;
            int sz;
            if (this.externals != null) {
                sz = this.externals.size();
                for (i = 0; i < sz; ++i) {
                    ei = (ExternalId)this.externals.elementAt(i);
                    s = (Scope)schemas.get(ei.schema);
                    if (s == null) {
                        System.err.println("Warning: REFERENCED or USED schema \"" + ei.schema + "\" does not exist in the parsed file");
                        continue;
                    }
                    s.processExternals(schemas);
                    ExpressParserTokenTypes eid = s.searchId(ei.id);
                    if (eid == ExpressParserTokenTypes.IDENT) {
                        System.err.println("Warning: external id \"" + ei.id + "\" not found in schema \"" + ei.schema + "\"");
                        continue;
                    }
                    rn = ei.rename;
                    if (rn != null) {
                        this.idtable.put(rn.toLowerCase(), eid);
                    } else {
                        this.idtable.put(ei.id.toLowerCase(), eid);
                    }
                    if (eid == ExpressParserTokenTypes.ENTITY_IDENT) {
                        try {
                            es = (Scope)s.searchEntity(ei.id).clone();
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                        es.setParent(this);
                        this.entities.put(ei.id.toLowerCase(), es);
                        continue;
                    }
                    if (eid != ExpressParserTokenTypes.TYPE_IDENT || (et = s.searchEnumerationType(ei.id)) == null) continue;
                    if (rn != null) {
                        et.setTypeName(rn);
                    }
                    if (et.basedOnName != null) {
                        ext = s.searchEnumerationType(et.basedOnName);
                        if (ext != null) {
                            if (!ext.extensible) {
                                System.err.println("Warning: enumeration type \"" + et.typename + "\" based on non extensible enumeration \"" + et.basedOnName + "\"");
                            }
                            et.extendWith(ext);
                        } else {
                            System.err.println("Warning: extensible enumeration \"" + et.basedOnName + "\" not found");
                        }
                    }
                    this.addEnumerationType(et);
                }
            }
            if (this.allReferencedSchemas != null) {
                sz = this.allReferencedSchemas.size();
                for (i = 0; i < sz; ++i) {
                    s = (Scope)schemas.get(this.allReferencedSchemas.elementAt(i));
                    if (s == null) {
                        System.err.println("Warning: REFERENCED schema \"" + (String)this.allReferencedSchemas.elementAt(i) + "\" does not exist in the parsed file");
                        continue;
                    }
                    eids = s.getReferencedExternals();
                    if (eids == null) continue;
                    sz2 = eids.size();
                    for (j = 0; j < sz2; ++j) {
                        ei = (ExternalId)eids.elementAt(j);
                        this.idtable.put(ei.id.toLowerCase(), ei.type);
                        if (ei.type == ExpressParserTokenTypes.ENTITY_IDENT) {
                            try {
                                es = (Scope)s.searchEntity(ei.id).clone();
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                // empty catch block
                            }
                            es.setParent(this);
                            this.entities.put(ei.id.toLowerCase(), es);
                            continue;
                        }
                        if (ei.type != ExpressParserTokenTypes.TYPE_IDENT || (et = s.searchEnumerationType(ei.id)) == null) continue;
                        if (rn != null) {
                            et.setTypeName(rn);
                        }
                        if (et.basedOnName != null) {
                            ext = this.searchEnumerationType(et.basedOnName);
                            if (ext != null) {
                                if (!ext.extensible) {
                                    System.err.println("Warning: enumeration type \"" + et.typename + "\" based on non extensible enumeration \"" + et.basedOnName + "\"");
                                }
                                et.extendWith(ext);
                            } else {
                                System.err.println("Warning: extensible enumeration \"" + et.basedOnName + "\" not found");
                            }
                        }
                        this.addEnumerationType(et);
                    }
                }
            }
            if (this.allUsedSchemas != null) {
                sz = this.allUsedSchemas.size();
                for (i = 0; i < sz; ++i) {
                    s = (Scope)schemas.get(this.allUsedSchemas.elementAt(i));
                    if (s == null) {
                        System.err.println("Warning: USED schema \"" + (String)this.allUsedSchemas.elementAt(i) + "\" does not exist in the parsed file");
                        continue;
                    }
                    eids = s.getUsedExternals();
                    if (eids == null) continue;
                    sz2 = eids.size();
                    for (j = 0; j < sz2; ++j) {
                        ei = (ExternalId)eids.elementAt(j);
                        this.idtable.put(ei.id.toLowerCase(), ei.type);
                        if (ei.type == ExpressParserTokenTypes.ENTITY_IDENT) {
                            try {
                                es = (Scope)s.searchEntity(ei.id).clone();
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                // empty catch block
                            }
                            es.setParent(this);
                            this.entities.put(ei.id.toLowerCase(), es);
                            continue;
                        }
                        if (ei.type != ExpressParserTokenTypes.TYPE_IDENT || (et = s.searchEnumerationType(ei.id)) == null) continue;
                        if (rn != null) {
                            et.setTypeName(rn);
                        }
                        if (et.basedOnName != null) {
                            ext = this.searchEnumerationType(et.basedOnName);
                            if (ext != null) {
                                if (!ext.extensible) {
                                    System.err.println("Warning: enumeration type \"" + et.typename + "\" based on non extensible enumeration \"" + et.basedOnName + "\"");
                                }
                                et.extendWith(ext);
                            } else {
                                System.err.println("Warning: extensible enumeration \"" + et.basedOnName + "\" not found");
                            }
                        }
                        this.addEnumerationType(et);
                    }
                }
            }
        }
        this.extdone = true;
    }

    public void setParent(Scope p) {
        this.parent = p;
    }

    public void setNext(Scope next) {
        this.next = next;
    }

    public void setEntity() {
        this.entity = true;
        this.superentities = new Vector();
    }

    public Scope(Scope parent) {
        this.parent = parent;
        this.idtable = new Hashtable();
        this.entities = new Hashtable();
        this.entity = false;
    }
}

