/*
 * Decompiled with CFR 0.152.
 */
package nl.tue.buildingsmart.express.parser;

import antlr.CommonAST;
import antlr.collections.AST;
import com.google.common.base.Charsets;
import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import net.sourceforge.osexpress.parser.EasyParser;
import nl.tue.buildingsmart.express.parser.Express2DictWalker;
import nl.tue.buildingsmart.schema.AggregationType;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.BaseType;
import nl.tue.buildingsmart.schema.DefinedType;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.EnumerationType;
import nl.tue.buildingsmart.schema.ExplicitAttribute;
import nl.tue.buildingsmart.schema.InverseAttribute;
import nl.tue.buildingsmart.schema.NamedType;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import nl.tue.buildingsmart.schema.SelectType;
import nl.tue.buildingsmart.schema.UnderlyingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressSchemaParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressSchemaParser.class);
    EasyParser parser;
    Express2DictWalker walker;
    private InputStream inputStream;

    public ExpressSchemaParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ExpressSchemaParser(URL url) {
        try {
            this.inputStream = url.openConnection().getInputStream();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void parse() {
        ByteArrayOutputStream log = new ByteArrayOutputStream();
        try {
            PrintStream stdErrOld = System.err;
            PrintStream stdOutOld = System.out;
            PrintStream myErr = new PrintStream(log);
            System.setErr(myErr);
            System.setOut(myErr);
            this.parser = new EasyParser(new BufferedInputStream(this.inputStream));
            this.walker = new Express2DictWalker();
            CommonAST t = this.parser.parse();
            this.walker.setPass(1);
            this.walker.syntax((AST)t);
            this.walker.setPass(2);
            this.walker.syntax_pass2((AST)t);
            this.walker.setPass(3);
            this.walker.syntax_pass2((AST)t);
            this.walker.setPass(4);
            this.walker.syntax_pass2((AST)t);
            System.setErr(stdErrOld);
            System.setOut(stdOutOld);
            this.walker.getSchema().constructHirarchyMap();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            LOGGER.error(new String(log.toByteArray(), Charsets.UTF_8));
        }
    }

    public SchemaDefinition getSchema() {
        if (this.walker != null) {
            return this.walker.getSchema();
        }
        return null;
    }

    public static void main(String[] argv) {
        int currentCommandLineOption;
        String commonSchemaFile = null;
        String fileIn = null;
        String fileOut = null;
        long startTime = System.currentTimeMillis();
        Getopt g = new Getopt("Express2Dict", argv, "o:s:");
        block7: while ((currentCommandLineOption = g.getopt()) != -1) {
            switch (currentCommandLineOption) {
                case 111: {
                    fileOut = g.getOptarg();
                    continue block7;
                }
                case 115: {
                    commonSchemaFile = g.getOptarg();
                    continue block7;
                }
                case 63: {
                    System.err.println("exiting");
                    System.exit(1);
                    continue block7;
                }
            }
        }
        fileIn = ExpressSchemaParser.getFileIn(argv, g);
        ExpressSchemaParser.checkInputFile(fileIn);
        try {
            EasyParser parser = new EasyParser(fileIn);
            Express2DictWalker walker = new Express2DictWalker();
            CommonAST parsedTree = parser.parse();
            walker.setPass(1);
            walker.syntax((AST)parsedTree);
            walker.setPass(2);
            walker.syntax_pass2((AST)parsedTree);
            walker.setPass(3);
            walker.syntax_pass2((AST)parsedTree);
            SchemaDefinition schema = walker.getSchema();
            ExpressSchemaParser.printSchemaToConsole(schema);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        LOGGER.info("execution time: " + ExpressSchemaParser.getStringTime(System.currentTimeMillis() - startTime));
    }

    private static String getFileIn(String[] argv, Getopt g) {
        try {
            return argv[g.getOptind()];
        }
        catch (Exception e) {
            System.err.println("E2OWL: Input file not specified");
            System.exit(1);
            System.err.println("E2OWL: Error in parsing input file");
            System.exit(1);
            return null;
        }
    }

    private static void checkInputFile(String fileIn) {
        File file = new File(fileIn);
        if (!file.canRead()) {
            System.err.println("E2OWL: Unable to read file " + fileIn);
            System.exit(1);
        }
    }

    private static void printSchemaToConsole(SchemaDefinition schema) {
        ExpressSchemaParser.printEntities(schema);
        ExpressSchemaParser.printTypes(schema);
    }

    private static void printEntities(SchemaDefinition schema) {
        for (EntityDefinition ent : schema.getEntities()) {
            LOGGER.info(ent.getName());
            for (Attribute attr : ent.getAttributes()) {
                System.out.print(ent.getName() + ":" + attr.getName());
                if (attr instanceof ExplicitAttribute) {
                    BaseType bt = ((ExplicitAttribute)attr).getDomain();
                    if (bt instanceof NamedType) {
                        if (bt != null) {
                            System.out.print(" is-a " + ((NamedType)bt).getName());
                        }
                    } else if (bt instanceof AggregationType && bt != null && ((AggregationType)bt).getElement_type() != null) {
                        System.out.print(" is-a " + ((AggregationType)bt).getElement_type().getClass());
                    }
                }
                if (attr instanceof InverseAttribute) {
                    InverseAttribute inv = (InverseAttribute)attr;
                    EntityDefinition forEnt = inv.getDomain();
                    ExplicitAttribute invertedAttr = inv.getInverted_attr();
                    System.out.print(inv.getName() + " inverse of ");
                    System.out.print(invertedAttr.getName() + " for " + forEnt.getName());
                }
                LOGGER.info("");
            }
        }
    }

    private static void printTypes(SchemaDefinition schema) {
        for (DefinedType type : schema.getTypes()) {
            UnderlyingType ut = type.getDomain();
            if (ut != null) {
                LOGGER.info(type.getName() + ":" + ut.getClass());
                continue;
            }
            if (type instanceof SelectType) {
                LOGGER.info(type.getName() + ((SelectType)type).getSelections().toString());
                continue;
            }
            if (type instanceof EnumerationType) {
                LOGGER.info(type.getName() + ((EnumerationType)type).getElements().toString());
                continue;
            }
            if (ut != null || type instanceof SelectType) continue;
            LOGGER.error(type.getName() + " has no underlying_type");
        }
    }

    private static final String getStringTime(long millis) {
        int seconds = (int)(millis / 1000L);
        int minutes = seconds / 60;
        int hours = minutes / 60;
        return (hours < 10 ? "0" + hours : "" + hours) + ":" + (minutes < 10 ? "0" + minutes : "" + minutes) + ":" + (seconds < 10 ? "0" + seconds : "" + (seconds -= hours * 3600 + (minutes -= hours * 60) * 60));
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

