/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.ModelMetaData;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.ifc2x3tc1.IfcAnnotation;
import org.bimserver.models.ifc2x3tc1.IfcAnnotationCurveOccurrence;
import org.bimserver.models.ifc2x3tc1.IfcDimensionCurve;
import org.bimserver.models.ifc2x3tc1.IfcElement;
import org.bimserver.models.ifc2x3tc1.IfcGrid;
import org.bimserver.models.ifc2x3tc1.IfcLayeredItem;
import org.bimserver.models.ifc2x3tc1.IfcObjectDefinition;
import org.bimserver.models.ifc2x3tc1.IfcPresentationLayerAssignment;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcProductDefinitionShape;
import org.bimserver.models.ifc2x3tc1.IfcProductRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcPropertyDefinition;
import org.bimserver.models.ifc2x3tc1.IfcRelAssociates;
import org.bimserver.models.ifc2x3tc1.IfcRelConnectsStructuralActivity;
import org.bimserver.models.ifc2x3tc1.IfcRelContainedInSpatialStructure;
import org.bimserver.models.ifc2x3tc1.IfcRelReferencedInSpatialStructure;
import org.bimserver.models.ifc2x3tc1.IfcRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentationItem;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.ifc2x3tc1.IfcStructuralActivityAssignmentSelect;
import org.bimserver.models.ifc2x3tc1.IfcStructuralItem;
import org.bimserver.models.ifc2x3tc1.IfcTerminatorSymbol;
import org.bimserver.plugins.ObjectAlreadyExistsException;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IfcModel
implements IfcModelInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcModel.class);
    private final ModelMetaData modelMetaData = new ModelMetaData();
    private final Set<IfcModelChangeListener> changeListeners = new LinkedHashSet<IfcModelChangeListener>();
    private BiMap<Long, IdEObject> objects;
    private final Set<IdEObject> unidentifiedObjects = new HashSet<IdEObject>();
    private Map<String, IfcRoot> guidIndexed;
    private Map<EClass, List<? extends IdEObject>> indexPerClass;
    private Map<EClass, List<? extends IdEObject>> indexPerClassWithSubTypes;
    private Map<EClass, Map<String, IdEObject>> guidIndex;
    private Map<EClass, Map<String, IdEObject>> nameIndex;
    private long oidCounter = 1L;
    private boolean useDoubleStrings = true;
    private PackageMetaData packageMetaData;
    private Map<Integer, Long> pidRoidMap;

    public IfcModel(PackageMetaData packageMetaData, Map<Integer, Long> pidRoidMap, int size) {
        this.pidRoidMap = pidRoidMap;
        if (packageMetaData == null) {
            throw new IllegalArgumentException("PackageMetaData is required");
        }
        this.packageMetaData = packageMetaData;
        this.objects = HashBiMap.create((int)size);
    }

    public IfcModel(PackageMetaData packageMetaData, Map<Integer, Long> pidRoidMap) {
        this(packageMetaData, pidRoidMap, 16);
    }

    private void buildIndex() {
        this.indexPerClass = new HashMap<EClass, List<? extends IdEObject>>();
        for (Long key : this.objects.keySet()) {
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (value == null) continue;
            List<? extends IdEObject> list = this.indexPerClass.get(value.eClass());
            if (list == null) {
                list = new ArrayList<IdEObject>();
                this.indexPerClass.put(value.eClass(), list);
            }
            list.add((IdEObject)value);
        }
    }

    public void rebuildIndexPerClass(EClass eClass) {
        if (this.indexPerClass == null) {
            this.indexPerClass = new HashMap<EClass, List<? extends IdEObject>>();
        }
        ArrayList<IdEObject> list = new ArrayList<IdEObject>();
        this.indexPerClass.put(eClass, list);
        for (Long key : this.objects.keySet()) {
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (!eClass.isInstance((Object)value)) continue;
            list.add(value);
        }
    }

    private void buildIndexWithSubTypes() {
        this.indexPerClassWithSubTypes = new HashMap<EClass, List<? extends IdEObject>>();
        for (Long key : this.objects.keySet()) {
            IdEObject idEObject = (IdEObject)this.objects.get((Object)key);
            if (idEObject == null) continue;
            this.buildIndexWithSuperTypes(idEObject, idEObject.eClass());
        }
    }

    private void buildIndexWithSuperTypes(IdEObject eObject, EClass eClass) {
        if (!this.indexPerClassWithSubTypes.containsKey(eClass)) {
            this.indexPerClassWithSubTypes.put(eClass, new ArrayList());
        }
        this.indexPerClassWithSubTypes.get(eClass).add((IdEObject)eObject);
        for (EClass superClass : eClass.getESuperTypes()) {
            this.buildIndexWithSuperTypes(eObject, superClass);
        }
    }

    public void buildGuidIndex() {
        this.guidIndex = new HashMap<EClass, Map<String, IdEObject>>();
        if (this.objects.isEmpty()) {
            return;
        }
        for (EClassifier classifier : ((IdEObject)this.objects.values().iterator().next()).eClass().getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            TreeMap map = new TreeMap();
            this.guidIndex.put((EClass)classifier, map);
        }
        for (Long key : this.objects.keySet()) {
            IfcRoot ifcRoot;
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (!(value instanceof IfcRoot) || (ifcRoot = (IfcRoot)value).getGlobalId() == null) continue;
            this.guidIndex.get(value.eClass()).put(ifcRoot.getGlobalId(), value);
        }
    }

    public void buildNameIndex() {
        this.nameIndex = new HashMap<EClass, Map<String, IdEObject>>();
        for (EClassifier classifier : ((IdEObject)this.objects.values().iterator().next()).eClass().getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            TreeMap map = new TreeMap();
            this.nameIndex.put((EClass)classifier, map);
        }
        for (Long key : this.objects.keySet()) {
            IfcRoot ifcRoot;
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (!(value instanceof IfcRoot) || (ifcRoot = (IfcRoot)value).getName() == null) continue;
            this.nameIndex.get(value.eClass()).put(ifcRoot.getName(), value);
        }
    }

    public void sortAllAggregates(ObjectIDM objectIDM, IfcRoot ifcRoot) {
        for (EStructuralFeature eStructuralFeature : ifcRoot.eClass().getEAllStructuralFeatures()) {
            EList list;
            if (!objectIDM.shouldFollowReference(ifcRoot.eClass(), ifcRoot.eClass(), eStructuralFeature) || eStructuralFeature.getUpperBound() != -1 && eStructuralFeature.getUpperBound() <= 1 || !(eStructuralFeature.getEType() instanceof EClass)) continue;
            if (eStructuralFeature.getEType().getEAnnotation("wrapped") != null) {
                list = (EList)ifcRoot.eGet(eStructuralFeature);
                this.sortPrimitiveList((EList<IdEObject>)list);
                continue;
            }
            list = (EList)ifcRoot.eGet(eStructuralFeature);
            this.sortComplexList(objectIDM, ifcRoot.eClass(), (EList<IdEObject>)list, eStructuralFeature);
        }
    }

    private void sortPrimitiveList(EList<IdEObject> list) {
        ECollections.sort(list, (Comparator)new Comparator<IdEObject>(){

            @Override
            public int compare(IdEObject o1, IdEObject o2) {
                return IfcModel.this.comparePrimitives(o1, o2);
            }
        });
    }

    private void sortComplexList(final ObjectIDM objectIDM, final EClass originalQueryClass, EList<IdEObject> list, EStructuralFeature eStructuralFeature) {
        final EClass type = (EClass)eStructuralFeature.getEType();
        ECollections.sort(list, (Comparator)new Comparator<IdEObject>(){

            @Override
            public int compare(IdEObject o1, IdEObject o2) {
                int i = 1;
                for (EStructuralFeature eStructuralFeature : type.getEAllStructuralFeatures()) {
                    int compare;
                    if (!objectIDM.shouldFollowReference(originalQueryClass, type, eStructuralFeature)) continue;
                    Object val1 = o1.eGet(eStructuralFeature);
                    Object val2 = o2.eGet(eStructuralFeature);
                    if (val1 != null && val2 != null && eStructuralFeature.getEType() instanceof EClass && eStructuralFeature.getEType().getEAnnotation("wrapped") != null && (compare = IfcModel.this.comparePrimitives((IdEObject)val1, (IdEObject)val2)) != 0) {
                        return compare * i;
                    }
                    ++i;
                }
                return 0;
            }
        });
    }

    private int comparePrimitives(IdEObject o1, IdEObject o2) {
        EClass eClass = o1.eClass();
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("wrappedValue");
        Object val1 = o1.eGet(eStructuralFeature);
        Object val2 = o2.eGet(eStructuralFeature);
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
            return ((String)val1).compareTo((String)val2);
        }
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEInt()) {
            return ((Integer)val1).compareTo((Integer)val2);
        }
        throw new RuntimeException("ni");
    }

    public <T extends IdEObject> List<T> getAll(EClass eClass) {
        List<? extends IdEObject> list;
        if (this.indexPerClass == null) {
            this.buildIndex();
        }
        if ((list = this.indexPerClass.get(eClass)) == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public <T extends IdEObject> List<T> getAll(Class<T> interfaceClass) {
        return this.getAll(this.packageMetaData.getEClassIncludingDependencies(interfaceClass));
    }

    public <T extends IdEObject> List<T> getAllWithSubTypes(EClass eClass) {
        List<? extends IdEObject> list;
        if (this.indexPerClassWithSubTypes == null) {
            this.buildIndexWithSubTypes();
        }
        if ((list = this.indexPerClassWithSubTypes.get(eClass)) == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public <T extends IdEObject> List<T> getAllWithSubTypes(Class<T> interfaceClass) {
        return this.getAllWithSubTypes(this.packageMetaData.getEClass(interfaceClass));
    }

    public Set<String> getGuids(EClass eClass) {
        Map<String, IdEObject> map;
        if (this.guidIndex == null) {
            this.buildGuidIndex();
        }
        if ((map = this.guidIndex.get(eClass)) == null) {
            return new HashSet<String>();
        }
        return map.keySet();
    }

    public Set<String> getNames(EClass eClass) {
        if (this.nameIndex == null) {
            this.buildNameIndex();
        }
        return this.nameIndex.get(eClass).keySet();
    }

    public IdEObject getByName(EClass eClass, String name) {
        if (this.nameIndex == null) {
            this.buildNameIndex();
        }
        return this.nameIndex.get(eClass).get(name);
    }

    public long size() {
        return this.objects.size() + this.unidentifiedObjects.size();
    }

    public Set<Long> keySet() {
        return this.objects.keySet();
    }

    public IdEObject get(long oid) {
        return (IdEObject)this.objects.get((Object)oid);
    }

    public Collection<IdEObject> getValues() {
        return this.objects.values();
    }

    public Collection<IdEObject> getUnidentifiedValues() {
        return this.unidentifiedObjects;
    }

    public void add(long oid, IdEObject eObject) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        this.add(oid, eObject, false, false);
    }

    public void addAllowMultiModel(long oid, IdEObject eObject) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        this.add(oid, eObject, false, true);
    }

    private void add(long oid, IdEObject eObject, boolean ignoreDuplicateOids, boolean allowMultiModel) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        if (((IdEObjectImpl)eObject).hasModel() && !allowMultiModel && ((IdEObjectImpl)eObject).getModel() != this) {
            throw new IfcModelInterfaceException("This object (" + eObject + ") already belongs to a Model: " + ((IdEObjectImpl)eObject).getModel() + ", not this " + this);
        }
        if (oid == -1L || eObject.eClass().getEAnnotation("wrapped") != null) {
            this.unidentifiedObjects.add(eObject);
        } else {
            if (this.objects.containsKey((Object)oid)) {
                if (!ignoreDuplicateOids && this.objects.get((Object)oid) != eObject) {
                    // empty if block
                }
            } else {
                this.objects.put((Object)oid, (Object)eObject);
                if (!((IdEObjectImpl)eObject).hasModel() || !allowMultiModel) {
                    ((IdEObjectImpl)eObject).setModel((IfcModelInterface)this);
                }
                if (this.guidIndexed != null) {
                    this.indexGuid(eObject);
                }
                if (this.indexPerClassWithSubTypes != null) {
                    this.buildIndexWithSuperTypes(eObject, eObject.eClass());
                }
                if (this.indexPerClass != null) {
                    List<? extends IdEObject> list = this.indexPerClass.get(eObject.eClass());
                    if (list == null) {
                        list = new ArrayList<IdEObject>();
                        this.indexPerClass.put(eObject.eClass(), list);
                    }
                    list.add((IdEObject)eObject);
                }
            }
            for (IfcModelChangeListener ifcModelChangeListener : this.changeListeners) {
                ifcModelChangeListener.objectAdded(eObject);
            }
        }
    }

    public BiMap<Long, IdEObject> getObjects() {
        return this.objects;
    }

    public boolean contains(long oid) {
        return this.objects.containsKey((Object)oid);
    }

    public boolean contains(IdEObject eObject) {
        return this.objects.containsValue((Object)eObject);
    }

    public void indexGuids() {
        this.guidIndexed = new HashMap<String, IfcRoot>();
        for (IdEObject idEObject : this.objects.values()) {
            this.indexGuid(idEObject);
        }
    }

    private void indexGuid(IdEObject idEObject) {
        IfcRoot ifcRoot;
        if (idEObject instanceof IfcRoot && (ifcRoot = (IfcRoot)idEObject).getGlobalId() != null) {
            this.guidIndexed.put(ifcRoot.getGlobalId(), ifcRoot);
        }
    }

    public boolean isValid() {
        return true;
    }

    public void dumpObject(IdEObject idEObject) {
        this.dumpObject(idEObject, 0, new HashSet<IdEObject>());
    }

    private void dumpObject(IdEObject idEObject, int indention, Set<IdEObject> printed) {
        if (printed.contains(idEObject)) {
            this.printIndention(indention);
            System.out.println("[REFERENCE: " + idEObject.getOid() + "]");
            return;
        }
        printed.add(idEObject);
        this.printIndention(indention);
        System.out.println(idEObject.eClass().getName() + " (" + idEObject.getOid() + ")");
        for (EAttribute eAttribute : idEObject.eClass().getEAllAttributes()) {
            Object val = idEObject.eGet((EStructuralFeature)eAttribute);
            if (val == null) continue;
            this.printIndention(indention + 1);
            System.out.println(eAttribute.getName() + ": " + val);
        }
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object referencedObject = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)referencedObject;
                if (list.size() <= 0) continue;
                this.printIndention(indention + 1);
                System.out.println(eReference.getName() + ": ");
                for (Object o : list) {
                    this.dumpObject((IdEObject)o, indention + 2, printed);
                }
                continue;
            }
            if (referencedObject == null) continue;
            this.printIndention(indention + 1);
            System.out.println(eReference.getName() + ": ");
            this.dumpObject((IdEObject)referencedObject, indention + 2, printed);
        }
    }

    private void printIndention(int indention) {
        for (int i = 0; i < indention; ++i) {
            System.out.print("  ");
        }
    }

    public void dumpSummary() {
        TreeMap<EClass, Integer> counts = new TreeMap<EClass, Integer>(new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (IdEObject idEObject : this.objects.values()) {
            if (!counts.containsKey(idEObject.eClass())) {
                counts.put(idEObject.eClass(), 1);
                continue;
            }
            counts.put(idEObject.eClass(), (Integer)counts.get(idEObject.eClass()) + 1);
        }
        for (EClass eClass : counts.keySet()) {
            System.out.println(eClass.getName() + ": " + counts.get(eClass));
        }
    }

    public void dump() {
        System.out.println("Dumping IFC Model");
        for (Long key : this.objects.keySet()) {
            System.out.println(key + ": " + ((IdEObject)this.objects.get((Object)key)).eClass().getName());
        }
    }

    public void dumpPlusReferences() {
        System.out.println("Dumping IFC Model + References");
        HashSet<IdEObject> done = new HashSet<IdEObject>();
        for (Long key : this.objects.keySet()) {
            this.dumpPlusReferences(done, (IdEObject)this.objects.get((Object)key));
        }
    }

    private void dumpPlusReferences(Set<IdEObject> done, IdEObject idEObject) {
        if (idEObject == null) {
            return;
        }
        if (done.contains(idEObject)) {
            return;
        }
        done.add(idEObject);
        System.out.println(idEObject.getOid() + ": " + idEObject.eClass().getName());
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.dumpPlusReferences(done, (IdEObject)o);
                }
                continue;
            }
            this.dumpPlusReferences(done, (IdEObject)val);
        }
    }

    public void remove(IdEObject idEObject) {
        this.unidentifiedObjects.remove(idEObject);
        this.objects.inverse().remove((Object)idEObject);
        if (this.indexPerClass != null) {
            this.indexPerClass.get(idEObject.eClass()).remove(idEObject);
        }
        if (this.indexPerClassWithSubTypes != null) {
            this.indexPerClassWithSubTypes.get(idEObject.eClass()).remove(idEObject);
        }
    }

    public void setOid(IdEObject object, Long oid) {
        this.objects.forcePut((Object)oid, (Object)object);
    }

    public void fixOids(OidProvider oidProvider) {
        HashBiMap temp = HashBiMap.create();
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            this.fixOids((IdEObject)this.objects.get((Object)oid), oidProvider, (BiMap<Long, IdEObject>)temp);
        }
        this.objects = temp;
    }

    public void fixOidsFlat(OidProvider oidProvider) {
        HashBiMap temp = HashBiMap.create();
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            this.fixOidsFlat((IdEObject)this.objects.get((Object)oid), oidProvider, (BiMap<Long, IdEObject>)temp);
        }
        this.objects = temp;
    }

    public void fixOids() {
        HashBiMap temp = HashBiMap.create();
        for (IdEObject object : this.objects.values()) {
            temp.put((Object)object.getOid(), (Object)object);
        }
        this.objects = temp;
    }

    private void fixOids(IdEObject idEObject, OidProvider oidProvider, BiMap<Long, IdEObject> temp) {
        if (idEObject == null) {
            return;
        }
        if (temp.containsValue((Object)idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(oidProvider.newOid(idEObject.eClass()));
        if (this.objects.containsValue((Object)idEObject)) {
            temp.put((Object)idEObject.getOid(), (Object)idEObject);
        }
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.fixOids((IdEObject)o, oidProvider, temp);
                }
                continue;
            }
            this.fixOids((IdEObject)val, oidProvider, temp);
        }
    }

    private void fixOidsFlat(IdEObject idEObject, OidProvider oidProvider, BiMap<Long, IdEObject> temp) {
        if (idEObject == null) {
            return;
        }
        if (temp.containsValue((Object)idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(oidProvider.newOid(idEObject.eClass()));
        if (this.objects.containsValue((Object)idEObject)) {
            temp.put((Object)idEObject.getOid(), (Object)idEObject);
        }
    }

    public void setObjectOids() {
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            ((IdEObjectImpl)this.objects.get((Object)oid)).setOid(oid);
        }
    }

    public long getHighestOid() {
        long max = 0L;
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            if (oid <= max) continue;
            max = oid;
        }
        return max;
    }

    public void changeOid(IdEObject object) {
        this.objects.inverse().remove((Object)object);
        this.objects.put((Object)object.getOid(), (Object)object);
    }

    public IfcRoot getByGuid(String guid) {
        if (this.guidIndexed == null) {
            this.indexGuids();
        }
        return this.guidIndexed.get(guid);
    }

    public boolean containsGuid(String guid) {
        if (this.guidIndexed == null) {
            this.indexGuids();
        }
        return this.guidIndexed.containsKey(guid);
    }

    public void checkDoubleOids() {
        HashSet<Long> oids = new HashSet<Long>();
        for (IdEObject idEObject : this.objects.values()) {
            if (oids.contains(idEObject.getOid())) {
                throw new RuntimeException("Double oid: " + idEObject.getOid());
            }
            oids.add(idEObject.getOid());
        }
    }

    public void fixOidCounter() {
        this.oidCounter = this.getHighestOid() + 1L;
    }

    private void checkDoubleOidsPlusReferences(BiMap<IdEObject, Long> done, IdEObject idEObject) {
        if (idEObject == null) {
            return;
        }
        if (idEObject.eClass().getEAnnotation("wrapped") != null) {
            return;
        }
        if (done.containsKey((Object)idEObject)) {
            return;
        }
        if (done.containsValue((Object)idEObject.getOid())) {
            this.showBackReferences(idEObject);
            IdEObject existing = (IdEObject)done.inverse().get((Object)idEObject.getOid());
            this.showBackReferences(existing);
            throw new RuntimeException("Double oid: " + idEObject.getOid() + " " + idEObject + ", " + existing);
        }
        done.put((Object)idEObject, (Object)idEObject.getOid());
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                for (Object o : list) {
                    this.checkDoubleOidsPlusReferences(done, (IdEObject)o);
                }
                continue;
            }
            this.checkDoubleOidsPlusReferences(done, (IdEObject)idEObject.eGet((EStructuralFeature)eReference));
        }
    }

    public void showBackReferences(IdEObject idEObject) {
        System.out.println("Showing back references to: " + idEObject);
        for (IdEObject object : this.getValues()) {
            for (EReference eReference : object.eClass().getEAllReferences()) {
                if (eReference.isMany()) {
                    List list = (List)object.eGet((EStructuralFeature)eReference);
                    for (Object o : list) {
                        if (o != idEObject) continue;
                        System.out.println(object.eClass().getName() + "." + eReference.getName() + " " + object);
                    }
                    continue;
                }
                Object o = object.eGet((EStructuralFeature)eReference);
                if (o != idEObject) continue;
                System.out.println(object.eClass().getName() + "." + eReference.getName() + " " + object);
            }
        }
    }

    public void checkDoubleOidsPlusReferences() {
        HashBiMap done = HashBiMap.create();
        for (IdEObject idEObject : this.objects.values()) {
            this.checkDoubleOidsPlusReferences((BiMap<IdEObject, Long>)done, idEObject);
        }
    }

    public void resetOidsFlat() {
        for (IdEObject idEObject : this.objects.values()) {
            ((IdEObjectImpl)idEObject).setOid(-1L);
        }
    }

    public void resetOids() {
        HashSet<IdEObject> done = new HashSet<IdEObject>();
        for (IdEObject idEObject : this.objects.values()) {
            this.resetOids(idEObject, done);
        }
    }

    public void resetOids(IdEObject idEObject, Set<IdEObject> done) {
        if (idEObject == null) {
            return;
        }
        if (done.contains(idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(-1L);
        done.add(idEObject);
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.resetOids((IdEObject)o, done);
                }
                continue;
            }
            this.resetOids((IdEObject)val, done);
        }
    }

    public void addChangeListener(IfcModelChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(IfcModelChangeListener ifcModelChangeListener) {
        this.changeListeners.remove(ifcModelChangeListener);
    }

    public void setUseDoubleStrings(boolean useDoubleStrings) {
        this.useDoubleStrings = useDoubleStrings;
    }

    public boolean isUseDoubleStrings() {
        return this.useDoubleStrings;
    }

    public Iterator<IdEObject> iterator() {
        return this.objects.values().iterator();
    }

    public int countWithSubtypes(EClass eClass) {
        List list = this.getAllWithSubTypes(eClass);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public int count(EClass eClass) {
        List list = this.getAll(eClass);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Iterator<IdEObject> iterateAllObjects() {
        return new Iterator<IdEObject>(){
            private final Queue<IdEObject> todo;
            private final Set<IdEObject> done;
            {
                this.todo = new LinkedBlockingQueue<IdEObject>(IfcModel.this.getValues());
                this.done = new HashSet<IdEObject>();
            }

            @Override
            public boolean hasNext() {
                return !this.todo.isEmpty();
            }

            @Override
            public IdEObject next() {
                IdEObject idEObject = this.todo.poll();
                this.done.add(idEObject);
                for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                    Object val = idEObject.eGet((EStructuralFeature)eReference);
                    if (eReference.isMany()) {
                        List list = (List)val;
                        for (Object o : list) {
                            if (this.done.contains(o)) continue;
                            this.todo.add((IdEObject)o);
                        }
                        continue;
                    }
                    if (val == null || this.done.contains(val)) continue;
                    this.todo.add((IdEObject)val);
                }
                return idEObject;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void generateMinimalExpressIds() {
        int expressId = 1;
        Iterator<IdEObject> iterateAllObjects = this.iterateAllObjects();
        while (iterateAllObjects.hasNext()) {
            IdEObject idEObject = iterateAllObjects.next();
            ((IdEObjectImpl)idEObject).setExpressId(expressId++);
        }
    }

    public ModelMetaData getModelMetaData() {
        return this.modelMetaData;
    }

    public <T extends IdEObject> T create(EClass eClass) throws IfcModelInterfaceException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        long oid = this.oidCounter++;
        object.setOid(oid);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(Class<T> clazz) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        EClass eClass = this.packageMetaData.getEClass(clazz);
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        long oid = this.oidCounter++;
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(EClass eClass) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        long oid = this.oidCounter++;
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T create(EClass eClass, long oid) throws IfcModelInterfaceException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setModel((IfcModelInterface)this);
        object.setOid(oid);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(EClass eClass, long oid) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setModel((IfcModelInterface)this);
        object.setOid(oid);
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T create(EClass eClass, OidProvider oidProvider) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        long oid = oidProvider.newOid(eClass);
        object.setOid(oid);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        this.add(oid, (IdEObject)object, false, false);
        return (T)object;
    }

    public <T extends IdEObject> T create(Class<T> clazz) throws IfcModelInterfaceException {
        return this.create(this.packageMetaData.getEClassIncludingDependencies(clazz));
    }

    public <T extends IdEObject> T create(Class<T> clazz, OidProvider oidProvider) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        return this.create(this.packageMetaData.getEClass(clazz), oidProvider);
    }

    public void clear() {
        if (this.guidIndex != null) {
            this.guidIndex.clear();
        }
        if (this.guidIndexed != null) {
            this.guidIndexed.clear();
        }
        if (this.indexPerClass != null) {
            this.indexPerClass.clear();
        }
        if (this.nameIndex != null) {
            this.nameIndex.clear();
        }
        if (this.indexPerClassWithSubTypes != null) {
            this.indexPerClassWithSubTypes.clear();
        }
        if (this.objects != null) {
            this.objects.clear();
        }
    }

    public void resetExpressIds() {
        for (IdEObject idEObject : this.objects.values()) {
            ((IdEObjectImpl)idEObject).setExpressId(-1);
        }
    }

    public IfcModelInterface branch(long poid, boolean recordChanges) {
        throw new UnsupportedOperationException();
    }

    public long commit(String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }

    public void fixInverseMismatches() {
        int nrFixes = 0;
        for (IfcRelContainedInSpatialStructure ifcRelContainedInSpatialStructure : new ArrayList<IfcRelContainedInSpatialStructure>(this.getAll(IfcRelContainedInSpatialStructure.class))) {
            for (IfcProduct ifcProduct : new ArrayList(ifcRelContainedInSpatialStructure.getRelatedElements())) {
                if (ifcProduct instanceof IfcElement) {
                    IfcElement ifcElement = (IfcElement)ifcProduct;
                    ifcElement.getContainedInStructure().add((Object)ifcRelContainedInSpatialStructure);
                    ++nrFixes;
                    continue;
                }
                if (ifcProduct instanceof IfcAnnotation) {
                    IfcAnnotation ifcAnnotation = (IfcAnnotation)ifcProduct;
                    ifcAnnotation.getContainedInStructure().add((Object)ifcRelContainedInSpatialStructure);
                    ++nrFixes;
                    continue;
                }
                if (!(ifcProduct instanceof IfcGrid)) continue;
                IfcGrid ifcGrid = (IfcGrid)ifcProduct;
                ifcGrid.getContainedInStructure().add((Object)ifcRelContainedInSpatialStructure);
                ++nrFixes;
            }
        }
        for (IfcPresentationLayerAssignment ifcPresentationLayerAssignment : new ArrayList<IfcPresentationLayerAssignment>(this.getAllWithSubTypes(IfcPresentationLayerAssignment.class))) {
            for (IfcLayeredItem ifcLayeredItem : new ArrayList(ifcPresentationLayerAssignment.getAssignedItems())) {
                if (ifcLayeredItem instanceof IfcRepresentation) {
                    IfcRepresentation ifcRepresentation = (IfcRepresentation)ifcLayeredItem;
                    ifcRepresentation.getLayerAssignments().add((Object)ifcPresentationLayerAssignment);
                    ++nrFixes;
                    continue;
                }
                if (!(ifcLayeredItem instanceof IfcRepresentationItem)) continue;
                IfcRepresentationItem ifcRepresentationItem = (IfcRepresentationItem)ifcLayeredItem;
                ifcRepresentationItem.getLayerAssignments().add((Object)ifcPresentationLayerAssignment);
                ++nrFixes;
            }
        }
        for (IfcRelAssociates ifcRelAssociates : new ArrayList<IfcRelAssociates>(this.getAllWithSubTypes(IfcRelAssociates.class))) {
            for (IfcRoot ifcRoot : new ArrayList(ifcRelAssociates.getRelatedObjects())) {
                if (ifcRoot instanceof IfcObjectDefinition) {
                    ((IfcObjectDefinition)ifcRoot).getHasAssociations().add((Object)ifcRelAssociates);
                    ++nrFixes;
                    continue;
                }
                if (!(ifcRoot instanceof IfcPropertyDefinition)) continue;
                ((IfcPropertyDefinition)ifcRoot).getHasAssociations().add((Object)ifcRelAssociates);
                ++nrFixes;
            }
        }
        for (IfcTerminatorSymbol ifcTerminatorSymbol : new ArrayList<IfcTerminatorSymbol>(this.getAllWithSubTypes(IfcTerminatorSymbol.class))) {
            IfcAnnotationCurveOccurrence ifcAnnotationCurveOccurrence = ifcTerminatorSymbol.getAnnotatedCurve();
            if (!(ifcAnnotationCurveOccurrence instanceof IfcDimensionCurve)) continue;
            ((IfcDimensionCurve)ifcAnnotationCurveOccurrence).getAnnotatedBySymbols().add((Object)ifcTerminatorSymbol);
            ++nrFixes;
        }
        for (IfcRelReferencedInSpatialStructure ifcRelReferencedInSpatialStructure : new ArrayList<IfcRelReferencedInSpatialStructure>(this.getAllWithSubTypes(IfcRelReferencedInSpatialStructure.class))) {
            for (IfcProduct ifcProduct : new ArrayList(ifcRelReferencedInSpatialStructure.getRelatedElements())) {
                if (!(ifcProduct instanceof IfcElement)) continue;
                ((IfcElement)ifcProduct).getReferencedInStructures().add((Object)ifcRelReferencedInSpatialStructure);
                ++nrFixes;
            }
        }
        for (IfcProduct ifcProduct : new ArrayList<IfcProduct>(this.getAllWithSubTypes(IfcProduct.class))) {
            IfcProductRepresentation ifcProductRepresentation = ifcProduct.getRepresentation();
            if (!(ifcProductRepresentation instanceof IfcProductDefinitionShape)) continue;
            ((IfcProductDefinitionShape)ifcProductRepresentation).getShapeOfProduct().add((Object)ifcProduct);
            ++nrFixes;
        }
        for (IfcRelConnectsStructuralActivity ifcRelConnectsStructuralActivity : new ArrayList<IfcRelConnectsStructuralActivity>(this.getAllWithSubTypes(IfcRelConnectsStructuralActivity.class))) {
            IfcStructuralActivityAssignmentSelect ifcStructuralActivityAssignmentSelect = ifcRelConnectsStructuralActivity.getRelatingElement();
            if (!(ifcStructuralActivityAssignmentSelect instanceof IfcStructuralItem)) continue;
            ((IfcStructuralItem)ifcStructuralActivityAssignmentSelect).getAssignedStructuralActivity().add((Object)ifcRelConnectsStructuralActivity);
            ++nrFixes;
        }
        LOGGER.info("Nr inverse fixes: " + nrFixes);
    }

    public Map<Integer, Long> getPidRoidMap() {
        return this.pidRoidMap;
    }

    public void set(IdEObject idEObject, EStructuralFeature eFeature, Object newValue) {
    }

    public void checkin(long poid, String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
    }

    public boolean containsNoFetch(long oid) {
        return this.contains(oid);
    }

    public IdEObject getNoFetch(long oid) {
        return this.get(oid);
    }

    public abstract void load(IdEObject var1);

    public Set<EClass> getUsedClasses() {
        if (this.indexPerClass == null) {
            this.buildIndex();
        }
        return this.indexPerClass.keySet();
    }

    public void query(ObjectNode query) {
    }

    public <T extends IdEObject> T getFirst(Class<T> class1) {
        return (T)((IdEObject)this.getAll(class1).iterator().next());
    }
}

