/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.eclipse.emf.common.util.AbstractEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ReferenceCounter {
    private final Map<IdEObject, Set<Reference>> references = new HashMap<IdEObject, Set<Reference>>();
    private final IfcModelInterface ifcModel;

    public ReferenceCounter(IfcModelInterface ifcModel) {
        this.ifcModel = ifcModel;
    }

    public void updateReferences() {
        this.references.clear();
        for (IdEObject idEObject : this.ifcModel.getValues()) {
            for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                if (eReference.isMany()) {
                    List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                    for (Object o : list) {
                        if (!this.references.containsKey(o)) {
                            this.references.put((IdEObject)o, new HashSet());
                        }
                        this.references.get(o).add(new MultiReference(idEObject, (IdEObject)o, eReference));
                    }
                    continue;
                }
                Object o = idEObject.eGet((EStructuralFeature)eReference);
                if (!this.references.containsKey(o)) {
                    this.references.put((IdEObject)o, new HashSet());
                }
                this.references.get(o).add(new SingleReference(idEObject, (IdEObject)o, eReference));
            }
        }
    }

    public void remove(IdEObject idEObject) {
        this.removeInternal(idEObject);
    }

    public int removeInternal(IdEObject idEObject) {
        int totalRemoved = 1;
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                for (Object o : list) {
                    IdEObject refObject = (IdEObject)o;
                    this.references.get(refObject).remove(idEObject);
                    if (this.references.get(refObject).size() != 0) continue;
                    totalRemoved += this.removeInternal(refObject);
                }
                continue;
            }
            IdEObject refObject = (IdEObject)idEObject.eGet((EStructuralFeature)eReference);
            if (!this.references.containsKey(refObject)) continue;
            this.references.get(refObject).remove(idEObject);
            if (this.references.get(refObject).size() != 0) continue;
            totalRemoved += this.removeInternal(refObject);
        }
        return totalRemoved;
    }

    public Set<Reference> getReferencesTo(IdEObject objectToRemove) {
        return this.references.get(objectToRemove);
    }

    public void addReference(Reference reference) {
        if (this.references.containsKey(reference.getReferredObject())) {
            this.references.get(reference.getReferredObject()).add(reference);
        } else {
            HashSet<Reference> rSet = new HashSet<Reference>();
            rSet.add(reference);
            this.references.put(reference.getReferredObject(), rSet);
        }
        if (reference.geteReference().getEOpposite() != null) {
            Reference backReference;
            if (reference.geteReference().getEOpposite().isMany()) {
                backReference = new MultiReference(reference.getReferredObject(), reference.getIdEObject(), reference.geteReference().getEOpposite());
                if (this.references.containsKey(reference.getIdEObject())) {
                    this.references.get(reference.getIdEObject()).add(backReference);
                } else {
                    HashSet<MultiReference> rSet = new HashSet<MultiReference>();
                    rSet.add((MultiReference)backReference);
                    this.references.put(reference.getIdEObject(), rSet);
                }
            } else {
                backReference = new SingleReference(reference.getReferredObject(), reference.getIdEObject(), reference.geteReference().getEOpposite());
                if (this.references.containsKey(reference.getIdEObject())) {
                    this.references.get(reference.getIdEObject()).add(backReference);
                } else {
                    HashSet<MultiReference> rSet = new HashSet<MultiReference>();
                    rSet.add((MultiReference)backReference);
                    this.references.put(reference.getIdEObject(), rSet);
                }
            }
        }
    }

    public static class MultiReference
    extends Reference {
        public MultiReference(IdEObject idEObject, IdEObject referredObject, EReference eReference) {
            super(idEObject, referredObject, eReference);
        }

        @Override
        public Reference reAttach(IdEObject mainObject) {
            AbstractEList list = (AbstractEList)this.getIdEObject().eGet((EStructuralFeature)this.geteReference());
            int index = list.indexOf((Object)this.getReferredObject());
            if (index != -1) {
                try {
                    list.set(index, (Object)mainObject);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            while (list.contains((Object)this.getReferredObject())) {
                list.remove((Object)this.getReferredObject());
            }
            return new MultiReference(this.getIdEObject(), mainObject, this.geteReference());
        }
    }

    public static class SingleReference
    extends Reference {
        public SingleReference(IdEObject idEObject, IdEObject referredObject, EReference eReference) {
            super(idEObject, referredObject, eReference);
        }

        @Override
        public Reference reAttach(IdEObject mainObject) {
            this.getIdEObject().eSet((EStructuralFeature)this.geteReference(), (Object)mainObject);
            return new SingleReference(this.getIdEObject(), mainObject, this.geteReference());
        }
    }

    public static abstract class Reference {
        private final IdEObject idEObject;
        private final EReference eReference;
        private final IdEObject referredObject;

        public Reference(IdEObject idEObject, IdEObject referredObject, EReference eReference) {
            this.idEObject = idEObject;
            this.referredObject = referredObject;
            this.eReference = eReference;
        }

        public IdEObject getIdEObject() {
            return this.idEObject;
        }

        public EReference geteReference() {
            return this.eReference;
        }

        public abstract Reference reAttach(IdEObject var1);

        public IdEObject getReferredObject() {
            return this.referredObject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.eReference == null ? 0 : this.eReference.hashCode());
            result = 31 * result + (this.idEObject == null ? 0 : this.idEObject.hashCode());
            result = 31 * result + (this.referredObject == null ? 0 : this.referredObject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Reference other = (Reference)obj;
            if (this.eReference == null ? other.eReference != null : !this.eReference.equals(other.eReference)) {
                return false;
            }
            if (this.idEObject == null ? other.idEObject != null : !this.idEObject.equals(other.idEObject)) {
                return false;
            }
            return !(this.referredObject == null ? other.referredObject != null : !this.referredObject.equals(other.referredObject));
        }
    }
}

