/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc;

import com.google.common.collect.BiMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.tue.buildingsmart.schema.Attribute;
import nl.tue.buildingsmart.schema.EntityDefinition;
import nl.tue.buildingsmart.schema.InverseAttribute;
import nl.tue.buildingsmart.schema.SchemaDefinition;
import org.bimserver.emf.IdEObject;
import org.bimserver.ifc.IfcModel;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingGarbageCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracingGarbageCollector.class);
    private final IfcModel ifcModel;
    private final Set<IdEObject> referencedObjects = new HashSet<IdEObject>();

    public TracingGarbageCollector(IfcModel ifcModel) {
        this.ifcModel = ifcModel;
    }

    public void mark(Set<? extends IdEObject> rootObjects) {
        this.referencedObjects.addAll(rootObjects);
        SchemaDefinition schema = this.ifcModel.getPackageMetaData().getSchemaDefinition();
        for (IdEObject idEObject : rootObjects) {
            for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                Attribute attributeBNWithSuper = null;
                if (schema != null) {
                    EntityDefinition entityBN = schema.getEntityBN(idEObject.eClass().getName());
                    if (entityBN == null) {
                        LOGGER.info(idEObject.eClass().getName() + " not found");
                    } else {
                        attributeBNWithSuper = entityBN.getAttributeBNWithSuper(eReference.getName());
                        if (attributeBNWithSuper == null) {
                            LOGGER.info(eReference.getName() + " not found");
                        }
                    }
                }
                if (schema != null && attributeBNWithSuper instanceof InverseAttribute) continue;
                Object referredObject = idEObject.eGet((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    List list = (List)referredObject;
                    for (Object o : list) {
                        if (this.referencedObjects.contains(o)) continue;
                        this.mark(this.makeSet((IdEObject)o));
                    }
                    continue;
                }
                IdEObject referredIdEObject = (IdEObject)referredObject;
                if (referredIdEObject == null || this.referencedObjects.contains(referredObject)) continue;
                this.mark(this.makeSet(referredIdEObject));
            }
        }
    }

    private Set<? extends IdEObject> makeSet(IdEObject idEObject) {
        HashSet<IdEObject> set = new HashSet<IdEObject>();
        set.add(idEObject);
        return set;
    }

    public void sweep() {
        BiMap<Long, IdEObject> objects = this.ifcModel.getObjects();
        Iterator iterator = objects.keySet().iterator();
        while (iterator.hasNext()) {
            Long next = (Long)iterator.next();
            IdEObject idEObject = (IdEObject)objects.get(next);
            if (this.referencedObjects.contains(idEObject)) continue;
            iterator.remove();
        }
    }
}

