/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.bimserver.plugins.PhysicalJavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseProjectPluginFileManager
implements JavaFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseProjectPluginFileManager.class);
    private final JavaFileManager fallbackFileManager;
    private final ClassLoader classLoader;
    private final File classDir;

    public EclipseProjectPluginFileManager(JavaFileManager fallbackFileManager, ClassLoader classLoader, File classDir) {
        this.fallbackFileManager = fallbackFileManager;
        this.classLoader = classLoader;
        this.classDir = classDir;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        if (a instanceof PhysicalJavaFileObject || b instanceof PhysicalJavaFileObject) {
            return a.toUri().equals(b.toUri());
        }
        return this.fallbackFileManager.isSameFile(a, b);
    }

    @Override
    public void close() throws IOException {
        this.fallbackFileManager.close();
    }

    @Override
    public void flush() throws IOException {
        this.fallbackFileManager.flush();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fallbackFileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fallbackFileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.fallbackFileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        String path = className.replace(".", File.separator);
        String cleanPath = path;
        if (cleanPath.contains("$")) {
            cleanPath = cleanPath.substring(0, cleanPath.indexOf("$"));
        }
        return null;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fallbackFileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fallbackFileManager.hasLocation(location);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof PhysicalJavaFileObject) {
            return ((PhysicalJavaFileObject)file).getCleanName();
        }
        return this.fallbackFileManager.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        File file = new File(this.classDir, packageName.replace(".", File.separator));
        final Iterator<File> arrayList = file.isDirectory() ? Arrays.asList(file.listFiles()).iterator() : new Iterator<File>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public File next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
        Iterable<JavaFileObject> base = this.fallbackFileManager.list(location, packageName, kinds, recurse);
        if (!arrayList.hasNext()) {
            return base;
        }
        final Iterator<JavaFileObject> baseIterator = base.iterator();
        final Iterator<JavaFileObject> iterator = new Iterator<JavaFileObject>(){

            @Override
            public boolean hasNext() {
                boolean result = baseIterator.hasNext() || arrayList.hasNext();
                return result;
            }

            @Override
            public JavaFileObject next() {
                JavaFileObject next = null;
                if (baseIterator.hasNext()) {
                    next = (JavaFileObject)baseIterator.next();
                } else if (arrayList.hasNext()) {
                    try {
                        next = new PhysicalJavaFileObject((File)arrayList.next());
                    }
                    catch (IOException e) {
                        LOGGER.error("", (Throwable)e);
                    }
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        Iterable<JavaFileObject> iterable = new Iterable<JavaFileObject>(){

            @Override
            public Iterator<JavaFileObject> iterator() {
                return iterator;
            }
        };
        return iterable;
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fallbackFileManager.isSupportedOption(option);
    }
}

