/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class OptionsParser {
    private Path[] pluginDirectories;

    public OptionsParser(String ... args) {
        Options options = new Options();
        options.addOption("plugins", true, "Directory from which to load plugins");
        DefaultParser parser = new DefaultParser();
        this.pluginDirectories = null;
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("plugins")) {
                String[] plugins = cmd.getOptionValues("plugins");
                this.pluginDirectories = new Path[plugins.length];
                for (int i = 0; i < plugins.length; ++i) {
                    this.pluginDirectories[i] = Paths.get(plugins[i], new String[0]);
                    if (Files.isDirectory(this.pluginDirectories[i], new LinkOption[0])) continue;
                    throw new RuntimeException("plugins parameter must point to a directory (" + this.pluginDirectories[i] + ")");
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Path[] getPluginDirectories() {
        return this.pluginDirectories;
    }
}

