/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleVersionIdentifier;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginDescriptor;

public class PluginBundleImpl
implements PluginBundle,
Iterable<PluginContext> {
    private final Map<String, PluginContext> pluginsContexts = new HashMap<String, PluginContext>();
    private final Set<Closeable> cloaseables = new HashSet<Closeable>();
    private SPluginBundleVersion pluginBundleVersion;
    private PluginBundleVersionIdentifier pluginBundleVersionIdentifier;
    private SPluginBundle sPluginBundle;
    private PluginDescriptor pluginDescriptor;

    public PluginBundleImpl(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, PluginDescriptor pluginDescriptor) {
        this.pluginBundleVersionIdentifier = pluginBundleVersionIdentifier;
        this.sPluginBundle = sPluginBundle;
        this.pluginBundleVersion = pluginBundleVersion;
        this.pluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void add(PluginContext pluginContext) {
        this.pluginsContexts.put(pluginContext.getIdentifier(), pluginContext);
    }

    @Override
    public Iterator<PluginContext> iterator() {
        return this.pluginsContexts.values().iterator();
    }

    public void close() throws IOException {
        for (Closeable closeable : this.cloaseables) {
            closeable.close();
        }
    }

    public void addCloseable(Closeable closeable) {
        this.cloaseables.add(closeable);
    }

    public PluginBundleVersionIdentifier getPluginBundleVersionIdentifier() {
        return this.pluginBundleVersionIdentifier;
    }

    public String getVersion() {
        return this.pluginBundleVersion.getVersion();
    }

    public SPluginBundleVersion getPluginBundleVersion() {
        return this.pluginBundleVersion;
    }

    public SPluginBundle getPluginBundle() {
        SPluginBundle result = new SPluginBundle();
        result.setName(this.sPluginBundle.getName());
        result.setOrganization(this.sPluginBundle.getOrganization());
        if (this.sPluginBundle.getInstalledVersion() != null) {
            SPluginBundleVersion installedVersion = new SPluginBundleVersion();
            installedVersion.setArtifactId(this.sPluginBundle.getInstalledVersion().getArtifactId());
            installedVersion.setDescription(this.sPluginBundle.getInstalledVersion().getDescription());
            installedVersion.setGroupId(this.sPluginBundle.getInstalledVersion().getGroupId());
            installedVersion.setIcon(this.sPluginBundle.getInstalledVersion().getIcon());
            installedVersion.setMismatch(this.sPluginBundle.getInstalledVersion().isMismatch());
            installedVersion.setName(this.sPluginBundle.getInstalledVersion().getName());
            installedVersion.setOrganization(this.sPluginBundle.getInstalledVersion().getOrganization());
            installedVersion.setRepository(this.sPluginBundle.getInstalledVersion().getRepository());
            installedVersion.setType(this.sPluginBundle.getInstalledVersion().getType());
            installedVersion.setVersion(this.sPluginBundle.getInstalledVersion().getVersion());
            result.setInstalledVersion(installedVersion);
        }
        return result;
    }

    public PluginContext getPluginContext(String identifier) {
        return this.pluginsContexts.get(identifier);
    }
}

