/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.emf.Schema;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleType;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.interfaces.objects.SPluginType;
import org.bimserver.models.store.Parameter;
import org.bimserver.models.store.ServiceDescriptor;
import org.bimserver.plugins.AbstractPlugin;
import org.bimserver.plugins.Dependency;
import org.bimserver.plugins.JavaPlugin;
import org.bimserver.plugins.JsonWebModule;
import org.bimserver.plugins.MavenPluginBundle;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.NotificationsManagerInterface;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginBundleImpl;
import org.bimserver.plugins.PluginBundleVersionIdentifier;
import org.bimserver.plugins.PluginChangeListener;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginDescriptor;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.PluginSourceType;
import org.bimserver.plugins.ResourceLoader;
import org.bimserver.plugins.classloaders.DelegatingClassLoader;
import org.bimserver.plugins.classloaders.EclipsePluginClassloader;
import org.bimserver.plugins.classloaders.FileJarClassLoader;
import org.bimserver.plugins.classloaders.PublicFindClassClassLoader;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.deserializers.StreamingDeserializerPlugin;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.plugins.modelcompare.ModelComparePlugin;
import org.bimserver.plugins.modelmerger.ModelMergerPlugin;
import org.bimserver.plugins.objectidms.ObjectIDM;
import org.bimserver.plugins.objectidms.ObjectIDMException;
import org.bimserver.plugins.objectidms.ObjectIDMPlugin;
import org.bimserver.plugins.queryengine.QueryEnginePlugin;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.serializers.MessagingSerializerPlugin;
import org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.plugins.services.NewExtendedDataOnProjectHandler;
import org.bimserver.plugins.services.NewExtendedDataOnRevisionHandler;
import org.bimserver.plugins.services.NewRevisionHandler;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.plugins.stillimagerenderer.StillImageRenderPlugin;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.utils.FakeClosingInputStream;
import org.bimserver.utils.PathUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements PluginManagerInterface {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private final Map<Class<? extends Plugin>, Set<PluginContext>> implementations = new LinkedHashMap<Class<? extends Plugin>, Set<PluginContext>>();
    private final Map<Plugin, PluginContext> pluginToPluginContext = new HashMap<Plugin, PluginContext>();
    private final Map<PluginBundleIdentifier, PluginBundle> pluginBundleIdentifierToPluginBundle = new HashMap<PluginBundleIdentifier, PluginBundle>();
    private final Map<PluginBundleVersionIdentifier, PluginBundle> pluginBundleVersionIdentifierToPluginBundle = new HashMap<PluginBundleVersionIdentifier, PluginBundle>();
    private final Map<PluginBundleIdentifier, PluginBundleVersionIdentifier> pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier = new HashMap<PluginBundleIdentifier, PluginBundleVersionIdentifier>();
    private final Path tempDir;
    private final String baseClassPath;
    private final ServiceFactory serviceFactory;
    private final NotificationsManagerInterface notificationsManagerInterface;
    private final SServicesMap servicesMap;
    private final Path pluginsDir;
    private PluginChangeListener pluginChangeListener;
    private BimServerClientFactory bimServerClientFactory;
    private MetaDataManager metaDataManager;
    private MavenPluginRepository mavenPluginRepository;
    private final List<FileJarClassLoader> jarClassLoaders = new ArrayList<FileJarClassLoader>();

    public PluginManager(Path tempDir, Path pluginsDir, MavenPluginRepository mavenPluginRepository, String baseClassPath, ServiceFactory serviceFactory, NotificationsManagerInterface notificationsManagerInterface, SServicesMap servicesMap) {
        this.mavenPluginRepository = mavenPluginRepository;
        LOGGER.debug("Creating new PluginManager");
        this.pluginsDir = pluginsDir;
        this.tempDir = tempDir;
        this.baseClassPath = baseClassPath;
        this.serviceFactory = serviceFactory;
        this.notificationsManagerInterface = notificationsManagerInterface;
        this.servicesMap = servicesMap;
        if (pluginsDir != null && !Files.isDirectory(pluginsDir, new LinkOption[0])) {
            try {
                Files.createDirectories(pluginsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadPluginsFromEclipseProjectNoExceptions(Path projectRoot) {
        try {
            this.loadPluginsFromEclipseProject(projectRoot);
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private PublicFindClassClassLoader loadDependencies(Set<Dependency> bimServerDependencies, Model model, PublicFindClassClassLoader previous) throws FileNotFoundException, IOException {
        List dependencies = model.getDependencies();
        Iterator it = dependencies.iterator();
        Path workspaceDir = Paths.get("..", new String[0]);
        bimServerDependencies.add(new Dependency(workspaceDir.resolve("PluginBase/target/classes")));
        bimServerDependencies.add(new Dependency(workspaceDir.resolve("Shared/target/classes")));
        while (it.hasNext()) {
            org.apache.maven.model.Dependency depend = (org.apache.maven.model.Dependency)it.next();
            try {
                ArtifactResult resolveArtifact;
                ArtifactRequest request;
                if (depend.getGroupId().equals("org.opensourcebim") && (depend.getArtifactId().equals("shared") || depend.getArtifactId().equals("pluginbase")) || depend.isOptional() || "test".equals(depend.getScope())) continue;
                org.eclipse.aether.graph.Dependency dependency2 = new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(depend.getGroupId() + ":" + depend.getArtifactId() + ":jar:" + depend.getVersion()), "compile");
                DelegatingClassLoader depDelLoader = new DelegatingClassLoader(previous);
                if (!dependency2.getArtifact().isSnapshot()) {
                    if (dependency2.getArtifact().getFile() != null) {
                        bimServerDependencies.add(new Dependency(dependency2.getArtifact().getFile().toPath()));
                        this.loadDependencies(dependency2.getArtifact().getFile().toPath(), depDelLoader);
                    } else {
                        request = new ArtifactRequest();
                        request.setArtifact(dependency2.getArtifact());
                        request.setRepositories(this.mavenPluginRepository.getRepositories());
                        try {
                            resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
                            if (resolveArtifact.getArtifact().getFile() != null) {
                                bimServerDependencies.add(new Dependency(resolveArtifact.getArtifact().getFile().toPath()));
                                this.loadDependencies(resolveArtifact.getArtifact().getFile().toPath(), depDelLoader);
                            }
                        }
                        catch (ArtifactResolutionException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    request = new ArtifactRequest();
                    if (!"test".equals(dependency2.getScope()) && !dependency2.getArtifact().isSnapshot()) {
                        request.setArtifact(dependency2.getArtifact());
                        request.setRepositories(this.mavenPluginRepository.getLocalRepositories());
                        try {
                            resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
                            if (resolveArtifact.getArtifact().getFile() != null) {
                                bimServerDependencies.add(new Dependency(resolveArtifact.getArtifact().getFile().toPath()));
                                this.loadDependencies(resolveArtifact.getArtifact().getFile().toPath(), depDelLoader);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.info(dependency2.getArtifact().toString());
                            e.printStackTrace();
                        }
                    }
                }
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(dependency2.getArtifact());
                descriptorRequest.setRepositories(this.mavenPluginRepository.getRepositories());
                ArtifactDescriptorResult descriptorResult = this.mavenPluginRepository.getSystem().readArtifactDescriptor(this.mavenPluginRepository.getSession(), descriptorRequest);
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRootArtifact(descriptorResult.getArtifact());
                collectRequest.setDependencies(descriptorResult.getDependencies());
                collectRequest.setManagedDependencies(descriptorResult.getManagedDependencies());
                collectRequest.setRepositories(descriptorResult.getRepositories());
                DependencyNode node = this.mavenPluginRepository.getSystem().collectDependencies(this.mavenPluginRepository.getSession(), collectRequest).getRoot();
                DependencyRequest dependencyRequest = new DependencyRequest();
                dependencyRequest.setRoot(node);
                CollectResult collectResult = this.mavenPluginRepository.getSystem().collectDependencies(this.mavenPluginRepository.getSession(), collectRequest);
                PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                collectResult.getRoot().accept((DependencyVisitor)nlg);
                try {
                    this.mavenPluginRepository.getSystem().resolveDependencies(this.mavenPluginRepository.getSession(), dependencyRequest);
                }
                catch (DependencyResolutionException dependencyResolutionException) {
                    // empty catch block
                }
                for (DependencyNode dependencyNode : nlg.getNodes()) {
                    ArtifactRequest newRequest = new ArtifactRequest(dependencyNode);
                    newRequest.setRepositories(this.mavenPluginRepository.getRepositories());
                    ArtifactResult resolveArtifact2 = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), newRequest);
                    Artifact artifact = resolveArtifact2.getArtifact();
                    Path jarFile = Paths.get(artifact.getFile().getAbsolutePath(), new String[0]);
                    this.loadDependencies(jarFile, depDelLoader);
                    DefaultArtifact versionArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
                    ArtifactRequest request2 = new ArtifactRequest();
                    request2.setArtifact((Artifact)versionArtifact);
                    request2.setRepositories(this.mavenPluginRepository.getRepositories());
                    bimServerDependencies.add(new Dependency(jarFile));
                }
                previous = depDelLoader;
            }
            catch (DependencyCollectionException e) {
                e.printStackTrace();
            }
            catch (ArtifactDescriptorException e2) {
                e2.printStackTrace();
            }
            catch (ArtifactResolutionException e) {
                e.printStackTrace();
            }
        }
        return previous;
    }

    public PluginBundle loadJavaProject(Path projectRoot, Path pomFile, final Path pluginFolder, PluginDescriptor pluginDescriptor) throws PluginException, FileNotFoundException, IOException, XmlPullParserException {
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        try (FileReader reader = new FileReader(pomFile.toFile());){
            model = mavenreader.read((Reader)reader);
        }
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = new PluginBundleVersionIdentifier(model.getGroupId(), model.getArtifactId(), model.getVersion());
        if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleVersionIdentifier.getPluginBundleIdentifier())) {
            throw new PluginException("Plugin " + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getHumanReadable() + " already loaded (version " + this.pluginBundleIdentifierToPluginBundle.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier()).getPluginBundleVersion().getVersion() + ")");
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        PublicFindClassClassLoader previous = new PublicFindClassClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                return null;
            }

            @Override
            public URL findResource(String name) {
                return null;
            }

            @Override
            public void dumpStructure(int indent) {
            }
        };
        HashSet<Dependency> bimServerDependencies = new HashSet<Dependency>();
        pluginBundleVersionIdentifier = new PluginBundleVersionIdentifier(new PluginBundleIdentifier(model.getGroupId(), model.getArtifactId()), model.getVersion());
        previous = this.loadDependencies(bimServerDependencies, model, previous);
        delegatingClassLoader.add(previous);
        EclipsePluginClassloader pluginClassloader = new EclipsePluginClassloader(delegatingClassLoader, projectRoot);
        ResourceLoader resourceLoader = new ResourceLoader(){

            @Override
            public InputStream load(String name) {
                try {
                    return Files.newInputStream(pluginFolder.resolve(name), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        SPluginBundle sPluginBundle = new SPluginBundle();
        sPluginBundle.setOrganization(model.getOrganization().getName());
        sPluginBundle.setName(model.getName());
        SPluginBundleVersion sPluginBundleVersion = this.createPluginBundleVersionFromMavenModel(model, true);
        Path icon = projectRoot.resolve("icon.png");
        if (Files.exists(icon, new LinkOption[0])) {
            byte[] iconBytes = Files.readAllBytes(icon);
            sPluginBundleVersion.setIcon(iconBytes);
        }
        sPluginBundle.setInstalledVersion(sPluginBundleVersion);
        return this.loadPlugins(pluginBundleVersionIdentifier, resourceLoader, pluginClassloader, projectRoot.toUri(), projectRoot.resolve("target/classes").toString(), pluginDescriptor, PluginSourceType.ECLIPSE_PROJECT, bimServerDependencies, sPluginBundle, sPluginBundleVersion);
    }

    public PluginBundle loadPluginsFromEclipseProject(Path projectRoot) throws PluginException {
        try {
            if (!Files.isDirectory(projectRoot, new LinkOption[0])) {
                throw new PluginException("No directory: " + projectRoot.toString());
            }
            Path pluginFolder = projectRoot.resolve("plugin");
            if (!Files.isDirectory(pluginFolder, new LinkOption[0])) {
                throw new PluginException("No 'plugin' directory found in " + projectRoot.toString());
            }
            Path pluginFile = pluginFolder.resolve("plugin.xml");
            if (!Files.exists(pluginFile, new LinkOption[0])) {
                throw new PluginException("No 'plugin.xml' found in " + pluginFolder.toString());
            }
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(Files.newInputStream(pluginFile, new OpenOption[0]));
            Path pomFile = projectRoot.resolve("pom.xml");
            if (!Files.exists(pomFile, new LinkOption[0])) {
                throw new PluginException("No pom.xml found in " + projectRoot);
            }
            PluginBundle pluginBundle = this.loadJavaProject(projectRoot, pomFile, pluginFolder, pluginDescriptor);
            ArrayList<SPluginInformation> plugins = new ArrayList<SPluginInformation>();
            this.processPluginDescriptor(pluginDescriptor, plugins);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                sPluginInformation.setInstallForAllUsers(true);
                sPluginInformation.setInstallForNewUsers(true);
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                if (pluginContext == null) {
                    throw new PluginException("No plugin context found for " + sPluginInformation.getIdentifier());
                }
                pluginContext.getPlugin().init(pluginContext);
            }
            try {
                long pluginBundleVersionId = this.pluginChangeListener.pluginBundleInstalled(pluginBundle);
                for (SPluginInformation sPluginInformation : plugins) {
                    if (!sPluginInformation.isEnabled()) continue;
                    PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                    this.pluginChangeListener.pluginInstalled(pluginBundleVersionId, pluginContext, sPluginInformation);
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                throw new PluginException((Throwable)e);
            }
            return pluginBundle;
        }
        catch (JAXBException e) {
            throw new PluginException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new PluginException((Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void loadDependencies(Path libFile, DelegatingClassLoader classLoader) throws FileNotFoundException, IOException {
        if (libFile.getFileName().toString().toLowerCase().endsWith(".jar")) {
            FileJarClassLoader jarClassLoader = new FileJarClassLoader(this, classLoader, libFile);
            this.jarClassLoaders.add(jarClassLoader);
            classLoader.add(jarClassLoader);
        }
    }

    private PluginBundle loadPlugins(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, ResourceLoader resourceLoader, ClassLoader classLoader, URI location, String classLocation, PluginDescriptor pluginDescriptor, PluginSourceType pluginType, Set<Dependency> dependencies, SPluginBundle sPluginBundle, SPluginBundleVersion sPluginBundleVersion) throws PluginException {
        sPluginBundle.setInstalledVersion(sPluginBundleVersion);
        PluginBundleImpl pluginBundle = new PluginBundleImpl(pluginBundleVersionIdentifier, sPluginBundle, sPluginBundleVersion, pluginDescriptor);
        if (classLoader != null && classLoader instanceof Closeable) {
            pluginBundle.addCloseable((Closeable)((Object)classLoader));
        }
        for (AbstractPlugin pluginImplementation : pluginDescriptor.getPlugins()) {
            if (pluginImplementation instanceof JavaPlugin) {
                JavaPlugin javaPlugin = (JavaPlugin)pluginImplementation;
                String interfaceClassName = javaPlugin.getInterfaceClass().trim().replace("\n", "");
                try {
                    Class<?> interfaceClass = this.getClass().getClassLoader().loadClass(interfaceClassName);
                    if (javaPlugin.getImplementationClass() == null) continue;
                    String implementationClassName = javaPlugin.getImplementationClass().trim().replace("\n", "");
                    try {
                        Class<?> implementationClass = classLoader.loadClass(implementationClassName);
                        Plugin plugin = (Plugin)implementationClass.newInstance();
                        pluginBundle.add(this.loadPlugin(pluginBundle, interfaceClass, location, classLocation, plugin, classLoader, pluginType, pluginImplementation, dependencies, plugin.getClass().getName()));
                        continue;
                    }
                    catch (NoClassDefFoundError e) {
                        throw new PluginException("Implementation class '" + implementationClassName + "' not found", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PluginException("Implementation class '" + e.getMessage() + "' not found in " + location, (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new PluginException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PluginException((Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Interface class '" + interfaceClassName + "' not found", (Throwable)e);
                }
                catch (Error e) {
                    throw new PluginException((Throwable)e);
                }
            }
            if (!(pluginImplementation instanceof org.bimserver.plugins.WebModulePlugin)) continue;
            org.bimserver.plugins.WebModulePlugin webModulePlugin = (org.bimserver.plugins.WebModulePlugin)pluginImplementation;
            JsonWebModule jsonWebModule = new JsonWebModule(webModulePlugin);
            pluginBundle.add(this.loadPlugin(pluginBundle, WebModulePlugin.class, location, classLocation, jsonWebModule, classLoader, pluginType, pluginImplementation, dependencies, webModulePlugin.getIdentifier()));
        }
        this.pluginBundleIdentifierToPluginBundle.put(pluginBundleVersionIdentifier.getPluginBundleIdentifier(), pluginBundle);
        this.pluginBundleVersionIdentifierToPluginBundle.put(pluginBundleVersionIdentifier, pluginBundle);
        this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.put(pluginBundleVersionIdentifier.getPluginBundleIdentifier(), pluginBundleVersionIdentifier);
        return pluginBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginDescriptor getPluginDescriptor(InputStream inputStream) throws JAXBException, IOException {
        try {
            PluginDescriptor pluginDescriptor;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PluginDescriptor.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            PluginDescriptor pluginDescriptor2 = pluginDescriptor = (PluginDescriptor)unmarshaller.unmarshal(inputStream);
            return pluginDescriptor2;
        }
        finally {
            inputStream.close();
        }
    }

    public PluginDescriptor getPluginDescriptor(byte[] bytes) throws JAXBException, IOException {
        return this.getPluginDescriptor(new ByteArrayInputStream(bytes));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SPluginBundle extractPluginBundleFromJar(Path jarFilePath) throws PluginException {
        String filename = jarFilePath.getFileName().toString();
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = PluginBundleVersionIdentifier.fromFileName((String)filename);
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            String pomLocation = "META-INF/maven/" + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getGroupId() + "/" + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getArtifactId() + "/pom.xml";
            ZipEntry pomEntry = jarFile.getEntry(pomLocation);
            if (pomEntry == null) {
                throw new PluginException("No pom.xml found in JAR file " + jarFilePath.toString() + ", " + pomLocation);
            }
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            Model model = mavenreader.read(jarFile.getInputStream(pomEntry));
            SPluginBundle sPluginBundle = new SPluginBundle();
            sPluginBundle.setOrganization(model.getOrganization().getName());
            sPluginBundle.setName(model.getName());
            SPluginBundle sPluginBundle2 = sPluginBundle;
            return sPluginBundle2;
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new PluginException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SPluginBundleVersion extractPluginBundleVersionFromJar(Path jarFilePath, boolean isLocal) throws PluginException {
        String filename = jarFilePath.getFileName().toString();
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = PluginBundleVersionIdentifier.fromFileName((String)filename);
        PluginBundleIdentifier pluginBundleIdentifier = pluginBundleVersionIdentifier.getPluginBundleIdentifier();
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            SPluginBundleVersion sPluginBundleVersion;
            ZipEntry pomEntry = jarFile.getEntry("META-INF/maven/" + pluginBundleIdentifier.getGroupId() + "/" + pluginBundleIdentifier.getArtifactId() + "/pom.xml");
            if (pomEntry == null) {
                throw new PluginException("No pom.xml found in JAR file " + jarFilePath.toString());
            }
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            Model model = mavenreader.read(jarFile.getInputStream(pomEntry));
            SPluginBundleVersion sPluginBundleVersion2 = sPluginBundleVersion = this.createPluginBundleVersionFromMavenModel(model, isLocal);
            return sPluginBundleVersion2;
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private SPluginBundleVersion createPluginBundleVersionFromMavenModel(Model model, boolean isLocalDev) {
        SPluginBundleVersion sPluginBundleVersion = new SPluginBundleVersion();
        sPluginBundleVersion.setType(isLocalDev ? SPluginBundleType.LOCAL_DEV : SPluginBundleType.MAVEN);
        sPluginBundleVersion.setGroupId(model.getGroupId());
        sPluginBundleVersion.setArtifactId(model.getArtifactId());
        sPluginBundleVersion.setVersion(model.getVersion());
        sPluginBundleVersion.setDescription(model.getDescription());
        sPluginBundleVersion.setRepository("local");
        sPluginBundleVersion.setMismatch(false);
        sPluginBundleVersion.setOrganization(model.getOrganization().getName());
        sPluginBundleVersion.setName(model.getName());
        return sPluginBundleVersion;
    }

    public PluginBundle loadPluginsFromJar(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, Path file, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, ClassLoader parentClassLoader) throws PluginException {
        PluginBundleIdentifier pluginBundleIdentifier = pluginBundleVersionIdentifier.getPluginBundleIdentifier();
        if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
            throw new PluginException("Plugin " + pluginBundleIdentifier.getHumanReadable() + " already loaded (version " + this.pluginBundleIdentifierToPluginBundle.get(pluginBundleIdentifier).getPluginBundleVersion().getVersion() + ")");
        }
        LOGGER.debug("Loading plugins from " + file.toString());
        if (!Files.exists(file, new LinkOption[0])) {
            throw new PluginException("Not a file: " + file.toString());
        }
        FileJarClassLoader jarClassLoader = null;
        try {
            jarClassLoader = new FileJarClassLoader(this, parentClassLoader, file);
            this.jarClassLoaders.add(jarClassLoader);
            final FileJarClassLoader finalLoader = jarClassLoader;
            InputStream pluginStream = jarClassLoader.getResourceAsStream("plugin/plugin.xml");
            if (pluginStream == null) {
                jarClassLoader.close();
                throw new PluginException("No plugin/plugin.xml found in " + file.getFileName().toString());
            }
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(pluginStream);
            if (pluginDescriptor == null) {
                jarClassLoader.close();
                throw new PluginException("No plugin descriptor could be created");
            }
            LOGGER.debug(pluginDescriptor.toString());
            URI fileUri = file.toAbsolutePath().toUri();
            URI jarUri = new URI("jar:" + fileUri.toString());
            ResourceLoader resourceLoader = new ResourceLoader(){

                @Override
                public InputStream load(String name) {
                    return finalLoader.getResourceAsStream(name);
                }
            };
            return this.loadPlugins(pluginBundleVersionIdentifier, resourceLoader, jarClassLoader, jarUri, file.toAbsolutePath().toString(), pluginDescriptor, PluginSourceType.JAR_FILE, new HashSet<Dependency>(), sPluginBundle, pluginBundleVersion);
        }
        catch (Exception e) {
            if (jarClassLoader != null) {
                try {
                    jarClassLoader.close();
                }
                catch (IOException e1) {
                    LOGGER.error("", (Throwable)e1);
                }
            }
            throw new PluginException((Throwable)e);
        }
    }

    private <T> Map<PluginContext, T> getPlugins(Class<T> requiredInterfaceClass, boolean onlyEnabled) {
        HashMap<PluginContext, Plugin> plugins = new HashMap<PluginContext, Plugin>();
        for (Class<? extends Plugin> interfaceClass : this.implementations.keySet()) {
            if (!requiredInterfaceClass.isAssignableFrom(interfaceClass)) continue;
            for (PluginContext pluginContext : this.implementations.get(interfaceClass)) {
                if (onlyEnabled && !pluginContext.isEnabled()) continue;
                plugins.put(pluginContext, pluginContext.getPlugin());
            }
        }
        return plugins;
    }

    public Map<PluginContext, ObjectIDMPlugin> getAllObjectIDMPlugins(boolean onlyEnabled) {
        return this.getPlugins(ObjectIDMPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, RenderEnginePlugin> getAllRenderEnginePlugins(boolean onlyEnabled) {
        return this.getPlugins(RenderEnginePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, StillImageRenderPlugin> getAllStillImageRenderPlugins(boolean onlyEnabled) {
        return this.getPlugins(StillImageRenderPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, QueryEnginePlugin> getAllQueryEnginePlugins(boolean onlyEnabled) {
        return this.getPlugins(QueryEnginePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, SerializerPlugin> getAllSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(SerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, MessagingSerializerPlugin> getAllMessagingSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(MessagingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, MessagingStreamingSerializerPlugin> getAllMessagingStreamingSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(MessagingStreamingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, DeserializerPlugin> getAllDeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(DeserializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, StreamingDeserializerPlugin> getAllStreamingDeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(StreamingDeserializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, StreamingSerializerPlugin> getAllStreamingSeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(StreamingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, Plugin> getAllPlugins(boolean onlyEnabled) {
        return this.getPlugins(Plugin.class, onlyEnabled);
    }

    public PluginContext getPluginContext(Plugin plugin) {
        PluginContext pluginContext = this.pluginToPluginContext.get(plugin);
        if (pluginContext == null) {
            throw new RuntimeException("No plugin context found for " + plugin);
        }
        return pluginContext;
    }

    public void enablePlugin(String name) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getPlugin().getClass().getName().equals(name)) continue;
                pluginContext.setEnabled(true, true);
            }
        }
    }

    public void disablePlugin(String name) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getPlugin().getClass().getName().equals(name)) continue;
                pluginContext.setEnabled(false, true);
            }
        }
    }

    public Plugin getPlugin(String identifier, boolean onlyEnabled) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getIdentifier().equals(identifier) || onlyEnabled && !pluginContext.isEnabled()) continue;
                return pluginContext.getPlugin();
            }
        }
        return null;
    }

    public boolean isEnabled(String className) {
        return this.getPlugin(className, true) != null;
    }

    public void setPluginChangeListener(PluginChangeListener pluginChangeListener) {
        this.pluginChangeListener = pluginChangeListener;
    }

    public Collection<DeserializerPlugin> getAllDeserializerPlugins(String extension, boolean onlyEnabled) {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(onlyEnabled).values();
        Iterator<DeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            DeserializerPlugin deserializerPlugin = iterator.next();
            if (deserializerPlugin.canHandleExtension(extension)) continue;
            iterator.remove();
        }
        return allDeserializerPlugins;
    }

    public DeserializerPlugin requireDeserializer(String extension) throws DeserializeException {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(extension, true);
        if (allDeserializerPlugins.size() == 0) {
            throw new DeserializeException("No deserializers found for type '" + extension + "'");
        }
        return allDeserializerPlugins.iterator().next();
    }

    public Path getTempDir() {
        if (!Files.isDirectory(this.tempDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.tempDir;
    }

    public PluginContext loadPlugin(PluginBundle pluginBundle, Class<? extends Plugin> interfaceClass, URI location, String classLocation, Plugin plugin, ClassLoader classLoader, PluginSourceType pluginType, AbstractPlugin pluginImplementation, Set<Dependency> dependencies, String identifier) throws PluginException {
        LOGGER.debug("Loading plugin " + plugin.getClass().getSimpleName() + " of type " + interfaceClass.getSimpleName());
        if (!Plugin.class.isAssignableFrom(interfaceClass)) {
            throw new PluginException("Given interface class (" + interfaceClass.getName() + ") must be a subclass of " + Plugin.class.getName());
        }
        if (!this.implementations.containsKey(interfaceClass)) {
            this.implementations.put(interfaceClass, new LinkedHashSet());
        }
        Set<PluginContext> set = this.implementations.get(interfaceClass);
        try {
            PluginContext pluginContext = new PluginContext((PluginManagerInterface)this, pluginBundle, interfaceClass, classLoader, pluginType, pluginImplementation.getDescription(), location, plugin, classLocation, dependencies, identifier);
            this.pluginToPluginContext.put(plugin, pluginContext);
            set.add(pluginContext);
            return pluginContext;
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void initAllLoadedPlugins() throws PluginException {
        LOGGER.debug("Initializig all loaded plugins");
        for (Class<? extends Plugin> pluginClass : this.implementations.keySet()) {
            Set<PluginContext> set = this.implementations.get(pluginClass);
            for (PluginContext pluginContext : set) {
                try {
                    pluginContext.initialize();
                }
                catch (Throwable e) {
                    LOGGER.error("", e);
                    pluginContext.setEnabled(false, false);
                }
            }
        }
    }

    public String getCompleteClassPath() {
        StringBuilder sb = new StringBuilder();
        if (this.baseClassPath != null) {
            sb.append(this.baseClassPath + File.pathSeparator);
        }
        for (Class<? extends Plugin> pluginClass : this.implementations.keySet()) {
            Set<PluginContext> set = this.implementations.get(pluginClass);
            for (PluginContext pluginContext : set) {
                sb.append(pluginContext.getClassLocation() + File.pathSeparator);
            }
        }
        return sb.toString();
    }

    public DeserializerPlugin getFirstDeserializer(String extension, Schema schema, boolean onlyEnabled) throws PluginException {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(extension, onlyEnabled);
        Iterator<DeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            DeserializerPlugin next = iterator.next();
            if (next.getSupportedSchemas().contains(schema)) continue;
            iterator.remove();
        }
        if (allDeserializerPlugins.size() == 0) {
            throw new PluginException("No deserializers with extension " + extension + " found");
        }
        return allDeserializerPlugins.iterator().next();
    }

    public StreamingDeserializerPlugin getFirstStreamingDeserializer(String extension, Schema schema, boolean onlyEnabled) throws PluginException {
        Map<PluginContext, StreamingDeserializerPlugin> allDeserializerPlugins = this.getAllStreamingDeserializerPlugins(onlyEnabled);
        Iterator<StreamingDeserializerPlugin> iterator = allDeserializerPlugins.values().iterator();
        while (iterator.hasNext()) {
            StreamingDeserializerPlugin next = iterator.next();
            if (next.getSupportedSchemas().contains(schema)) continue;
            iterator.remove();
        }
        if (allDeserializerPlugins.size() == 0) {
            throw new PluginException("No deserializers with extension " + extension + " found");
        }
        return allDeserializerPlugins.values().iterator().next();
    }

    public ObjectIDMPlugin getObjectIDMByName(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ObjectIDMPlugin.class, className, onlyEnabled);
    }

    public RenderEnginePlugin getRenderEnginePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(RenderEnginePlugin.class, className, onlyEnabled);
    }

    private <T extends Plugin> T getPluginByClassName(Class<T> clazz, String className, boolean onlyEnabled) {
        Collection<T> allPlugins = this.getPlugins(clazz, onlyEnabled).values();
        for (Plugin t : allPlugins) {
            if (!t.getClass().getName().equals(className)) continue;
            return (T)t;
        }
        return null;
    }

    public QueryEnginePlugin getQueryEngine(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(QueryEnginePlugin.class, className, onlyEnabled);
    }

    public void loadAllPluginsFromEclipseWorkspace(Path file, boolean showExceptions) throws PluginException, IOException {
        if (file != null && Files.isDirectory(file, new LinkOption[0])) {
            for (Path project : PathUtils.list((Path)file)) {
                Path pluginFile;
                Path pluginDir;
                if (!Files.isDirectory(project, new LinkOption[0]) || !Files.exists(pluginDir = project.resolve("plugin"), new LinkOption[0]) || !Files.exists(pluginFile = pluginDir.resolve("plugin.xml"), new LinkOption[0])) continue;
                if (showExceptions) {
                    this.loadPluginsFromEclipseProject(project);
                    continue;
                }
                this.loadPluginsFromEclipseProjectNoExceptions(project);
            }
        }
    }

    public void loadAllPluginsFromEclipseWorkspaces(Path directory, boolean showExceptions) throws PluginException, IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        if (Files.exists(directory.resolve("plugin/plugin.xml"), new LinkOption[0])) {
            if (showExceptions) {
                this.loadPluginsFromEclipseProject(directory);
            } else {
                this.loadPluginsFromEclipseProjectNoExceptions(directory);
            }
        }
        this.loadAllPluginsFromEclipseWorkspace(directory, showExceptions);
        for (Path workspace : PathUtils.list((Path)directory)) {
            if (!Files.isDirectory(workspace, new LinkOption[0])) continue;
            this.loadAllPluginsFromEclipseWorkspace(workspace, showExceptions);
        }
    }

    public Map<PluginContext, ModelMergerPlugin> getAllModelMergerPlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelMergerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, ModelComparePlugin> getAllModelComparePlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelComparePlugin.class, onlyEnabled);
    }

    public ModelMergerPlugin getModelMergerPlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelMergerPlugin.class, className, onlyEnabled);
    }

    public ModelComparePlugin getModelComparePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelComparePlugin.class, className, onlyEnabled);
    }

    public Map<PluginContext, ServicePlugin> getAllServicePlugins(boolean onlyEnabled) {
        return this.getPlugins(ServicePlugin.class, onlyEnabled);
    }

    public ServicePlugin getServicePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ServicePlugin.class, className, onlyEnabled);
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void registerNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, NewRevisionHandler newRevisionHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewRevisionHandler(uoid, serviceDescriptor, newRevisionHandler);
        }
    }

    public void unregisterNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.unregisterInternalNewRevisionHandler(uoid, serviceDescriptor.getIdentifier());
        }
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }

    public Parameter getParameter(PluginContext pluginContext, String name) {
        return null;
    }

    public SerializerPlugin getSerializerPlugin(String className, boolean onlyEnabled) {
        return (SerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public MessagingSerializerPlugin getMessagingSerializerPlugin(String className, boolean onlyEnabled) {
        return (MessagingSerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public WebModulePlugin getWebModulePlugin(String className, boolean onlyEnabled) {
        return (WebModulePlugin)this.getPlugin(className, onlyEnabled);
    }

    public Map<PluginContext, WebModulePlugin> getAllWebPlugins(boolean onlyEnabled) {
        return this.getPlugins(WebModulePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, ModelCheckerPlugin> getAllModelCheckerPlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelCheckerPlugin.class, onlyEnabled);
    }

    public ModelCheckerPlugin getModelCheckerPlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelCheckerPlugin.class, className, onlyEnabled);
    }

    public BimServerClientInterface getLocalBimServerClientInterface(AuthenticationInfo tokenAuthentication) throws ServiceException, ChannelConnectionException {
        return this.bimServerClientFactory.create(tokenAuthentication);
    }

    public void setBimServerClientFactory(BimServerClientFactory bimServerClientFactory) {
        this.bimServerClientFactory = bimServerClientFactory;
    }

    public void registerNewExtendedDataOnProjectHandler(long uoid, ServiceDescriptor serviceDescriptor, NewExtendedDataOnProjectHandler newExtendedDataHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewExtendedDataOnProjectHandler(uoid, serviceDescriptor, newExtendedDataHandler);
        }
    }

    public void registerNewExtendedDataOnRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, NewExtendedDataOnRevisionHandler newExtendedDataHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewExtendedDataOnRevisionHandler(uoid, serviceDescriptor, newExtendedDataHandler);
        }
    }

    public DeserializerPlugin getDeserializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(DeserializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public StreamingDeserializerPlugin getStreamingDeserializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(StreamingDeserializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public StreamingSerializerPlugin getStreamingSerializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(StreamingSerializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public void setMetaDataManager(MetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public FileSystem getOrCreateFileSystem(URI uri) throws IOException {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            fileSystem = FileSystems.newFileSystem(uri, env, null);
            LOGGER.debug("Created VFS for " + uri);
        }
        return fileSystem;
    }

    public MessagingStreamingSerializerPlugin getMessagingStreamingSerializerPlugin(String className, boolean onlyEnabled) {
        return (MessagingStreamingSerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public List<SPluginInformation> getPluginInformationFromJar(Path file) throws PluginException, FileNotFoundException, IOException, JAXBException {
        try (JarFile jarFile = new JarFile(file.toFile());){
            ZipEntry entry = jarFile.getEntry("plugin/plugin.xml");
            if (entry == null) {
                throw new PluginException("No plugin/plugin.xml found in " + file.getFileName().toString());
            }
            InputStream pluginStream = jarFile.getInputStream(entry);
            List<SPluginInformation> list = this.getPluginInformationFromPluginFile(pluginStream);
            return list;
        }
    }

    public List<SPluginInformation> getPluginInformationFromJar(InputStream jarInputStream) throws PluginException, FileNotFoundException, IOException, JAXBException {
        try (JarInputStream jarInputStream2 = new JarInputStream(jarInputStream);){
            JarEntry next = jarInputStream2.getNextJarEntry();
            while (next != null) {
                if (next.getName().equals("plugin/plugin.xml")) {
                    List<SPluginInformation> list = this.getPluginInformationFromPluginFile(jarInputStream2);
                    return list;
                }
                next = jarInputStream2.getNextJarEntry();
            }
        }
        return null;
    }

    public List<SPluginInformation> getPluginInformationFromPluginFile(InputStream inputStream) throws PluginException, FileNotFoundException, IOException, JAXBException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(inputStream);
        if (pluginDescriptor == null) {
            throw new PluginException("No plugin descriptor could be created");
        }
        ArrayList<SPluginInformation> list = new ArrayList<SPluginInformation>();
        this.processPluginDescriptor(pluginDescriptor, list);
        return list;
    }

    private void processPluginDescriptor(PluginDescriptor pluginDescriptor, List<SPluginInformation> list) {
        for (AbstractPlugin pluginImplementation : pluginDescriptor.getPlugins()) {
            SPluginInformation sPluginInformation;
            if (pluginImplementation instanceof JavaPlugin) {
                JavaPlugin javaPlugin = (JavaPlugin)pluginImplementation;
                sPluginInformation = new SPluginInformation();
                String name = javaPlugin.getName();
                if (name == null) {
                    name = javaPlugin.getImplementationClass();
                }
                sPluginInformation.setName(name);
                sPluginInformation.setDescription(javaPlugin.getDescription());
                sPluginInformation.setEnabled(true);
                sPluginInformation.setIdentifier(javaPlugin.getImplementationClass());
                sPluginInformation.setType(this.getPluginTypeFromClass(javaPlugin.getInterfaceClass()));
                list.add(sPluginInformation);
                continue;
            }
            if (!(pluginImplementation instanceof org.bimserver.plugins.WebModulePlugin)) continue;
            org.bimserver.plugins.WebModulePlugin webModulePlugin = (org.bimserver.plugins.WebModulePlugin)pluginImplementation;
            sPluginInformation = new SPluginInformation();
            sPluginInformation.setIdentifier(webModulePlugin.getIdentifier());
            sPluginInformation.setName(webModulePlugin.getName());
            sPluginInformation.setDescription(webModulePlugin.getDescription());
            sPluginInformation.setType(SPluginType.WEB_MODULE);
            sPluginInformation.setEnabled(true);
            list.add(sPluginInformation);
        }
    }

    public List<SPluginInformation> getPluginInformationFromPluginFile(Path file) throws PluginException, FileNotFoundException, IOException, JAXBException {
        ArrayList<SPluginInformation> list = new ArrayList<SPluginInformation>();
        try (InputStream pluginStream = Files.newInputStream(file, new OpenOption[0]);){
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(pluginStream);
            if (pluginDescriptor == null) {
                throw new PluginException("No plugin descriptor could be created");
            }
            this.processPluginDescriptor(pluginDescriptor, list);
        }
        return list;
    }

    public SPluginType getPluginTypeFromClass(String className) {
        switch (className) {
            case "org.bimserver.plugins.deserializers.DeserializerPlugin": {
                return SPluginType.DESERIALIZER;
            }
            case "org.bimserver.plugins.deserializers.StreamingDeserializerPlugin": {
                return SPluginType.DESERIALIZER;
            }
            case "org.bimserver.plugins.serializers.SerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.StreamingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.MessagingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.modelchecker.ModelCheckerPlugin": {
                return SPluginType.MODEL_CHECKER;
            }
            case "org.bimserver.plugins.modelmerger.ModelMergerPlugin": {
                return SPluginType.MODEL_MERGER;
            }
            case "org.bimserver.plugins.modelcompare.ModelComparePlugin": {
                return SPluginType.MODEL_COMPARE;
            }
            case "org.bimserver.plugins.objectidms.ObjectIDMPlugin": {
                return SPluginType.OBJECT_IDM;
            }
            case "org.bimserver.plugins.queryengine.QueryEnginePlugin": {
                return SPluginType.QUERY_ENGINE;
            }
            case "org.bimserver.plugins.services.ServicePlugin": {
                return SPluginType.SERVICE;
            }
            case "org.bimserver.plugins.renderengine.RenderEnginePlugin": {
                return SPluginType.RENDER_ENGINE;
            }
            case "org.bimserver.plugins.stillimagerenderer.StillImageRenderPlugin": {
                return SPluginType.STILL_IMAGE_RENDER;
            }
            case "org.bimserver.plugins.web.WebModulePlugin": {
                return SPluginType.WEB_MODULE;
            }
        }
        return null;
    }

    public PluginBundle loadFromPluginDir(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, SPluginBundleVersion pluginBundleVersion, List<SPluginInformation> plugins, boolean strictDependencyChecking) throws Exception {
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (!Files.exists(target, new LinkOption[0])) {
            throw new PluginException(target.toString() + " not found");
        }
        SPluginBundle sPluginBundle = new SPluginBundle();
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        try (JarFile jarFile = new JarFile(target.toFile());){
            ZipEntry entry = jarFile.getEntry("META-INF/maven/" + pluginBundleVersion.getGroupId() + "/" + pluginBundleVersion.getArtifactId() + "/pom.xml");
            Model model = mavenreader.read(jarFile.getInputStream(entry));
            sPluginBundle.setOrganization(model.getOrganization().getName());
            sPluginBundle.setName(model.getName());
            DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
            for (org.apache.maven.model.Dependency dependency : model.getDependencies()) {
                if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
                PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependency.getGroupId(), dependency.getArtifactId());
                if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                    if (strictDependencyChecking) {
                        String version;
                        DefaultArtifactVersion artifactVersion;
                        VersionRange versionRange = VersionRange.createFromVersion((String)dependency.getVersion());
                        if (versionRange.containsVersion((ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(version = this.pluginBundleIdentifierToPluginBundle.get(pluginBundleIdentifier).getPluginBundleVersion().getVersion())))) continue;
                        throw new Exception("Required dependency " + pluginBundleIdentifier + " is installed, but it's version (" + version + ") does not comply to the required version (" + dependency.getVersion() + ")");
                    }
                    LOGGER.info("Skipping strict dependency checking for dependency " + dependency.getArtifactId());
                    continue;
                }
                if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
                MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(((Repository)model.getRepositories().get(0)).getUrl(), dependency.getGroupId(), dependency.getArtifactId());
                try {
                    Path depJarFile = mavenPluginLocation.getVersionJar(dependency.getVersion());
                    FileJarClassLoader jarClassLoader = new FileJarClassLoader(this, delegatingClassLoader, depJarFile);
                    this.jarClassLoaders.add(jarClassLoader);
                    delegatingClassLoader.add(jarClassLoader);
                }
                catch (Exception exception) {}
            }
            PluginBundle pluginBundle = this.loadPlugin(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, plugins, delegatingClassLoader);
            return pluginBundle;
        }
    }

    public PluginBundle loadPlugin(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, Path target, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, List<SPluginInformation> plugins, ClassLoader parentClassLoader) throws Exception {
        PluginBundle pluginBundle = null;
        try {
            pluginBundle = this.loadPluginsFromJar(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, parentClassLoader);
            if (plugins.isEmpty()) {
                LOGGER.warn("No plugins given to install for bundle " + sPluginBundle.getName());
            }
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                if (pluginContext == null) {
                    LOGGER.info("No plugin context found for " + sPluginInformation.getIdentifier());
                    continue;
                }
                pluginContext.getPlugin().init(pluginContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (pluginBundle != null) {
                pluginBundle.close();
            }
            this.pluginBundleVersionIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier);
            this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            Files.delete(target);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
        try {
            long pluginBundleVersionId = this.pluginChangeListener.pluginBundleInstalled(pluginBundle);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                this.pluginChangeListener.pluginInstalled(pluginBundleVersionId, pluginContext, sPluginInformation);
            }
            return pluginBundle;
        }
        catch (Exception e) {
            this.uninstall(pluginBundleVersionIdentifier);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public PluginBundle install(MavenPluginBundle mavenPluginBundle, boolean strictDependencyChecking) throws Exception {
        return this.install(mavenPluginBundle, null, strictDependencyChecking);
    }

    public PluginBundle install(MavenPluginBundle mavenPluginBundle, List<SPluginInformation> plugins, boolean strictDependencyChecking) throws Exception {
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = mavenPluginBundle.getPluginVersionIdentifier();
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        InputStream pomInputStream = mavenPluginBundle.getPomInputStream();
        Object object = null;
        try {
            model = mavenreader.read(pomInputStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (pomInputStream != null) {
                if (object != null) {
                    try {
                        pomInputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    pomInputStream.close();
                }
            }
        }
        if (plugins == null) {
            JarInputStream jarInputStream = new JarInputStream(mavenPluginBundle.getJarInputStream());
            object = null;
            try {
                JarEntry nextJarEntry = jarInputStream.getNextJarEntry();
                while (nextJarEntry != null) {
                    if (nextJarEntry.getName().equals("plugin/plugin.xml")) {
                        PluginDescriptor pluginDescriptor = this.getPluginDescriptor((InputStream)new FakeClosingInputStream((InputStream)jarInputStream));
                        plugins = new ArrayList<SPluginInformation>();
                        this.processPluginDescriptor(pluginDescriptor, plugins);
                        for (SPluginInformation info : plugins) {
                            info.setInstallForAllUsers(true);
                            info.setInstallForNewUsers(true);
                        }
                        break;
                    }
                    nextJarEntry = jarInputStream.getNextJarEntry();
                }
            }
            catch (Throwable nextJarEntry) {
                object = nextJarEntry;
                throw nextJarEntry;
            }
            finally {
                if (jarInputStream != null) {
                    if (object != null) {
                        try {
                            jarInputStream.close();
                        }
                        catch (Throwable nextJarEntry) {
                            ((Throwable)object).addSuppressed(nextJarEntry);
                        }
                    } else {
                        jarInputStream.close();
                    }
                }
            }
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        for (org.apache.maven.model.Dependency dependency : model.getDependencies()) {
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependency.getGroupId(), dependency.getArtifactId());
            if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                if (strictDependencyChecking) {
                    DefaultArtifactVersion artifactVersion;
                    VersionRange versionRange = VersionRange.createFromVersion((String)dependency.getVersion());
                    if (versionRange.containsVersion((ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(mavenPluginBundle.getVersion())))) continue;
                    throw new Exception("Required dependency " + pluginBundleIdentifier + " is installed, but it's version (" + mavenPluginBundle.getVersion() + ") does not comply to the required version (" + dependency.getVersion() + ")");
                }
                LOGGER.info("Skipping strict dependency checking for dependency " + dependency.getArtifactId());
                continue;
            }
            try {
                MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(dependency.getGroupId(), dependency.getArtifactId());
                Path depJarFile = mavenPluginLocation.getVersionJar(dependency.getVersion());
                FileJarClassLoader jarClassLoader = new FileJarClassLoader(this, delegatingClassLoader, depJarFile);
                this.jarClassLoaders.add(jarClassLoader);
                delegatingClassLoader.add(jarClassLoader);
            }
            catch (Exception e) {
                throw new Exception("Required dependency " + pluginBundleIdentifier + " is not installed");
            }
        }
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (Files.exists(target, new LinkOption[0])) {
            throw new PluginException("This plugin has already been installed " + target.getFileName().toString());
        }
        Files.copy(mavenPluginBundle.getJarInputStream(), target, new CopyOption[0]);
        return this.loadPlugin(pluginBundleVersionIdentifier, target, mavenPluginBundle.getPluginBundle(), mavenPluginBundle.getPluginBundleVersion(), plugins, delegatingClassLoader);
    }

    public void uninstall(PluginBundleVersionIdentifier pluginBundleVersionIdentifier) {
        PluginBundle pluginBundle = this.pluginBundleVersionIdentifierToPluginBundle.get(pluginBundleVersionIdentifier);
        if (pluginBundle == null) {
            return;
        }
        try {
            pluginBundle.close();
            this.pluginBundleVersionIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier);
            this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            for (PluginContext pluginContext : pluginBundle) {
                Set<PluginContext> set = this.implementations.get(pluginContext.getPluginInterface());
                set.remove(pluginContext);
            }
            Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
            Files.delete(target);
            for (PluginContext pluginContext : pluginBundle) {
                this.pluginChangeListener.pluginUninstalled(pluginContext);
            }
            this.pluginChangeListener.pluginBundleUninstalled(pluginBundle);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public PluginBundle getPluginBundle(PluginBundleIdentifier pluginIdentifier) {
        return this.pluginBundleIdentifierToPluginBundle.get(pluginIdentifier);
    }

    public Collection<PluginBundle> getPluginBundles() {
        return this.pluginBundleVersionIdentifierToPluginBundle.values();
    }

    public ObjectIDM getDefaultObjectIDM() throws ObjectIDMException {
        return null;
    }

    public void notifyPluginStateChange(PluginContext pluginContext, boolean enabled) {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginStateChanged(pluginContext, enabled);
        }
    }

    public PluginBundle update(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, Path jarFile, Path pomFile, List<SPluginInformation> plugins) throws Exception {
        PluginBundle existingPluginBundle = this.pluginBundleIdentifierToPluginBundle.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
        if (existingPluginBundle == null) {
            throw new UserException("No previous version of plugin bundle " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " found");
        }
        try {
            existingPluginBundle.close();
            if (this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier()) == null) {
                LOGGER.warn("Previous version of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            PluginBundleVersionIdentifier currentVersion = this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            if (this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier()) == null) {
                LOGGER.warn("Previous version of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            if (this.pluginBundleVersionIdentifierToPluginBundle.remove(currentVersion) == null) {
                LOGGER.warn("Previous version (" + currentVersion + ") of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            for (PluginContext pluginContext : existingPluginBundle) {
                Set<PluginContext> set = this.implementations.get(pluginContext.getPluginInterface());
                set.remove(pluginContext);
            }
            if (existingPluginBundle.getPluginBundle().getInstalledVersion().getType() == SPluginBundleType.MAVEN) {
                Path target = this.pluginsDir.resolve(currentVersion.getFileName());
                Files.delete(target);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (Files.exists(target, new LinkOption[0])) {
            throw new PluginException("This plugin has already been installed " + target.getFileName().toString());
        }
        Files.copy(jarFile, target, new CopyOption[0]);
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        FileReader fileReader = new FileReader(pomFile.toFile());
        Object object = null;
        try {
            model = mavenreader.read((Reader)fileReader);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fileReader != null) {
                if (object != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fileReader.close();
                }
            }
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        for (Object dependency : model.getDependencies()) {
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependency.getGroupId(), dependency.getArtifactId());
            if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                LOGGER.info("Skipping strict dependency checking for dependency " + dependency.getArtifactId());
                continue;
            }
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) {
                throw new Exception("Required dependency " + pluginBundleIdentifier + " is not installed");
            }
            MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(((Repository)model.getRepositories().get(0)).getUrl(), dependency.getGroupId(), dependency.getArtifactId());
            try {
                Path depJarFile = mavenPluginLocation.getVersionJar(dependency.getVersion());
                FileJarClassLoader jarClassLoader = new FileJarClassLoader(this, delegatingClassLoader, depJarFile);
                this.jarClassLoaders.add(jarClassLoader);
                delegatingClassLoader.add(jarClassLoader);
            }
            catch (Exception depJarFile) {}
        }
        PluginBundle pluginBundle = null;
        try {
            pluginBundle = this.loadPluginsFromJar(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, delegatingClassLoader);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                pluginContext.getPlugin().init(pluginContext);
            }
        }
        catch (Exception e) {
            Files.delete(target);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
        try {
            long pluginBundleVersionId = this.pluginChangeListener.pluginBundleUpdated(pluginBundle);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                this.pluginChangeListener.pluginUpdated(pluginBundleVersionId, pluginContext, sPluginInformation);
            }
            return pluginBundle;
        }
        catch (Exception e) {
            this.uninstall(pluginBundleVersionIdentifier);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public SerializerPlugin getSerializerPlugin(String pluginClassName) {
        return this.getPluginByClassName(SerializerPlugin.class, pluginClassName, true);
    }

    public void close() {
        for (FileJarClassLoader fileJarClassLoader : this.jarClassLoaders) {
            try {
                fileJarClassLoader.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

