/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins.classloaders;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.classloaders.JarClassLoader;
import org.bimserver.plugins.classloaders.Lazy;
import org.bimserver.utils.PathUtils;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileJarClassLoader
extends JarClassLoader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileJarClassLoader.class);
    private final Map<String, Class<?>> loadedClasses = new HashMap();
    private final Map<String, byte[]> jarContent = new HashMap<String, byte[]>();
    private final Path jarFile;
    private FileSystem fileSystem;
    private boolean embeddedJarFilesLoaded = false;

    public FileJarClassLoader(PluginManager pluginManager, ClassLoader parentClassLoader, Path jarFile) throws FileNotFoundException, IOException {
        super(parentClassLoader);
        this.jarFile = jarFile;
        URI uri = jarFile.toUri();
        try {
            URI x = new URI("jar:" + uri.toString());
            this.fileSystem = pluginManager.getOrCreateFileSystem(x);
        }
        catch (URISyntaxException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void loadEmbeddedJarFileSystems() {
        if (!this.embeddedJarFilesLoaded) {
            this.loadEmbeddedJarFileSystems(this.fileSystem.getPath("/", new String[0]));
            this.embeddedJarFilesLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEmbeddedJarFileSystems(Path path) {
        block8: {
            try {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    for (Path subPath : PathUtils.list((Path)path)) {
                        this.loadEmbeddedJarFileSystems(subPath);
                    }
                    break block8;
                }
                if (!path.getFileName().toString().toLowerCase().endsWith(".jar")) break block8;
                try (JarInputStream jarInputStream = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                    JarEntry jarEntry = jarInputStream.getNextJarEntry();
                    while (jarEntry != null) {
                        this.jarContent.put(jarEntry.getName(), IOUtils.toByteArray((InputStream)jarInputStream));
                        jarEntry = jarInputStream.getNextJarEntry();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    @Override
    public URL findResource(String name) {
        try {
            final Lazy<InputStream> lazyInputStream = this.findPath(name);
            if (lazyInputStream != null) {
                try {
                    URL baseUrl = new URL("file:" + name);
                    URL url = new URL(baseUrl, name, new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) throws IOException {
                            return new URLConnection(u){

                                @Override
                                public void connect() throws IOException {
                                }

                                @Override
                                public InputStream getInputStream() throws IOException {
                                    return (InputStream)lazyInputStream.get();
                                }
                            };
                        }
                    });
                    return url;
                }
                catch (MalformedURLException e) {
                    LOGGER.error("", (Throwable)e);
                }
            } else {
                LOGGER.debug("File not found: " + name + " (in " + this.jarFile.getFileName().toString() + ")");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    private Lazy<InputStream> findPath(final String name) throws IOException {
        this.loadEmbeddedJarFileSystems();
        final Path file = this.fileSystem.getPath(name, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return new Lazy<InputStream>(){

                @Override
                public InputStream get() {
                    try {
                        return Files.newInputStream(file, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        if (this.jarContent.containsKey(name)) {
            return new Lazy<InputStream>(){

                @Override
                public InputStream get() {
                    return new ByteArrayInputStream((byte[])FileJarClassLoader.this.jarContent.get(name));
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String fileName = name.replace(".", "/") + ".class";
        if (this.loadedClasses.containsKey(fileName)) {
            return this.loadedClasses.get(fileName);
        }
        try {
            String packageName;
            Package classPackage;
            int packageIndex;
            Lazy<InputStream> lazyInputStream = this.findPath(fileName);
            if (lazyInputStream == null) {
                throw new ClassNotFoundException(name);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (InputStream inputStream = lazyInputStream.get();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            }
            Class<?> defineClass = this.defineClass(name, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            this.loadedClasses.put(fileName, defineClass);
            if (defineClass != null && (packageIndex = name.lastIndexOf(46)) != -1 && (classPackage = this.getPackage(packageName = name.substring(0, packageIndex))) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            return defineClass;
        }
        catch (FileNotFoundException e) {
            throw new ClassNotFoundException(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public void dumpStructure(int indent) {
        System.out.print(StringUtils.gen((String)"  ", (int)indent));
        System.out.println("FileJarClassLoader " + this.jarFile.getFileName().toString());
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }
}

