/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins.classloaders;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bimserver.plugins.classloaders.JarClassLoader;
import org.bimserver.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryJarClassLoader
extends JarClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryJarClassLoader.class);
    private final File jarFile;
    private final Map<String, byte[]> map = new HashMap<String, byte[]>();
    private final Map<String, Class<?>> loadedClasses = new HashMap();

    public MemoryJarClassLoader(ClassLoader parentClassLoader, File jarFile) throws FileNotFoundException, IOException {
        super(parentClassLoader);
        this.jarFile = jarFile;
        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));
        JarEntry entry = jarInputStream.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().endsWith(".jar")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)jarInputStream, (OutputStream)byteArrayOutputStream);
                this.loadSubJars(byteArrayOutputStream.toByteArray());
            } else {
                this.addDataToMap(jarInputStream, entry);
            }
            entry = jarInputStream.getNextJarEntry();
        }
        jarInputStream.close();
    }

    private void addDataToMap(JarInputStream jarInputStream, JarEntry entry) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream);
        IOUtils.copy((InputStream)jarInputStream, (OutputStream)deflaterOutputStream);
        deflaterOutputStream.finish();
        this.map.put(entry.getName(), byteArrayOutputStream.toByteArray());
    }

    private void loadSubJars(byte[] byteArray) {
        try {
            JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(byteArray));
            JarEntry entry = jarInputStream.getNextJarEntry();
            while (entry != null) {
                this.addDataToMap(jarInputStream, entry);
                entry = jarInputStream.getNextJarEntry();
            }
            jarInputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @Override
    public URL findResource(final String name) {
        if (this.map.containsKey(name)) {
            try {
                return new URL(new URL("jar:" + this.jarFile.toURI().toURL() + "!/" + name), name, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return new InflaterInputStream(new ByteArrayInputStream((byte[])MemoryJarClassLoader.this.map.get(name)));
                            }
                        };
                    }
                });
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String fileName = name.replace(".", "/") + ".class";
        if (this.loadedClasses.containsKey(fileName)) {
            return this.loadedClasses.get(fileName);
        }
        if (this.map.containsKey(fileName)) {
            String packageName;
            Package classPackage;
            int packageIndex;
            byte[] bs = this.map.get(fileName);
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(bs));
            ByteArrayOutputStream uncompressed = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)inflaterInputStream, (OutputStream)uncompressed);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
            byte[] byteArray = uncompressed.toByteArray();
            Class<?> defineClass = this.defineClass(name, byteArray, 0, byteArray.length);
            this.loadedClasses.put(fileName, defineClass);
            if (defineClass != null && (packageIndex = name.lastIndexOf(46)) != -1 && (classPackage = this.getPackage(packageName = name.substring(0, packageIndex))) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            this.map.remove(fileName);
            return defineClass;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public void dumpStructure(int indent) {
        System.out.print(StringUtils.gen((String)"  ", (int)indent));
        System.out.println("MemoryClassLoader");
    }
}

