/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.plugins.deserializers.DatabaseInterface;
import org.bimserver.shared.AbstractByteBufferVirtualObject;
import org.bimserver.shared.ByteBufferList;
import org.bimserver.shared.ByteBufferWrappedVirtualObject;
import org.bimserver.shared.ListCapableVirtualObject;
import org.bimserver.shared.QueryContext;
import org.bimserver.shared.VirtualObject;
import org.bimserver.shared.WrappedVirtualObject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufferVirtualObject
extends AbstractByteBufferVirtualObject
implements ListCapableVirtualObject,
VirtualObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualObject.class);
    private EClass eClass;
    private long oid;
    private QueryContext reusable;
    private int currentListStart = -1;
    private int currentListSize;
    private int featureCounter = 0;

    public ByteBufferVirtualObject(QueryContext reusable, EClass eClass, int capacity) {
        super(capacity);
        this.reusable = reusable;
        this.eClass = eClass;
        this.oid = reusable.getDatabaseInterface().newOid(eClass);
        int unsettedLength = reusable.getPackageMetaData().getUnsettedLength(eClass);
        this.buffer.put(new byte[unsettedLength]);
    }

    private boolean useUnsetBit(EStructuralFeature feature) {
        if (feature.isUnsettable()) {
            return true;
        }
        if (feature.isMany()) {
            return true;
        }
        return feature.getDefaultValue() == null || feature.getDefaultValue() != null && feature.getDefaultValue() == null;
    }

    public void eUnset(EStructuralFeature feature) throws BimserverDatabaseException {
        if (this.useUnsetBit(feature)) {
            int pos = this.featureCounter / 8;
            byte b = this.buffer.get(pos);
            b = (byte)(b | 1 << this.featureCounter % 8);
            this.buffer.put(pos, b);
        } else if (feature instanceof EReference) {
            if (feature.isMany()) {
                this.ensureCapacity(this.buffer.position(), 4);
                this.buffer.putInt(0);
            } else {
                this.ensureCapacity(this.buffer.position(), 2);
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.buffer.putShort((short)-1);
                this.buffer.order(ByteOrder.BIG_ENDIAN);
            }
        } else if (feature.getEType() instanceof EEnum) {
            this.writeEnum(feature, null);
        } else {
            this.writePrimitiveValue(feature, null);
        }
        this.incrementFeatureCounter(feature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAttribute(EStructuralFeature feature, Object value) throws BimserverDatabaseException {
        if (feature.isMany()) {
            throw new UnsupportedOperationException("Feature isMany not supported by setAttribute");
        }
        if (feature.getEType() instanceof EEnum) {
            this.writeEnum(feature, value);
        } else if (feature.getEType() instanceof EClass) {
            if (value == null) {
                this.ensureCapacity(this.buffer.position(), 2);
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
                this.buffer.putShort((short)-1);
                this.buffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                if (!(value instanceof WrappedVirtualObject)) throw new UnsupportedOperationException("??");
                ByteBuffer otherBuffer = ((WrappedVirtualObject)value).write();
                this.ensureCapacity(this.buffer.position(), otherBuffer.position());
                this.buffer.put(otherBuffer.array(), 0, otherBuffer.position());
            }
        } else if (feature.getEType() instanceof EDataType) {
            this.writePrimitiveValue(feature, value);
        }
        this.incrementFeatureCounter(feature);
    }

    private void incrementFeatureCounter(EStructuralFeature feature) {
        ++this.featureCounter;
    }

    private void writeEnum(EStructuralFeature feature, Object value) {
        if (value == null) {
            this.ensureCapacity(this.buffer.position(), 4);
            this.buffer.putInt(-1);
        } else {
            EEnum eEnum = (EEnum)feature.getEType();
            EEnumLiteral eEnumLiteral = eEnum.getEEnumLiteralByLiteral(((Enum)value).toString());
            this.ensureCapacity(this.buffer.position(), 4);
            if (eEnumLiteral != null) {
                this.buffer.putInt(eEnumLiteral.getValue());
            } else {
                LOGGER.error(((Enum)value).toString() + " not found");
                this.buffer.putInt(-1);
            }
        }
    }

    public Object eGet(EStructuralFeature feature) {
        throw new UnsupportedOperationException();
    }

    public EClass eClass() {
        return this.eClass;
    }

    public long getOid() {
        return this.oid;
    }

    public ByteBuffer write() throws BimserverDatabaseException {
        EClass eClass = this.getDatabaseInterface().getEClassForOid(this.getOid());
        if (!eClass.isSuperTypeOf(this.eClass())) {
            throw new BimserverDatabaseException("Object with oid " + this.getOid() + " is a " + this.eClass().getName() + " but it's cid-part says it's a " + eClass.getName());
        }
        int nrFeatures = this.getPackageMetaData().getNrDatabaseFeatures(eClass);
        if (this.featureCounter > nrFeatures) {
            throw new BimserverDatabaseException("Too many features seem to have been set on " + this.eClass.getName() + " " + this.featureCounter + " / " + nrFeatures);
        }
        if (this.featureCounter < nrFeatures) {
            throw new BimserverDatabaseException("Not all features seem to have been set on " + this.eClass.getName() + " " + this.featureCounter + " / " + nrFeatures);
        }
        return this.buffer;
    }

    private PackageMetaData getPackageMetaData() {
        return this.reusable.getPackageMetaData();
    }

    private DatabaseInterface getDatabaseInterface() {
        return this.reusable.getDatabaseInterface();
    }

    public int getPid() {
        return this.reusable.getPid();
    }

    public int getRid() {
        return this.reusable.getRid();
    }

    public void setOid(long oid) {
        this.oid = oid;
    }

    public void setListItem(EStructuralFeature feature, int index, Object value) throws BimserverDatabaseException {
        if (this.currentListStart == -1) {
            throw new BimserverDatabaseException("Not currently writing a list");
        }
        if (index + 1 > this.currentListSize) {
            this.currentListSize = index + 1;
        }
        if (value instanceof ByteBufferWrappedVirtualObject) {
            ByteBuffer otherBuffer = ((ByteBufferWrappedVirtualObject)((Object)value)).write();
            this.ensureCapacity(this.buffer.position(), otherBuffer.position());
            this.buffer.put(otherBuffer.array(), 0, otherBuffer.position());
        } else if (value instanceof ByteBufferList) {
            ByteBuffer otherBuffer = ((ByteBufferList)((Object)value)).write();
            this.ensureCapacity(this.buffer.position(), otherBuffer.position());
            this.buffer.put(otherBuffer.array(), 0, otherBuffer.position());
        } else {
            this.writePrimitiveValue(feature, value);
        }
    }

    public void setListItemReference(EStructuralFeature structuralFeature, int index, EClass referenceEClass, Long referencedOid, int bufferPosition) throws BimserverDatabaseException {
        int pos;
        if (bufferPosition == -1) {
            if (this.currentListStart == -1) {
                throw new BimserverDatabaseException("Not currently writing a list");
            }
            if (index + 1 > this.currentListSize) {
                this.currentListSize = index + 1;
            }
            pos = this.buffer.position();
        } else {
            pos = bufferPosition;
        }
        this.ensureCapacity(pos, 8);
        if (referencedOid < 0L) {
            throw new BimserverDatabaseException("Writing a reference with oid " + referencedOid + ", this is not supposed to happen, referenced: " + referencedOid + " " + referencedOid + " from " + this.getOid() + " " + (Object)((Object)this));
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(pos, referencedOid);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        if (bufferPosition == -1) {
            this.buffer.position(this.buffer.position() + 8);
        }
    }

    public void save() throws BimserverDatabaseException {
        this.getDatabaseInterface().save((VirtualObject)this);
    }

    public int reserveSpaceForReference(EStructuralFeature feature) {
        int pos = this.buffer.position();
        this.ensureCapacity(pos, 8);
        this.buffer.putLong(-1L);
        this.incrementFeatureCounter(feature);
        return pos;
    }

    public int reserveSpaceForListReference() throws BimserverDatabaseException {
        if (this.currentListStart == -1) {
            throw new BimserverDatabaseException("Not currently writing a list");
        }
        ++this.currentListSize;
        int position = this.buffer.position();
        this.ensureCapacity(position, 8);
        this.buffer.putLong(-1L);
        return position;
    }

    public void startList(EStructuralFeature feature) {
        this.ensureCapacity(this.buffer.position(), 4);
        this.buffer.putInt(0);
        this.currentListStart = this.buffer.position();
        this.currentListSize = 0;
        this.incrementFeatureCounter(feature);
    }

    public void endList() {
        this.buffer.putInt(this.currentListStart - 4, this.currentListSize);
        this.currentListStart = -1;
    }

    public void setReference(EStructuralFeature feature, long referenceOid, int bufferPosition) throws BimserverDatabaseException {
        if (bufferPosition == -1) {
            this.incrementFeatureCounter(feature);
        }
        int pos = bufferPosition == -1 ? this.buffer.position() : bufferPosition;
        this.ensureCapacity(pos, 8);
        if (referenceOid < 0L) {
            throw new BimserverDatabaseException("Writing a reference with oid " + referenceOid + ", this is not supposed to happen, referenced: " + referenceOid + " " + referenceOid + " from " + this.getOid() + " " + (Object)((Object)this));
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(pos, referenceOid);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        if (bufferPosition == -1) {
            this.buffer.position(this.buffer.position() + 8);
        }
    }

    public boolean useFeatureForSerialization(EStructuralFeature feature) {
        throw new UnsupportedOperationException();
    }

    public Object get(String name) {
        throw new UnsupportedOperationException();
    }

    public void set(String name, Object value) throws BimserverDatabaseException {
        this.setAttribute(this.eClass.getEStructuralFeature(name), value);
    }

    public boolean has(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean useFeatureForSerialization(EStructuralFeature feature, int index) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "ByteBufferVirtualObject/" + this.eClass.getName();
    }
}

