/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.bimserver.shared.meta.SourceCodeFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CodeFetcher
implements SourceCodeFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeFetcher.class);

    CodeFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Class<?> clazz) {
        URL url = clazz.getResource(clazz.getSimpleName() + ".java");
        if (url == null) {
            try {
                url = new File("../PluginBase/src/" + clazz.getName().replace(".", "/") + ".java").toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        if (url != null) {
            String string;
            InputStream inputStream = url.openStream();
            if (inputStream == null) {
                return null;
            }
            try {
                StringWriter out = new StringWriter();
                IOUtils.copy((InputStream)inputStream, (Writer)out);
                string = out.toString();
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
            inputStream.close();
            return string;
        }
        return null;
    }
}

