/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IfcDoc {
    private final Map<String, Set<String>> domainToClasses = new HashMap<String, Set<String>>();
    private final Map<String, String> classesToDomain = new HashMap<String, String>();

    public IfcDoc(File dir) {
        for (File f : dir.listFiles()) {
            if (!f.isDirectory()) continue;
            for (File x : f.listFiles()) {
                if (!x.isDirectory() || !x.getName().equals("lexical")) continue;
                for (File y : x.listFiles()) {
                    if (!y.getName().endsWith(".htm")) continue;
                    String domain = f.getName();
                    String classname = y.getName().substring(0, y.getName().length() - 4);
                    if (!this.domainToClasses.containsKey(domain)) {
                        this.domainToClasses.put(domain, new HashSet());
                    }
                    this.domainToClasses.get(domain).add(classname);
                    this.classesToDomain.put(classname, domain);
                }
            }
        }
    }

    public String getDomain(String name) {
        return this.classesToDomain.get(name.toLowerCase());
    }

    public Set<String> getClassNames(String domain) {
        return this.domainToClasses.get(domain);
    }

    public Set<String> getDomains() {
        return this.domainToClasses.keySet();
    }
}

