/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils;

import java.nio.ByteBuffer;

public class GrowingByteBuffer {
    private ByteBuffer byteBuffer;

    public GrowingByteBuffer(int initialCapacity) {
        this.byteBuffer = ByteBuffer.allocate(initialCapacity);
    }

    public int usedSize() {
        return this.byteBuffer.position();
    }

    public GrowingByteBuffer(ByteBuffer buffer) {
        this.byteBuffer = ByteBuffer.wrap(buffer.array());
        buffer.position(0);
    }

    public void put(ByteBuffer buffer) {
        this.ensureExtraCapacity(buffer.limit());
        this.byteBuffer.put(buffer);
    }

    public void putInt(int value) {
        this.ensureExtraCapacity(4);
        this.byteBuffer.putInt(value);
    }

    public void ensureExtraCapacity(int nrExtraBytes) {
        if (this.byteBuffer.capacity() <= this.byteBuffer.position() + nrExtraBytes) {
            ByteBuffer oldBuffer = this.byteBuffer;
            this.byteBuffer = ByteBuffer.allocate(Math.max(oldBuffer.position() * 2, this.byteBuffer.position() + nrExtraBytes));
            int oldPos = oldBuffer.position();
            oldBuffer.position(0);
            this.byteBuffer.put(oldBuffer.array(), 0, oldPos);
            this.byteBuffer.position(oldPos);
        }
    }

    public int position() {
        return this.byteBuffer.position();
    }

    public void putDouble(Double value) {
        this.ensureExtraCapacity(8);
        this.byteBuffer.putDouble(value);
    }

    public void putFloat(Float value) {
        this.ensureExtraCapacity(4);
        this.byteBuffer.putFloat(value.floatValue());
    }

    public void putLong(Long value) {
        this.ensureExtraCapacity(8);
        this.byteBuffer.putLong(value);
    }

    public void put(byte[] bs) {
        this.ensureExtraCapacity(bs.length);
        this.byteBuffer.put(bs);
    }

    public void put(byte b) {
        this.ensureExtraCapacity(1);
        this.byteBuffer.put(b);
    }

    public void putShort(short value) {
        this.ensureExtraCapacity(2);
        this.byteBuffer.putShort(value);
    }

    public byte[] array() {
        return this.byteBuffer.array();
    }

    public int capacity() {
        return this.byteBuffer.capacity();
    }

    public void position(int i) {
        this.byteBuffer.position(i);
    }

    public void put(byte[] b, int off, int len) {
        this.ensureExtraCapacity(len);
        this.byteBuffer.put(b, off, len);
    }

    public void putNoCheck(byte[] b, int off, int len) {
        this.byteBuffer.put(b, off, len);
    }

    public void putNoCheck(byte b) {
        this.byteBuffer.put(b);
    }
}

