/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.utils.math;

public class Vector {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;

    public static float dot(float[] u, float[] v) {
        return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
    }

    public static double dot(double[] u, double[] v) {
        return u[0] * v[0] + u[1] * v[1] + u[2] * v[2];
    }

    public static float[] minus(float[] u, float[] v) {
        return new float[]{u[0] - v[0], u[1] - v[1], u[2] - v[2]};
    }

    public static double[] minus(double[] u, double[] v) {
        return new double[]{u[0] - v[0], u[1] - v[1], u[2] - v[2]};
    }

    public static float[] addition(float[] u, float[] v) {
        return new float[]{u[0] + v[0], u[1] + v[1], u[2] + v[2]};
    }

    public static float[] scalarProduct(float r, float[] u) {
        return new float[]{u[0] * r, u[1] * r, u[2] * r};
    }

    public static float[] crossProduct(float[] u, float[] v) {
        return new float[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
    }

    public static double[] crossProduct(double[] u, double[] v) {
        return new double[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
    }

    public static float length(float[] u) {
        return (float)Math.abs(Math.sqrt(u[0] * u[0] + u[1] * u[1] + u[2] * u[2]));
    }

    public static void normalize(float[] rayDir) {
        float l = Vector.length(rayDir);
        rayDir[0] = rayDir[0] / l;
        rayDir[1] = rayDir[1] / l;
        rayDir[2] = rayDir[2] / l;
    }
}

