/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.validationreport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.bimserver.validationreport.Item;
import org.bimserver.validationreport.Type;

public class Line
extends Item {
    private String fieldOrClass;
    private String value;
    private String shouldBe;
    private Type type;
    private long oid = -1L;

    public Line(Type type, Long oid, String fieldOrClass, String value, String shouldBe) {
        this.type = type;
        this.oid = oid == null ? -1L : oid;
        this.fieldOrClass = fieldOrClass;
        this.value = value;
        this.shouldBe = shouldBe;
    }

    @Override
    public void toHtml(StringBuilder sb) {
        sb.append("<tr>");
        sb.append("<td>");
        sb.append(this.fieldOrClass);
        sb.append("</td>");
        sb.append("<td class=\"" + this.type.name().toLowerCase() + "\">");
        sb.append(this.value);
        sb.append("</td>");
        sb.append("<td>");
        sb.append(this.shouldBe);
        sb.append("</td>");
        sb.append("</tr>\n");
    }

    @Override
    public ObjectNode toJson(ObjectMapper OBJECT_MAPPER) {
        ObjectNode result = OBJECT_MAPPER.createObjectNode();
        result.put("type", "line");
        result.put("status", this.type.name());
        result.put("oid", this.oid);
        result.put("identification", this.fieldOrClass);
        result.put("value", this.value);
        result.put("shouldBe", this.shouldBe);
        return result;
    }

    public long getOid() {
        return this.oid;
    }

    @Override
    public Type getType() {
        return this.type;
    }
}

