/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.jodatime;

import com.google.ical.compat.jodatime.LocalDateIterable;
import com.google.ical.compat.jodatime.LocalDateIterator;
import com.google.ical.compat.jodatime.TimeZoneConverter;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import java.text.ParseException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class LocalDateIteratorFactory {
    public static LocalDateIterator createLocalDateIterator(String string, LocalDate localDate, DateTimeZone dateTimeZone, boolean bl) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(string, LocalDateIteratorFactory.localDateToDateValue(localDate), TimeZoneConverter.toTimeZone(dateTimeZone), bl));
    }

    public static LocalDateIterator createLocalDateIterator(String string, LocalDate localDate, boolean bl) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterator(string, localDate, DateTimeZone.UTC, bl);
    }

    public static LocalDateIterable createLocalDateIterable(String string, LocalDate localDate, DateTimeZone dateTimeZone, boolean bl) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(string, LocalDateIteratorFactory.localDateToDateValue(localDate), TimeZoneConverter.toTimeZone(dateTimeZone), bl));
    }

    public static LocalDateIterable createLocalDateIterable(String string, LocalDate localDate, boolean bl) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterable(string, localDate, DateTimeZone.UTC, bl);
    }

    public static LocalDateIterator createLocalDateIterator(RecurrenceIterator recurrenceIterator) {
        return new RecurrenceIteratorWrapper(recurrenceIterator);
    }

    static LocalDate dateValueToLocalDate(DateValue dateValue) {
        return new LocalDate(dateValue.year(), dateValue.month(), dateValue.day());
    }

    static DateValue localDateToDateValue(LocalDate localDate) {
        return new DateValueImpl(localDate.getYear(), localDate.getMonthOfYear(), localDate.getDayOfMonth());
    }

    private LocalDateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements LocalDateIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator recurrenceIterator) {
            this.it = recurrenceIterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public LocalDate next() {
            return LocalDateIteratorFactory.dateValueToLocalDate(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(LocalDate localDate) {
            this.it.advanceTo(LocalDateIteratorFactory.localDateToDateValue(localDate));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements LocalDateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable recurrenceIterable) {
            this.it = recurrenceIterable;
        }

        @Override
        public LocalDateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

