/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.DateValueComparison;
import com.google.ical.iter.HeapElement;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.values.DateValue;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

final class CompoundIteratorImpl
implements RecurrenceIterator {
    private PriorityQueue<HeapElement> queue;
    private HeapElement pending;
    private int nInclusionsRemaining;

    CompoundIteratorImpl(Collection<RecurrenceIterator> collection, Collection<RecurrenceIterator> collection2) {
        HeapElement heapElement;
        this.queue = new PriorityQueue<HeapElement>(collection.size() + collection2.size(), HeapElement.CMP);
        for (RecurrenceIterator recurrenceIterator : collection) {
            heapElement = new HeapElement(true, recurrenceIterator);
            if (!heapElement.shift()) continue;
            this.queue.add(heapElement);
            ++this.nInclusionsRemaining;
        }
        for (RecurrenceIterator recurrenceIterator : collection2) {
            heapElement = new HeapElement(false, recurrenceIterator);
            if (!heapElement.shift()) continue;
            this.queue.add(heapElement);
        }
    }

    @Override
    public boolean hasNext() {
        this.requirePending();
        return null != this.pending;
    }

    @Override
    public DateValue next() {
        this.requirePending();
        if (null == this.pending) {
            throw new NoSuchElementException();
        }
        DateValue dateValue = this.pending.head();
        this.reattach(this.pending);
        this.pending = null;
        return dateValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue dateValue) {
        long l = DateValueComparison.comparable(dateValue);
        if (null != this.pending) {
            if (this.pending.comparable() >= l) {
                return;
            }
            this.pending.advanceTo(dateValue);
            this.reattach(this.pending);
            this.pending = null;
        }
        while (0 != this.nInclusionsRemaining && !this.queue.isEmpty() && this.queue.peek().comparable() < l) {
            HeapElement heapElement = this.queue.poll();
            heapElement.advanceTo(dateValue);
            this.reattach(heapElement);
        }
    }

    private void reattach(HeapElement heapElement) {
        if (heapElement.shift()) {
            this.queue.add(heapElement);
        } else if (heapElement.inclusion && 0 == --this.nInclusionsRemaining) {
            this.queue.clear();
        }
    }

    private void requirePending() {
        if (null != this.pending) {
            return;
        }
        long l = Long.MIN_VALUE;
        while (0 != this.nInclusionsRemaining && !this.queue.isEmpty()) {
            boolean bl;
            HeapElement heapElement = null;
            do {
                HeapElement heapElement2 = this.queue.poll();
                if (heapElement2.inclusion) {
                    if (l != heapElement2.comparable()) {
                        heapElement = heapElement2;
                        break;
                    }
                } else {
                    l = heapElement2.comparable();
                }
                this.reattach(heapElement2);
                if (0 != this.nInclusionsRemaining) continue;
                return;
            } while (!this.queue.isEmpty());
            if (heapElement == null) {
                return;
            }
            long l2 = heapElement.comparable();
            boolean bl2 = bl = l == l2;
            while (!this.queue.isEmpty() && this.queue.peek().comparable() == l2) {
                HeapElement heapElement3 = this.queue.poll();
                bl |= !heapElement3.inclusion;
                this.reattach(heapElement3);
                if (0 != this.nInclusionsRemaining) continue;
                return;
            }
            if (!bl) {
                this.pending = heapElement;
                return;
            }
            this.reattach(heapElement);
        }
    }
}

