/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.Predicate;
import com.google.ical.util.Predicates;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.TimeValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;

class Filters {
    private static final int LOW_24_BITS = 0xFFFFFF;
    private static final long LOW_60_BITS = 0xFFFFFFFFFFFFFFFL;

    static Predicate<DateValue> byDayFilter(final WeekdayNum[] weekdayNumArray, final boolean bl, final Weekday weekday) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue dateValue) {
                int n;
                Weekday weekday3;
                int n2;
                Weekday weekday2 = Weekday.valueOf(dateValue);
                if (bl) {
                    n2 = TimeUtils.yearLength(dateValue.year());
                    weekday3 = Weekday.firstDayOfWeekInMonth(dateValue.year(), 1);
                    n = TimeUtils.dayOfYear(dateValue.year(), dateValue.month(), dateValue.day());
                } else {
                    n2 = TimeUtils.monthLength(dateValue.year(), dateValue.month());
                    weekday3 = Weekday.firstDayOfWeekInMonth(dateValue.year(), dateValue.month());
                    n = dateValue.day() - 1;
                }
                int n3 = weekday.javaDayNum <= weekday2.javaDayNum ? 1 + n / 7 : n / 7;
                int n4 = weekdayNumArray.length;
                while (--n4 >= 0) {
                    WeekdayNum weekdayNum = weekdayNumArray[n4];
                    if (weekdayNum.wday != weekday2) continue;
                    int n5 = weekdayNum.num;
                    if (0 == n5) {
                        return true;
                    }
                    if (n5 < 0) {
                        n5 = Util.invertWeekdayNum(weekdayNum, weekday3, n2);
                    }
                    if (n3 != n5) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> byMonthDayFilter(final int[] nArray) {
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue dateValue) {
                int n = TimeUtils.monthLength(dateValue.year(), dateValue.month());
                int n2 = nArray.length;
                while (--n2 >= 0) {
                    int n3 = nArray[n2];
                    if (n3 < 0) {
                        n3 += n + 1;
                    }
                    if (n3 != dateValue.day()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static Predicate<DateValue> weekIntervalFilter(final int n, final Weekday weekday, final DateValue dateValue) {
        return new Predicate<DateValue>(){
            DateValue wkStart;
            {
                DTBuilder dTBuilder = new DTBuilder(dateValue);
                dTBuilder.day -= (7 + Weekday.valueOf((DateValue)dateValue).javaDayNum - weekday.javaDayNum) % 7;
                this.wkStart = dTBuilder.toDate();
            }

            @Override
            public boolean apply(DateValue dateValue2) {
                int n3;
                int n2 = TimeUtils.daysBetween(dateValue2, this.wkStart);
                if (n2 < 0) {
                    n2 += n * 7 * (1 + n2 / (-7 * n));
                }
                return 0 == (n3 = n2 / 7 % n);
            }
        };
    }

    static Predicate<DateValue> byHourFilter(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            n |= 1 << n2;
        }
        if ((n & 0xFFFFFF) == 0xFFFFFF) {
            return Predicates.alwaysTrue();
        }
        final int n3 = n;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue dateValue) {
                if (!(dateValue instanceof TimeValue)) {
                    return false;
                }
                TimeValue timeValue = (TimeValue)((Object)dateValue);
                return (n3 & 1 << timeValue.hour()) != 0;
            }
        };
    }

    static Predicate<DateValue> byMinuteFilter(int[] nArray) {
        long l = 0L;
        for (int n : nArray) {
            l |= 1L << n;
        }
        if ((l & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long l2 = l;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue dateValue) {
                if (!(dateValue instanceof TimeValue)) {
                    return false;
                }
                TimeValue timeValue = (TimeValue)((Object)dateValue);
                return (l2 & 1L << timeValue.minute()) != 0L;
            }
        };
    }

    static Predicate<DateValue> bySecondFilter(int[] nArray) {
        long l = 0L;
        for (int n : nArray) {
            l |= 1L << n;
        }
        if ((l & 0xFFFFFFFFFFFFFFFL) == 0xFFFFFFFFFFFFFFFL) {
            return Predicates.alwaysTrue();
        }
        final long l2 = l;
        return new Predicate<DateValue>(){

            @Override
            public boolean apply(DateValue dateValue) {
                if (!(dateValue instanceof TimeValue)) {
                    return false;
                }
                TimeValue timeValue = (TimeValue)((Object)dateValue);
                return (l2 & 1L << timeValue.second()) != 0L;
            }
        };
    }

    private Filters() {
    }
}

