/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.DateValueComparison;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.values.DateValue;
import java.util.Comparator;

final class HeapElement {
    final boolean inclusion;
    private long comparable;
    private DateValue head;
    private RecurrenceIterator it;
    static Comparator<HeapElement> CMP = new Comparator<HeapElement>(){

        @Override
        public int compare(HeapElement heapElement, HeapElement heapElement2) {
            long l;
            long l2 = heapElement.comparable();
            return l2 < (l = heapElement2.comparable()) ? -1 : (l2 == l ? 0 : 1);
        }
    };

    HeapElement(boolean bl, RecurrenceIterator recurrenceIterator) {
        this.inclusion = bl;
        this.it = recurrenceIterator;
    }

    DateValue head() {
        return this.head;
    }

    long comparable() {
        return this.comparable;
    }

    boolean shift() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.head = this.it.next();
        this.comparable = DateValueComparison.comparable(this.head);
        return true;
    }

    void advanceTo(DateValue dateValue) {
        this.it.advanceTo(dateValue);
    }

    public String toString() {
        return "[" + this.head.toString() + (this.inclusion ? ", inclusion]" : ", exclusion]");
    }
}

