/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.DateValueComparison;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.values.DateValue;

final class RDateIteratorImpl
implements RecurrenceIterator {
    private int i;
    private DateValue[] datesUtc;

    RDateIteratorImpl(DateValue[] dateValueArray) {
        this.datesUtc = (DateValue[])dateValueArray.clone();
        assert (RDateIteratorImpl.increasing((Comparable[])dateValueArray));
    }

    @Override
    public boolean hasNext() {
        return this.i < this.datesUtc.length;
    }

    @Override
    public DateValue next() {
        return this.datesUtc[this.i++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue dateValue) {
        long l = DateValueComparison.comparable(dateValue);
        while (this.i < this.datesUtc.length && l > DateValueComparison.comparable(this.datesUtc[this.i])) {
            ++this.i;
        }
    }

    private static <C extends Comparable<C>> boolean increasing(C[] CArray) {
        int n = CArray.length;
        while (--n >= 1) {
            if (CArray[n - 1].compareTo(CArray[n]) <= 0) continue;
            return false;
        }
        return true;
    }
}

