/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.IntSet;
import com.google.ical.util.DTBuilder;
import com.google.ical.values.DateValue;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;

class Util {
    static void rollToNextWeekStart(DTBuilder dTBuilder, Weekday weekday) {
        DateValue dateValue = dTBuilder.toDate();
        dTBuilder.day += (7 - (7 + (Weekday.valueOf((DateValue)dateValue).javaDayNum - weekday.javaDayNum)) % 7) % 7;
        dTBuilder.normalize();
    }

    static DateValue nextWeekStart(DateValue dateValue, Weekday weekday) {
        DTBuilder dTBuilder = new DTBuilder(dateValue);
        dTBuilder.day += (7 - (7 + (Weekday.valueOf((DateValue)dateValue).javaDayNum - weekday.javaDayNum)) % 7) % 7;
        return dTBuilder.toDate();
    }

    static int[] uniquify(int[] nArray) {
        return Util.uniquify(nArray, 0, nArray.length);
    }

    static int[] uniquify(int[] nArray, int n, int n2) {
        IntSet intSet = new IntSet();
        int n3 = n2;
        while (--n3 >= n) {
            intSet.add(nArray[n3]);
        }
        return intSet.toIntArray();
    }

    static int dayNumToDate(Weekday weekday, int n, int n2, Weekday weekday2, int n3, int n4) {
        int n5;
        int n6 = 1 + (7 + weekday2.javaDayNum - weekday.javaDayNum) % 7;
        if (n2 > 0) {
            n5 = (n2 - 1) * 7 + n6 - n3;
        } else {
            int n7 = n6 + 378;
            n7 -= 7 * ((n7 - n + 6) / 7);
            n5 = n7 + 7 * (n2 + 1) - n3;
        }
        if (n5 <= 0 || n5 > n4) {
            return 0;
        }
        return n5;
    }

    static int invertWeekdayNum(WeekdayNum weekdayNum, Weekday weekday, int n) {
        assert (weekdayNum.num < 0);
        return Util.countInPeriod(weekdayNum.wday, weekday, n) + weekdayNum.num + 1;
    }

    static int countInPeriod(Weekday weekday, Weekday weekday2, int n) {
        if (weekday.javaDayNum >= weekday2.javaDayNum) {
            return 1 + (n - (weekday.javaDayNum - weekday2.javaDayNum) - 1) / 7;
        }
        return 1 + (n - (7 - (weekday2.javaDayNum - weekday.javaDayNum)) - 1) / 7;
    }

    private Util() {
    }
}

