/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;

public class DTBuilder {
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;

    public DTBuilder(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
    }

    public DTBuilder(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
    }

    public DTBuilder(DateValue dateValue) {
        this.year = dateValue.year();
        this.month = dateValue.month();
        this.day = dateValue.day();
        if (dateValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue);
            this.hour = timeValue.hour();
            this.minute = timeValue.minute();
            this.second = timeValue.second();
        }
    }

    public DateTimeValue toDateTime() {
        this.normalize();
        return new DateTimeValueImpl(this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    public DateValue toDate() {
        this.normalize();
        return new DateValueImpl(this.year, this.month, this.day);
    }

    public int compareTo(DateValue dateValue) {
        long l;
        long l2 = (((long)dateValue.year() << 4) + (long)dateValue.month() << 5) + (long)dateValue.day();
        long l3 = (((long)this.year << 4) + (long)this.month << 5) + (long)this.day;
        if (dateValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue);
            l2 = (((l2 << 5) + (long)timeValue.hour() << 6) + (long)timeValue.minute() << 6) + (long)timeValue.second();
            l3 = (((l3 << 5) + (long)this.hour << 6) + (long)this.minute << 6) + (long)this.second;
        }
        return (l = l3 - l2) < 0L ? -1 : (l == 0L ? 0 : 1);
    }

    public void normalize() {
        this.normalizeTime();
        this.normalizeDate();
    }

    public String toString() {
        return this.year + "-" + this.month + "-" + this.day + " " + this.hour + ":" + this.minute + ":" + this.second;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DTBuilder)) {
            return false;
        }
        DTBuilder dTBuilder = (DTBuilder)object;
        return this.year == dTBuilder.year && this.month == dTBuilder.month && this.day == dTBuilder.day && this.hour == dTBuilder.hour && this.minute == dTBuilder.minute && this.second == dTBuilder.second;
    }

    public int hashCode() {
        return (((((this.year << 4) + this.month << 5) + this.day << 5) + this.hour << 6) + this.minute << 6) + this.second;
    }

    private void normalizeTime() {
        int n = (this.second < 0 ? this.second - 59 : this.second) / 60;
        this.second -= n * 60;
        this.minute += n;
        int n2 = (this.minute < 0 ? this.minute - 59 : this.minute) / 60;
        this.minute -= n2 * 60;
        this.hour += n2;
        int n3 = (this.hour < 0 ? this.hour - 23 : this.hour) / 24;
        this.hour -= n3 * 24;
        this.day += n3;
    }

    private void normalizeDate() {
        int n;
        while (this.day <= 0) {
            n = TimeUtils.yearLength(this.month > 2 ? this.year : this.year - 1);
            this.day += n;
            --this.year;
        }
        if (this.month <= 0) {
            n = this.month / 12 - 1;
            this.year += n;
            this.month -= 12 * n;
        } else if (this.month > 12) {
            n = (this.month - 1) / 12;
            this.year += n;
            this.month -= 12 * n;
        }
        while (true) {
            if (this.month == 1 && this.day > (n = TimeUtils.yearLength(this.year))) {
                ++this.year;
                this.day -= n;
            }
            if (this.day <= (n = TimeUtils.monthLength(this.year, this.month))) break;
            this.day -= n;
            if (++this.month <= 12) continue;
            this.month -= 12;
            ++this.year;
        }
    }
}

