/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.DTBuilder;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static TimeZone ZULU = new SimpleTimeZone(0, "Etc/GMT");
    private static int[] MONTH_START_TO_DOY = new int[12];
    private static final long SECS_PER_DAY = 86400L;
    private static final TimeZone BOGUS_TIMEZONE;
    private static final Pattern UTC_TZID;

    public static TimeZone utcTimezone() {
        return ZULU;
    }

    private static long timetMillisFromEpochSecs(long l, TimeZone timeZone) {
        DateTimeValue dateTimeValue = TimeUtils.timeFromSecsSinceEpoch(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.clear();
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        gregorianCalendar.set(dateTimeValue.year(), dateTimeValue.month() - 1, dateTimeValue.day(), dateTimeValue.hour(), dateTimeValue.minute(), dateTimeValue.second());
        return gregorianCalendar.getTimeInMillis();
    }

    private static DateTimeValue convert(DateTimeValue dateTimeValue, TimeZone timeZone, int n) {
        if (timeZone == null || timeZone.hasSameRules(ZULU) || dateTimeValue.year() == 0) {
            return dateTimeValue;
        }
        long l = 0L;
        l = n > 0 ? TimeUtils.timetMillisFromEpochSecs(TimeUtils.secsSinceEpoch(dateTimeValue), ZULU) : TimeUtils.timetMillisFromEpochSecs(TimeUtils.secsSinceEpoch(dateTimeValue), timeZone);
        int n2 = timeZone.getOffset(l);
        int n3 = n2 < 0 ? -500 : 500;
        int n4 = (n2 + n3) / 1000;
        return TimeUtils.addSeconds(dateTimeValue, n * n4);
    }

    public static DateValue fromUtc(DateValue dateValue, TimeZone timeZone) {
        return dateValue instanceof DateTimeValue ? TimeUtils.fromUtc((DateTimeValue)dateValue, timeZone) : dateValue;
    }

    public static DateTimeValue fromUtc(DateTimeValue dateTimeValue, TimeZone timeZone) {
        return TimeUtils.convert(dateTimeValue, timeZone, 1);
    }

    public static DateValue toUtc(DateValue dateValue, TimeZone timeZone) {
        return dateValue instanceof TimeValue ? TimeUtils.convert((DateTimeValue)dateValue, timeZone, -1) : dateValue;
    }

    private static DateTimeValue addSeconds(DateTimeValue dateTimeValue, int n) {
        return new DTBuilder(dateTimeValue.year(), dateTimeValue.month(), dateTimeValue.day(), dateTimeValue.hour(), dateTimeValue.minute(), dateTimeValue.second() + n).toDateTime();
    }

    public static DateValue add(DateValue dateValue, DateValue dateValue2) {
        DTBuilder dTBuilder = new DTBuilder(dateValue);
        dTBuilder.year += dateValue2.year();
        dTBuilder.month += dateValue2.month();
        dTBuilder.day += dateValue2.day();
        if (dateValue2 instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue2);
            dTBuilder.hour += timeValue.hour();
            dTBuilder.minute += timeValue.minute();
            dTBuilder.second += timeValue.second();
            return dTBuilder.toDateTime();
        }
        if (dateValue instanceof TimeValue) {
            return dTBuilder.toDateTime();
        }
        return dTBuilder.toDate();
    }

    public static int daysBetween(DateValue dateValue, DateValue dateValue2) {
        return TimeUtils.fixedFromGregorian(dateValue) - TimeUtils.fixedFromGregorian(dateValue2);
    }

    public static int daysBetween(int n, int n2, int n3, int n4, int n5, int n6) {
        return TimeUtils.fixedFromGregorian(n, n2, n3) - TimeUtils.fixedFromGregorian(n4, n5, n6);
    }

    private static int fixedFromGregorian(DateValue dateValue) {
        return TimeUtils.fixedFromGregorian(dateValue.year(), dateValue.month(), dateValue.day());
    }

    public static int fixedFromGregorian(int n, int n2, int n3) {
        int n4 = n - 1;
        return 365 * n4 + n4 / 4 - n4 / 100 + n4 / 400 + (367 * n2 - 362) / 12 + (n2 <= 2 ? 0 : (TimeUtils.isLeapYear(n) ? -1 : -2)) + n3;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static int yearLength(int n) {
        return TimeUtils.isLeapYear(n) ? 366 : 365;
    }

    public static int monthLength(int n, int n2) {
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return TimeUtils.isLeapYear(n) ? 29 : 28;
            }
        }
        throw new AssertionError(n2);
    }

    public static int dayOfYear(int n, int n2, int n3) {
        int n4 = n2 > 2 && TimeUtils.isLeapYear(n) ? 1 : 0;
        return MONTH_START_TO_DOY[n2 - 1] + n4 + n3 - 1;
    }

    public static DateTimeValue timeFromSecsSinceEpoch(long l) {
        int n = (int)(l % 86400L);
        int n2 = (int)(l / 86400L);
        int n3 = (int)((long)(n2 + 10) * 400L / 146097L);
        int n4 = n2 >= TimeUtils.fixedFromGregorian(n3 + 1, 1, 1) ? n3 + 1 : n3;
        int n5 = TimeUtils.fixedFromGregorian(n4, 1, 1);
        int n6 = n2 - n5;
        int n7 = TimeUtils.fixedFromGregorian(n4, 3, 1);
        int n8 = n2 < n7 ? 0 : (TimeUtils.isLeapYear(n4) ? 1 : 2);
        int n9 = (12 * (n6 + n8) + 373) / 367;
        int n10 = TimeUtils.fixedFromGregorian(n4, n9, 1);
        int n11 = n2 - n10 + 1;
        int n12 = n % 60;
        int n13 = n / 60;
        int n14 = n13 % 60;
        int n15 = n13 / 60;
        if (n15 < 0 || n15 >= 24) {
            throw new AssertionError((Object)("Input was: " + l + "to make hour: " + n15));
        }
        DateTimeValueImpl dateTimeValueImpl = new DateTimeValueImpl(n4, n9, n11, n15, n14, n12);
        return dateTimeValueImpl;
    }

    public static long secsSinceEpoch(DateValue dateValue) {
        long l = (long)TimeUtils.fixedFromGregorian(dateValue) * 86400L;
        if (dateValue instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)((Object)dateValue);
            l += (long)(timeValue.second() + 60 * (timeValue.minute() + 60 * timeValue.hour()));
        }
        return l;
    }

    public static DateTimeValue dayStart(DateValue dateValue) {
        return new DateTimeValueImpl(dateValue.year(), dateValue.month(), dateValue.day(), 0, 0, 0);
    }

    public static DateValue toDateValue(DateValue dateValue) {
        return !(dateValue instanceof TimeValue) ? dateValue : new DateValueImpl(dateValue.year(), dateValue.month(), dateValue.day());
    }

    public static TimeZone timeZoneForName(String string) {
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if (timeZone.hasSameRules(BOGUS_TIMEZONE)) {
            Matcher matcher = UTC_TZID.matcher(string);
            if (matcher.matches()) {
                return TimeUtils.utcTimezone();
            }
            return null;
        }
        return timeZone;
    }

    private TimeUtils() {
    }

    static {
        assert (!TimeUtils.isLeapYear(1970));
        for (int i = 1; i < 12; ++i) {
            TimeUtils.MONTH_START_TO_DOY[i] = MONTH_START_TO_DOY[i - 1] + TimeUtils.monthLength(1970, i);
        }
        assert (365 == MONTH_START_TO_DOY[11] + TimeUtils.monthLength(1970, 12)) : "" + (MONTH_START_TO_DOY[11] + TimeUtils.monthLength(1970, 12));
        BOGUS_TIMEZONE = TimeZone.getTimeZone("noSuchTimeZone");
        UTC_TZID = Pattern.compile("^GMT([+-]0(:00)?)?$|UTC|Zulu|Etc\\/GMT|Greenwich.*", 2);
    }
}

