/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.IcalObject;
import com.google.ical.values.IcalParseUtil;
import com.google.ical.values.IcalSchema;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractIcalObject
implements IcalObject {
    private static final Pattern CONTENT_LINE_RE = Pattern.compile("^((?:[^:;\"]|\"[^\"]*\")+)(;(?:[^:\"]|\"[^\"]*\")+)?:(.*)$");
    private static final Pattern PARAM_RE = Pattern.compile("^;([^=]+)=(?:\"([^\"]*)\"|([^\";:]*))");
    static final Pattern ICAL_SPECIALS = Pattern.compile("[:;]");
    private String name;
    private Map<String, String> extParams = null;

    AbstractIcalObject() {
    }

    protected void parse(String string, IcalSchema icalSchema) throws ParseException {
        Object object = IcalParseUtil.unfoldIcal(string);
        Object object2 = CONTENT_LINE_RE.matcher((CharSequence)object);
        if (!((Matcher)object2).matches()) {
            icalSchema.badContent(string);
        }
        this.setName(((Matcher)object2).group(1).toUpperCase());
        String string2 = ((Matcher)object2).group(2);
        if (null == string2) {
            string2 = "";
        }
        String string3 = ((Matcher)object2).group(3);
        object = new HashMap();
        object2 = string2;
        while (!"".equals(object2)) {
            Matcher matcher = PARAM_RE.matcher((CharSequence)object2);
            if (!matcher.find()) {
                icalSchema.badPart((String)object2, null);
            }
            object2 = ((String)object2).substring(matcher.end(0));
            String string4 = matcher.group(1).toUpperCase();
            String string5 = matcher.group(2);
            if (null == string5) {
                string5 = matcher.group(3);
            }
            if (object.containsKey(string4)) {
                icalSchema.dupePart(string4);
            }
            object.put(string4, string5);
        }
        icalSchema.applyObjectSchema(this.name, (Map<String, String>)object, string3, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Map<String, String> getExtParams() {
        if (null == this.extParams) {
            this.extParams = new LinkedHashMap<String, String>();
        }
        return this.extParams;
    }

    public boolean hasExtParams() {
        return null != this.extParams && !this.extParams.isEmpty();
    }
}

