/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.AbstractIcalObject;
import com.google.ical.values.DateValue;
import com.google.ical.values.IcalValueType;
import com.google.ical.values.RRuleSchema;
import com.google.ical.values.TimeValue;
import java.text.ParseException;
import java.util.Map;
import java.util.TimeZone;

public class RDateList
extends AbstractIcalObject {
    private TimeZone tzid;
    private DateValue[] datesUtc;
    private IcalValueType valueType;

    public RDateList(String string, TimeZone timeZone) throws ParseException {
        this.setTzid(timeZone);
        this.parse(string, RRuleSchema.instance());
    }

    public RDateList(TimeZone timeZone) {
        this.setTzid(timeZone);
        this.setName("RDATE");
        this.datesUtc = new DateValue[0];
    }

    public TimeZone getTzid() {
        return this.tzid;
    }

    public void setTzid(TimeZone timeZone) {
        assert (null != timeZone);
        this.tzid = timeZone;
    }

    public DateValue[] getDatesUtc() {
        return null != this.datesUtc ? (DateValue[])this.datesUtc.clone() : null;
    }

    public void setDatesUtc(DateValue[] dateValueArray) {
        this.datesUtc = (DateValue[])dateValueArray.clone();
        if (dateValueArray.length > 0) {
            this.setValueType(dateValueArray[0] instanceof TimeValue ? IcalValueType.DATE_TIME : IcalValueType.DATE);
        }
    }

    public IcalValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(IcalValueType icalValueType) {
        this.valueType = icalValueType;
    }

    @Override
    public String toIcal() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName().toUpperCase());
        stringBuilder.append(";TZID=\"").append(this.tzid.getID()).append('\"');
        stringBuilder.append(";VALUE=").append(this.valueType.toIcal());
        if (this.hasExtParams()) {
            for (Map.Entry object : this.getExtParams().entrySet()) {
                String string = (String)object.getKey();
                String string2 = (String)object.getValue();
                if (ICAL_SPECIALS.matcher(string2).find()) {
                    string2 = "\"" + string2 + "\"";
                }
                stringBuilder.append(';').append(string).append('=').append(string2);
            }
        }
        stringBuilder.append(':');
        for (int i = 0; i < this.datesUtc.length; ++i) {
            if (0 != i) {
                stringBuilder.append(',');
            }
            DateValue dateValue = this.datesUtc[i];
            stringBuilder.append(dateValue);
            if (!(dateValue instanceof TimeValue)) continue;
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }
}

