/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.IcalObject;
import com.google.ical.values.IcalParseUtil;
import com.google.ical.values.IcalSchema;
import com.google.ical.values.IcalValueType;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RRuleSchema
extends IcalSchema {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMI = Pattern.compile(";");
    private static final Pattern X_NAME_RE = Pattern.compile("^X-", 2);
    private static final Pattern RRULE_PARTS = Pattern.compile("^(FREQ|UNTIL|COUNT|INTERVAL|BYSECOND|BYMINUTE|BYHOUR|BYDAY|BYMONTHDAY|BYYEARDAY|BYWEEKDAY|BYWEEKNO|BYMONTH|BYSETPOS|WKST|X-[A-Z0-9\\-]+)=(.*)", 2);
    private static final Pattern NUM_DAY = Pattern.compile("^([+\\-]?\\d\\d?)?(SU|MO|TU|WE|TH|FR|SA)$", 2);
    private static final Map<String, IcalSchema.ParamRule> PARAM_RULES;
    private static final Map<String, IcalSchema.ContentRule> CONTENT_RULES;
    private static final Map<String, IcalSchema.ObjectRule> OBJECT_RULES;
    private static final Map<String, IcalSchema.XformRule> XFORM_RULES;

    static RRuleSchema instance() {
        return new RRuleSchema();
    }

    private RRuleSchema() {
        super(PARAM_RULES, CONTENT_RULES, OBJECT_RULES, XFORM_RULES);
    }

    private static int[] parseIntList(String string, int n, int n2, IcalSchema icalSchema) throws ParseException {
        String[] stringArray = COMMA.split(string);
        int[] nArray = new int[stringArray.length];
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            try {
                int n4 = Integer.parseInt(stringArray[n3]);
                int n5 = Math.abs(n4);
                if (n > n5 || n2 < n5) {
                    icalSchema.badPart(string, null);
                }
                nArray[n3] = n4;
            }
            catch (NumberFormatException numberFormatException) {
                icalSchema.badPart(string, numberFormatException.getMessage());
            }
        }
        return nArray;
    }

    private static int[] parseUnsignedIntList(String string, int n, int n2, IcalSchema icalSchema) throws ParseException {
        String[] stringArray = COMMA.split(string);
        int[] nArray = new int[stringArray.length];
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            try {
                int n4 = Integer.parseInt(stringArray[n3]);
                if (n > n4 || n2 < n4) {
                    icalSchema.badPart(string, null);
                }
                nArray[n3] = n4;
            }
            catch (NumberFormatException numberFormatException) {
                icalSchema.badPart(string, numberFormatException.getMessage());
            }
        }
        return nArray;
    }

    static {
        HashMap<String, IcalSchema.ParamRule> hashMap = new HashMap<String, IcalSchema.ParamRule>();
        HashMap<String, IcalSchema.ContentRule> hashMap2 = new HashMap<String, IcalSchema.ContentRule>();
        HashMap<String, IcalSchema.ObjectRule> hashMap3 = new HashMap<String, IcalSchema.ObjectRule>();
        HashMap<String, IcalSchema.XformRule> hashMap4 = new HashMap<String, IcalSchema.XformRule>();
        hashMap3.put("RRULE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema icalSchema, Map<String, String> map, String string, IcalObject icalObject) throws ParseException {
                icalSchema.applyParamsSchema("rrulparam", map, icalObject);
                icalSchema.applyContentSchema("recur", string, icalObject);
            }
        });
        hashMap3.put("EXRULE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema icalSchema, Map<String, String> map, String string, IcalObject icalObject) throws ParseException {
                icalSchema.applyParamsSchema("exrparam", map, icalObject);
                icalSchema.applyContentSchema("recur", string, icalObject);
            }
        });
        IcalSchema.ParamRule paramRule = new IcalSchema.ParamRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, String string2, IcalObject icalObject) throws ParseException {
                icalSchema.badParam(string, string2);
            }
        };
        hashMap.put("rrulparam", paramRule);
        hashMap.put("exrparam", paramRule);
        hashMap2.put("recur", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                String[] stringArray = SEMI.split(string);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String object = stringArray[i];
                    Matcher matcher = RRULE_PARTS.matcher(object);
                    if (!matcher.matches()) {
                        icalSchema.badPart(object, null);
                    }
                    String string2 = matcher.group(1).toUpperCase();
                    String string3 = matcher.group(2);
                    if (hashMap.containsKey(string2)) {
                        icalSchema.dupePart(object);
                    }
                    hashMap.put(string2, string3);
                }
                if (!hashMap.containsKey("FREQ")) {
                    icalSchema.missingPart("FREQ", string);
                }
                if (hashMap.containsKey("UNTIL") && hashMap.containsKey("COUNT")) {
                    icalSchema.badPart(string, "UNTIL & COUNT are exclusive");
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (X_NAME_RE.matcher((CharSequence)entry.getKey()).matches()) continue;
                    icalSchema.applyContentSchema((String)entry.getKey(), (String)entry.getValue(), icalObject);
                }
            }
        });
        hashMap3.put("EXDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema icalSchema, Map<String, String> map, String string, IcalObject icalObject) throws ParseException {
                icalSchema.applyParamsSchema("exdtparam", map, icalObject);
                for (String string2 : COMMA.split(string)) {
                    icalSchema.applyContentSchema("exdtval", string2, icalObject);
                }
            }
        });
        hashMap2.put("FREQ", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setFreq((Frequency)((Object)icalSchema.applyXformSchema("freq", string)));
            }
        });
        hashMap2.put("UNTIL", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setUntil((DateValue)icalSchema.applyXformSchema("enddate", string));
            }
        });
        hashMap2.put("COUNT", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setCount(Integer.parseInt(string));
            }
        });
        hashMap2.put("INTERVAL", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setInterval(Integer.parseInt(string));
            }
        });
        hashMap2.put("BYSECOND", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setBySecond((int[])icalSchema.applyXformSchema("byseclist", string));
            }
        });
        hashMap2.put("BYMINUTE", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByMinute((int[])icalSchema.applyXformSchema("byminlist", string));
            }
        });
        hashMap2.put("BYHOUR", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByHour((int[])icalSchema.applyXformSchema("byhrlist", string));
            }
        });
        hashMap2.put("BYDAY", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByDay((List)icalSchema.applyXformSchema("bywdaylist", string));
            }
        });
        hashMap2.put("BYMONTHDAY", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByMonthDay((int[])icalSchema.applyXformSchema("bymodaylist", string));
            }
        });
        hashMap2.put("BYYEARDAY", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByYearDay((int[])icalSchema.applyXformSchema("byyrdaylist", string));
            }
        });
        hashMap2.put("BYWEEKNO", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByWeekNo((int[])icalSchema.applyXformSchema("bywknolist", string));
            }
        });
        hashMap2.put("BYMONTH", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setByMonth((int[])icalSchema.applyXformSchema("bymolist", string));
            }
        });
        hashMap2.put("BYSETPOS", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setBySetPos((int[])icalSchema.applyXformSchema("bysplist", string));
            }
        });
        hashMap2.put("WKST", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                ((RRule)icalObject).setWkSt((Weekday)((Object)icalSchema.applyXformSchema("weekday", string)));
            }
        });
        hashMap4.put("freq", new IcalSchema.XformRule(){

            public Frequency apply(IcalSchema icalSchema, String string) throws ParseException {
                return Frequency.valueOf(string);
            }
        });
        hashMap4.put("enddate", new IcalSchema.XformRule(){

            @Override
            public DateValue apply(IcalSchema icalSchema, String string) throws ParseException {
                return IcalParseUtil.parseDateValue(string.toUpperCase());
            }
        });
        hashMap4.put("byseclist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(string, 0, 59, icalSchema);
            }
        });
        hashMap4.put("byminlist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(string, 0, 59, icalSchema);
            }
        });
        hashMap4.put("byhrlist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseUnsignedIntList(string, 0, 23, icalSchema);
            }
        });
        hashMap4.put("bywdaylist", new IcalSchema.XformRule(){

            @Override
            public List<WeekdayNum> apply(IcalSchema icalSchema, String string) throws ParseException {
                String[] stringArray = COMMA.split(string);
                ArrayList<WeekdayNum> arrayList = new ArrayList<WeekdayNum>(stringArray.length);
                for (String string2 : stringArray) {
                    int n;
                    Matcher matcher = NUM_DAY.matcher(string2);
                    if (!matcher.matches()) {
                        icalSchema.badPart(string2, null);
                    }
                    Weekday weekday = Weekday.valueOf(matcher.group(2).toUpperCase());
                    String string3 = matcher.group(1);
                    if (null == string3 || "".equals(string3)) {
                        n = 0;
                    } else {
                        int n2;
                        n = Integer.parseInt(string3);
                        int n3 = n2 = n < 0 ? -n : n;
                        if (1 > n2 || 53 < n2) {
                            icalSchema.badPart(string2, null);
                        }
                    }
                    arrayList.add(new WeekdayNum(n, weekday));
                }
                return arrayList;
            }
        });
        hashMap4.put("weekday", new IcalSchema.XformRule(){

            public Weekday apply(IcalSchema icalSchema, String string) throws ParseException {
                return Weekday.valueOf(string.toUpperCase());
            }
        });
        hashMap4.put("bymodaylist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseIntList(string, 1, 31, icalSchema);
            }
        });
        hashMap4.put("byyrdaylist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseIntList(string, 1, 366, icalSchema);
            }
        });
        hashMap4.put("bywknolist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseIntList(string, 1, 53, icalSchema);
            }
        });
        hashMap4.put("bymolist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseIntList(string, 1, 12, icalSchema);
            }
        });
        hashMap4.put("bysplist", new IcalSchema.XformRule(){

            public int[] apply(IcalSchema icalSchema, String string) throws ParseException {
                return RRuleSchema.parseIntList(string, 1, 366, icalSchema);
            }
        });
        hashMap3.put("RDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema icalSchema, Map<String, String> map, String string, IcalObject icalObject) throws ParseException {
                icalSchema.applyParamsSchema("rdtparam", map, icalObject);
                icalSchema.applyContentSchema("rdtval", string, icalObject);
            }
        });
        hashMap3.put("EXDATE", new IcalSchema.ObjectRule(){

            @Override
            public void apply(IcalSchema icalSchema, Map<String, String> map, String string, IcalObject icalObject) throws ParseException {
                icalSchema.applyParamsSchema("rdtparam", map, icalObject);
                icalSchema.applyContentSchema("rdtval", string, icalObject);
            }
        });
        hashMap.put("rdtparam", new IcalSchema.ParamRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, String string2, IcalObject icalObject) throws ParseException {
                if ("value".equalsIgnoreCase(string)) {
                    if ("date-time".equalsIgnoreCase(string2) || "date".equalsIgnoreCase(string2) || "period".equalsIgnoreCase(string2)) {
                        ((RDateList)icalObject).setValueType(IcalValueType.fromIcal(string2));
                    } else {
                        icalSchema.badParam(string, string2);
                    }
                } else if ("tzid".equalsIgnoreCase(string)) {
                    TimeZone timeZone;
                    if (string2.startsWith("/")) {
                        string2 = string2.substring(1).trim();
                    }
                    if (null == (timeZone = TimeUtils.timeZoneForName(string2.replaceAll(" ", "_")))) {
                        icalSchema.badParam(string, string2);
                    }
                    ((RDateList)icalObject).setTzid(timeZone);
                } else {
                    icalSchema.badParam(string, string2);
                }
            }
        });
        hashMap.put("rrulparam", paramRule);
        hashMap.put("exrparam", paramRule);
        hashMap2.put("rdtval", new IcalSchema.ContentRule(){

            @Override
            public void apply(IcalSchema icalSchema, String string, IcalObject icalObject) throws ParseException {
                RDateList rDateList = (RDateList)icalObject;
                String[] stringArray = COMMA.split(string);
                DateValue[] dateValueArray = new DateValue[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    dateValueArray[i] = IcalParseUtil.parseDateValue(string2, rDateList.getTzid());
                }
                rDateList.setDatesUtc(dateValueArray);
            }
        });
        PARAM_RULES = Collections.unmodifiableMap(hashMap);
        CONTENT_RULES = Collections.unmodifiableMap(hashMap2);
        OBJECT_RULES = Collections.unmodifiableMap(hashMap3);
        XFORM_RULES = Collections.unmodifiableMap(hashMap4);
    }
}

