/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;

public enum Weekday {
    SU(0),
    MO(1),
    TU(2),
    WE(3),
    TH(4),
    FR(5),
    SA(6);

    public final int jsDayNum;
    public final int javaDayNum;
    private static Weekday[] VALUES;

    private Weekday(int n2) {
        this.jsDayNum = n2;
        this.javaDayNum = 1 + n2;
    }

    public static Weekday valueOf(DateValue dateValue) {
        int n = TimeUtils.fixedFromGregorian(dateValue.year(), dateValue.month(), dateValue.day()) % 7;
        if (n < 0) {
            n += 7;
        }
        return VALUES[n];
    }

    public static Weekday firstDayOfWeekInMonth(int n, int n2) {
        int n3 = TimeUtils.fixedFromGregorian(n, n2, 1) % 7;
        return VALUES[n3 >= 0 ? n3 : n3 + 7];
    }

    public Weekday successor() {
        return VALUES[(this.ordinal() + 1) % 7];
    }

    public Weekday predecessor() {
        return VALUES[(this.ordinal() - 1 + 7) % 7];
    }

    static {
        VALUES = new Weekday[7];
        System.arraycopy(Weekday.values(), 0, VALUES, 0, 7);
    }
}

