package org.openqa.selenium.devtools.v115.browser.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Browser command ids used by executeBrowserCommand.
 */
@org.openqa.selenium.Beta()
public enum BrowserCommandId {

    OPENTABSEARCH("openTabSearch"), CLOSETABSEARCH("closeTabSearch");

    private String value;

    BrowserCommandId(String value) {
        this.value = value;
    }

    public static BrowserCommandId fromString(String s) {
        return java.util.Arrays.stream(BrowserCommandId.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within BrowserCommandId "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static BrowserCommandId fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
