/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public class RoutableHttpClientFactory
implements HttpClient.Factory {
    private final URL self;
    private final CombinedHandler handler;
    private final HttpClient.Factory delegate;

    public RoutableHttpClientFactory(URL self, CombinedHandler handler, HttpClient.Factory delegate) {
        this.self = (URL)Require.nonNull((String)"URL", (Object)self);
        this.handler = (CombinedHandler)Require.nonNull((String)"Handler", (Object)handler);
        this.delegate = (HttpClient.Factory)Require.nonNull((String)"Delegate", (Object)delegate);
    }

    public HttpClient createClient(ClientConfig config) {
        Require.nonNull((String)"Client config", (Object)config);
        URI url = config.baseUri();
        if (this.self.getProtocol().equals(url.getScheme()) && this.self.getHost().equals(url.getHost()) && this.self.getPort() == url.getPort()) {
            return new HttpClient(){

                public HttpResponse execute(HttpRequest request) throws UncheckedIOException {
                    HttpResponse response = new HttpResponse();
                    if (!RoutableHttpClientFactory.this.handler.test(request)) {
                        response.setStatus(404);
                        response.setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)request.getUri(), (Object)"message", (Object)("Unable to route " + request), (Object)"error", (Object)UnsupportedCommandException.class.getName())));
                        return response;
                    }
                    return RoutableHttpClientFactory.this.handler.execute(request);
                }

                public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
                    throw new UnsupportedOperationException("openSocket");
                }
            };
        }
        return this.delegate.createClient(config);
    }

    public void cleanupIdleClients() {
        this.delegate.cleanupIdleClients();
    }
}

