/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springframework.util.CollectionUtils;

public class AbstractSwaggerIndexTransformer {
    protected SwaggerUiOAuthProperties swaggerUiOAuthProperties;
    protected ObjectMapper objectMapper;
    protected SwaggerUiConfigProperties swaggerUiConfig;

    public AbstractSwaggerIndexTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.swaggerUiOAuthProperties = swaggerUiOAuthProperties;
        this.objectMapper = objectMapper;
    }

    protected String addInitOauth(String html) throws JsonProcessingException {
        StringBuilder stringBuilder = new StringBuilder("window.ui = ui\n");
        stringBuilder.append("ui.initOAuth(\n");
        String json = this.objectMapper.writeValueAsString(this.swaggerUiOAuthProperties.getConfigParameters());
        stringBuilder.append(json);
        stringBuilder.append(")");
        return html.replace("window.ui = ui", stringBuilder.toString());
    }

    protected String readFullyAsString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    protected String overwriteSwaggerDefaultUrl(String html) {
        return html.replace("https://petstore.swagger.io/v2/swagger.json", "");
    }

    protected boolean hasDefaultTransformations() {
        boolean oauth2Configured = !CollectionUtils.isEmpty(this.swaggerUiOAuthProperties.getConfigParameters());
        return oauth2Configured || this.swaggerUiConfig.isDisableSwaggerDefaultUrl() || this.swaggerUiConfig.isCsrfEnabled();
    }

    protected String defaultTransformations(InputStream inputStream) throws IOException {
        String html = this.readFullyAsString(inputStream);
        if (!CollectionUtils.isEmpty(this.swaggerUiOAuthProperties.getConfigParameters())) {
            html = this.addInitOauth(html);
        }
        if (this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
            html = this.overwriteSwaggerDefaultUrl(html);
        }
        if (this.swaggerUiConfig.isCsrfEnabled()) {
            html = this.addCSRF(html);
        }
        return html;
    }

    protected String addCSRF(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("requestInterceptor: function() {\n");
        stringBuilder.append("const value = `; ${document.cookie}`;\n");
        stringBuilder.append("const parts = value.split(`; ");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getCookieName());
        stringBuilder.append("=`);\n");
        stringBuilder.append("console.log(parts);\n");
        stringBuilder.append("if (parts.length === 2)\n");
        stringBuilder.append("this.headers['");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getHeaderName());
        stringBuilder.append("'] = parts.pop().split(';').shift();\n");
        stringBuilder.append("return this;\n");
        stringBuilder.append("},\n");
        stringBuilder.append("presets: [");
        return html.replace("presets: [", stringBuilder.toString());
    }
}

