/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpResponse;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanCustomizer;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.cloud.sleuth.http.HttpResponse;
import org.springframework.cloud.sleuth.http.HttpResponseParser;

public class BraveHttpResponseParser
implements HttpResponseParser {
    final brave.http.HttpResponseParser delegate;

    public BraveHttpResponseParser(brave.http.HttpResponseParser delegate) {
        this.delegate = delegate;
    }

    public void parse(HttpResponse response, TraceContext context, SpanCustomizer span) {
        this.delegate.parse(BraveHttpResponse.toBrave(response), BraveTraceContext.toBrave(context), BraveSpanCustomizer.toBrave(span));
    }

    public static brave.http.HttpResponseParser toBrave(HttpResponseParser parser) {
        if (parser instanceof BraveHttpResponseParser) {
            return ((BraveHttpResponseParser)parser).delegate;
        }
        return (response, context, span) -> parser.parse(BraveHttpResponse.fromBrave(response), BraveTraceContext.fromBrave(context), BraveSpanCustomizer.fromBrave(span));
    }
}

