/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.http.HttpServerRequest;
import java.util.Collection;
import java.util.Collections;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.brave.bridge.BraveHttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;

class BraveHttpServerResponse
implements HttpServerResponse {
    final brave.http.HttpServerResponse delegate;

    BraveHttpServerResponse(brave.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public String method() {
        return this.delegate.method();
    }

    public String route() {
        return this.delegate.route();
    }

    public int statusCode() {
        return this.delegate.statusCode();
    }

    public Object unwrap() {
        return this.delegate.unwrap();
    }

    public Collection<String> headerNames() {
        return Collections.emptyList();
    }

    public Span.Kind spanKind() {
        return Span.Kind.valueOf((String)this.delegate.spanKind().name());
    }

    public org.springframework.cloud.sleuth.http.HttpServerRequest request() {
        HttpServerRequest request = this.delegate.request();
        if (request == null) {
            return null;
        }
        return new BraveHttpServerRequest(request);
    }

    public Throwable error() {
        return this.delegate.error();
    }

    static brave.http.HttpServerResponse toBrave(final HttpServerResponse response) {
        if (response == null) {
            return null;
        }
        if (response instanceof BraveHttpServerResponse) {
            return ((BraveHttpServerResponse)response).delegate;
        }
        return new brave.http.HttpServerResponse(){

            public HttpServerRequest request() {
                return BraveHttpServerRequest.toBrave(response.request());
            }

            public Throwable error() {
                return response.error();
            }

            public String method() {
                return response.method();
            }

            public String route() {
                return response.route();
            }

            public String toString() {
                return response.toString();
            }

            public int statusCode() {
                return response.statusCode();
            }

            public Object unwrap() {
                return response.unwrap();
            }
        };
    }
}

