/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binding.BindingBeanDefinitionRegistryUtils;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class BindingBeansRegistrar
implements ImportBeanDefinitionRegistrar {
    private Log logger = LogFactory.getLog(this.getClass());

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attrs = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)ClassUtils.resolveClassName((String)metadata.getClassName(), null), EnableBinding.class);
        try {
            for (Class<?> type : this.collectClasses(attrs, metadata.getClassName())) {
                if (registry.containsBeanDefinition(type.getName())) continue;
                BindingBeanDefinitionRegistryUtils.registerBindingTargetBeanDefinitions(type, type.getName(), registry);
                BindingBeanDefinitionRegistryUtils.registerBindingTargetsQualifiedBeanDefinitions(ClassUtils.resolveClassName((String)metadata.getClassName(), null), type, registry);
            }
        }
        catch (Throwable e) {
            this.logger.warn((Object)"Failed to proxy EnableBinding annotation. If you are using functional programming style, ignore this warning, otherwise, annotation-based programming model is not and will not be suppported in native images.");
        }
    }

    private Class<?>[] collectClasses(AnnotationAttributes attrs, String className) {
        EnableBinding enableBinding = (EnableBinding)AnnotationUtils.synthesizeAnnotation((Map)attrs, EnableBinding.class, (AnnotatedElement)ClassUtils.resolveClassName((String)className, null));
        return enableBinding.value();
    }
}

